<?php

function get_cross_sells_by_sku_10($sku) {
    // 1. Δήλωση Static Variable για αποθήκευση της χαρτογράφησης
    static $map = null;
    $related_ids = [];

    if (empty($sku) || strlen($sku) < 10) return '';
    $prefix = substr($sku, 0, 10);
    
    // 2. Έλεγχος: Φόρτωση του XML και δημιουργία χαρτογράφησης ΜΟΝΟ αν η $map είναι NULL
    if ($map === null) {
        
        // 🚨 Βεβαιωθείτε ότι το URL είναι σωστό
        $xml_url = 'https://likeme.gr/wp-load.php?security_token=d3ebf587b9f63cc0&export_id=39&action=get_data'; 
        
        // Χρήση wp_remote_get για καλύτερη συμβατότητα με WordPress
        $response = wp_remote_get($xml_url);
        
        if (is_wp_error($response) || wp_remote_retrieve_response_code($response) != 200) {
            // Αν αποτύχει η φόρτωση, ορίζουμε $map σε κενό array για να μην ξαναπροσπαθήσει
            $map = []; 
            return '';
        }
        
        $xml_string = wp_remote_retrieve_body($response);
        $xml = simplexml_load_string($xml_string);
        
        if (!$xml) {
            $map = [];
            return '';
        }
        
        $map = []; // Αρχικοποίηση της $map
        
        // Δημιουργία της χαρτογράφησης (prefix -> array of SKUs)
        foreach ($xml->product as $product) {
            $product_sku = (string)$product->sku;
            if (strlen($product_sku) < 10) continue;

            $product_prefix = substr($product_sku, 0, 10);

            if (!isset($map[$product_prefix])) {
                $map[$product_prefix] = [];
            }
            
            $map[$product_prefix][] = $product_sku;
        }
    }
    
    // 3. Χρήση της χαρτογράφησης (είτε από τη static, είτε μετά τη φόρτωση)
    if (!isset($map[$prefix])) return '';

    // 4. Μετατροπή των σχετικών SKUs σε Product IDs
    foreach ($map[$prefix] as $related_sku) {
        if ($related_sku === $sku) continue; // Εξαιρούμε το τρέχον προϊόν

        // Η wc_get_product_id_by_sku εξακολουθεί να είναι η πιο αργή κλήση
        $related_id = wc_get_product_id_by_sku($related_sku);
        if ($related_id) {
            $related_ids[] = $related_id;
        }
    }

    return implode(',', $related_ids); 
}

?>