<?php
/**
 * Enqueue script and styles for child theme
 */
function woodmart_child_enqueue_styles() {
	wp_enqueue_style( 'child-style', get_stylesheet_directory_uri() . '/style.css', array( 'woodmart-style' ), woodmart_get_theme_info( 'Version' ) );
}
add_action( 'wp_enqueue_scripts', 'woodmart_child_enqueue_styles', 10010 );







add_filter( 'woodmart_update_fragments_fix', '__return_false' );
add_filter( 'woodmart_get_prev_product_same_term', '__return_true' );
// Custom checkbox for auto generation of the variations SKUs
add_action('woocommerce_product_options_advanced', 'additional_product_options_advanced_custom_checkbox');
function additional_product_options_advanced_custom_checkbox()
{
    global $post;

    echo '<div class="options_group show_if_variable hidden">';

    // Custom checkbox located on Advanced tab settings
    woocommerce_wp_checkbox( array(
        'id'          => 'generate_variations_skus',
        'label'       => __('Generate variations SKUs', 'woocommerce'),
        'description' => __('Auto Generation of the variations SKUs from variable sku', 'woocommerce'),
        'desc_tip'    => 'true'
    ));

    echo '</div>';
}

// Auto generate the variations SKUs
add_action( 'woocommerce_admin_process_product_object', 'wc_auto_generate_variations_skus', 10, 1 );
function wc_auto_generate_variations_skus( $product ) {

    if( $product->is_type('variable') && isset($_POST['generate_variations_skus']) ) {
        $parent_sku   = $product->get_sku();
        $children_ids = $product->get_children();
        $count        = 0;

        // Loop through the variations Ids
        foreach( $children_ids as $child_id ){
            $count++;

            // Get an instance of the WC_Product_Variation object
            $variation = wc_get_product($child_id);

            // Set the prefix length based on variations count
            $prefix = sizeof($children_ids) < 100 ? sprintf('%02d', $count) : sprintf('%03d', $count);

            // Generate and set the sku
            $variation->set_sku( $parent_sku . '-' . $prefix );

            // Save variation
            $variation->save();
        }
    }
}

add_action( 'woocommerce_thankyou', 'woocommerce_custom_thank_you_page');

function woocommerce_custom_thank_you_page( $order_id ){
	$order = wc_get_order( $order_id );
	$order_ids = array();
	foreach ( $order->get_items() as $item_id => $item ) {
		$product_id = $item->get_product_id();
		$order_ids[] = $product_id;
	}
	$product_ids = implode(",", $order_ids);
	echo '<input type="hidden" class="thankyou-pro-ids" value="'.$product_ids.'">';
}


// Web Expert

add_filter('webexpert_smart_cart_invoice_toggle',function(){
     return "_billing_timologio";
},10,1);

add_filter('webexpert_smart_cart_billing_activity',function(){
     return "_billing_store";
},10,1);

add_filter('webexpert_smart_cart_billing_vat_id',function(){
     return "_billing_vat";
},10,1);

add_filter('webexpert_smart_cart_billing_tax_office',function(){
     return "_billing_irs";
},10,1);

  add_action('admin_init', 'iben_ccenter_add_custom_acccounts');
  
	function iben_ccenter_add_custom_acccounts(){
  
		// REQUIRE courier center V1.3.0
		if ( ! class_exists( 'Iben_Woo_Ccenter_Admin_Woo' ) ) return;
		if ( ! is_admin() ) return;
		if ( !current_user_can( 'edit_shop_orders' ) ) return;

		//display admin bar which account is assigned
		add_filter( 'iben_ccenter_filter_display_multiaccount_message', '__return_true' );
		//display account column in vouchers list
		add_filter( 'iben_ccenter_filter_vouchers_display_account_column', '__return_true' );		
	

		$current_id = get_current_user_id();
		
		// ADMIN ID	
		if ($current_id == 2){			
	
			//billing_code
			add_filter( 'iben_ccenter_filter_main_settings_billtocode', function($default_value ) {
				return '100-2345-0022';
			}, 10);											

		}		

	}

function iben_elta_change_phone_format($phone){
    // Remove spaces
    $phone = str_replace(" ","",$phone);

    // Remove +3, 30, or +30 from the beginning
    $phone = preg_replace("/^\+?3(0)?/", '', $phone);

    // If the length is not 10 characters, return null or some default error message
    if (strlen($phone) !== 10) {
        return null; // or return "Invalid number" or similar message
    }

    return $phone;
}

add_filter('iben_elta_phone_format', 'iben_elta_change_phone_format', 10);



