<?php

function woo_shipping_update_options() {
	$page_no  = filter_input( INPUT_POST, 'save', FILTER_SANITIZE_NUMBER_INT );
	if (isset($page_no)) {

		$slm_shipping_service  = filter_input( INPUT_POST, 'slm_shipping_service', FILTER_SANITIZE_STRING );

		if (!isset($slm_shipping_service) || !wp_verify_nonce($slm_shipping_service, '64e6c998')) {
			die('Failed verifying nonce.');
		}

		

		$slm_api_url_get_value  = filter_input( INPUT_POST, 'slm_api_url', FILTER_SANITIZE_STRING );
		$slm_map_url_get_value  = filter_input( INPUT_POST, 'slm_map_url', FILTER_SANITIZE_STRING );
		$slm_api_token_get_value  = filter_input( INPUT_POST, 'slm_api_token', FILTER_SANITIZE_STRING );
		$slm_plcode_get_value  = filter_input( INPUT_POST, 'slm_plcodes', FILTER_SANITIZE_STRING );
		$slm_partner_id_get_value  = filter_input( INPUT_POST, 'slm_partner_id', FILTER_SANITIZE_STRING );
		$slm_store_phone_get_value  = filter_input( INPUT_POST, 'slm_store_phone', FILTER_SANITIZE_STRING );
		$slm_status_on_create_get_value  = filter_input( INPUT_POST, 'slm_status_on_create', FILTER_SANITIZE_STRING );
		$slm_status_on_cancel_get_value  = filter_input( INPUT_POST, 'slm_status_on_cancel', FILTER_SANITIZE_STRING );
		$slm_status_on_fail_get_value  = filter_input( INPUT_POST, 'slm_status_on_fail', FILTER_SANITIZE_STRING );
		$slm_status_on_complete_get_value  = filter_input( INPUT_POST, 'slm_status_on_complete', FILTER_SANITIZE_STRING );
		$slm_enable_weight_get_value  = filter_input( INPUT_POST, 'slm_enable_weight', FILTER_SANITIZE_STRING );
		$slm_map_type_get_value  = filter_input( INPUT_POST, 'slm_map_type', FILTER_SANITIZE_STRING );
		$slm_include_categories_get_value  = filter_input( INPUT_POST, 'slm_include_categories', FILTER_SANITIZE_STRING );
		$slm_soft_include_get_value  = filter_input( INPUT_POST, 'slm_soft_include', FILTER_SANITIZE_STRING );


		$slm_api_url = sanitize_text_field($slm_api_url_get_value);
		$slm_api_url = sanitizeUrl($slm_api_url);
		update_option('slm_api_url', $slm_api_url, '', 'yes');

		$slm_map_url = sanitize_text_field($slm_map_url_get_value);
		$slm_map_url = sanitizeUrl($slm_map_url);
		update_option('slm_map_url', $slm_map_url, '', 'yes');

		$slm_api_token = sanitize_text_field($slm_api_token_get_value);
		update_option('slm_api_token', $slm_api_token, '', 'yes');

		$slm_plcode_get_value = preg_replace('/\s+/', '', $slm_plcode_get_value);
		$slm_plcode_get_value = preg_replace('/,$/', '', $slm_plcode_get_value);

		$slm_plcodes = sanitize_text_field($slm_plcode_get_value);

		update_option('slm_plcodes', $slm_plcodes, '', 'yes');
		$slm_partner_id = sanitize_text_field($slm_partner_id_get_value);
		update_option('slm_partner_id', $slm_partner_id, '', 'yes');
		$slm_store_phone = sanitize_text_field($slm_store_phone_get_value);

		update_option('slm_store_phone', $slm_store_phone, '', 'yes');
		$slm_status_on_create = sanitize_text_field($slm_status_on_create_get_value);

		update_option('slm_status_on_create', $slm_status_on_create, '', 'yes');
		$slm_status_on_cancel = sanitize_text_field($slm_status_on_cancel_get_value);

		update_option('slm_status_on_cancel', $slm_status_on_cancel, '', 'yes');
		$slm_status_on_fail = sanitize_text_field($slm_status_on_fail_get_value);

		update_option('slm_status_on_fail', $slm_status_on_fail, '', 'yes');
		$slm_status_on_complete = sanitize_text_field($slm_status_on_complete_get_value);

		update_option('slm_status_on_complete', $slm_status_on_complete, '', 'yes');

		$slm_enable_weight = sanitize_text_field($slm_enable_weight_get_value);

		update_option('slm_enable_weight', $slm_enable_weight, '', 'yes');


		$slm_soft_include = sanitize_text_field($slm_soft_include_get_value);
		
		update_option('slm_soft_include', $slm_soft_include, '', 'yes');


		$slm_map_type = sanitize_text_field($slm_map_type_get_value);

		update_option('slm_map_type', $slm_map_type, '', 'yes');


		if (!empty($slm_include_categories_get_value)) {
			$slm_include_categories = sanitize_text_field($slm_include_categories_get_value);
			update_option('slm_include_categories', $slm_include_categories, '', 'yes');
		} else{
			$slm_include_categories = sanitize_text_field('');
			update_option('slm_include_categories', $slm_include_categories, '', 'yes');
		}


		$required_fields = [$slm_api_url_get_value, $slm_map_url_get_value, 
		$slm_api_token_get_value, $slm_plcode_get_value, $slm_store_phone_get_value];

		foreach ($required_fields as $field) {
			if (empty($field)) {

				add_action( 'admin_notices', function() {

					echo "<div id=\"message\" class=\"notice notice-error is-dismissible\"><p>Not all required fields are filled. Please fill all required fields.</p></div>";
					
				});

				return ;  
			}
		}

	}
}

function sanitizeUrl($url){
	if(isset($url) && !empty($url)){
		if(substr($url, -1) === '/'){
			$url = substr($url, 0, -1);
		}
		
		if(strpos($url, 'localhost') === FALSE ){
			$url = str_replace('http://', 'https://', $url);
		}
	}

	return $url;
}

?>