<?php

function woo_shipping_settings_page() {
	
	if (!defined('ABSPATH')) {
		exit;
	}
	?>
	<?php
	wp_enqueue_script('jquery');
	wp_enqueue_script('jquery-ui-core');
	do_action('woocommerce_update_options_slm_service_settings');

	$wc_statuses = getWCOrderStatuses();
	$wc_categories = getWCcategories();

	$slm_api_url_get_value = get_option('slm_api_url');
	$slm_map_url_get_value = get_option('slm_map_url');
	$slm_api_token_get_value = get_option('slm_api_token');
	$slm_plcode_get_value = get_option('slm_plcodes');
	$slm_partner_id_get_value = get_option('slm_partner_id');
	$slm_store_phone_get_value = get_option('slm_store_phone');
	$slm_status_on_create_get_value  = get_option('slm_status_on_create');
	$slm_status_on_cancel_get_value = get_option('slm_status_on_cancel');
	$slm_status_on_fail_get_value = get_option('slm_status_on_fail');
	$slm_status_on_complete_get_value  = get_option('slm_status_on_complete');
	$slm_enable_weight_get_value = get_option('slm_enable_weight');
	$slm_map_type_get_value = get_option('slm_map_type');
	$slm_include_categories_get_value  = get_option('slm_include_categories');
	$slm_soft_include_get_value  = get_option('slm_soft_include');
	

	?>
	<h3><?php esc_html_e('SLM Delivery Service Settings', 'woo-slm-delivery-service'); ?></h3>
	<?php wp_nonce_field('64e6c998' ,'slm_shipping_service'); ?>

	<style>
		.slm-options-grid {
			display: grid;
			grid-template-columns: 200px 500px;
			padding: 10px;
			width: 700px;
		}

		#slm_include_categories_select{
			display: grid;
			grid-template-columns: auto auto;
			grid-auto-rows: min-content;
			overflow: scroll;
			height: 200px;
			row-gap: 15px;
			column-gap: 30px;
			align-items: center;
        	justify-content: start;
			font-size: 1rem;
			padding: 20px 0;
		}
		
	</style>

	<p>
		Please fill the necessary fields ( <span style='color: red'>*</span> ) 
	</p>
	<div>
		<p class='slm-options-grid'>
			<label for="slm_api_url">Base URL <span style='color: red'>*</span>
			</label>
			<input type="url" name="slm_api_url" required value="<?php echo $slm_api_url_get_value;?>" />
		</p>
		
		<p class='slm-options-grid' >
			<label for="slm_map_url">Map URL <span style='color: red'>*</span>
			</label>
			
			<input type="url" name="slm_map_url" required value="<?php echo $slm_map_url_get_value;?>" />
		</p>
		
		<p class='slm-options-grid' >
			<label for="slm_api_token">API Token <span style='color: red'>*</span>
			</label>
			<input type="text" name="slm_api_token" required value="<?php echo $slm_api_token_get_value;?>" />
		</p>
		
		<p class='slm-options-grid' >
			<label for="slm_plcodes">Pickup Location Code <span style='color: red'>*</span>
				<span class="woocommerce-help-tip" tabindex="0"  data-tip="Separate multiple pickup location codes by comma (,)"></span>
			</label>
			<input type="text" name="slm_plcodes" required value="<?php echo $slm_plcode_get_value;?>" />
		</p>
		
		<p class='slm-options-grid' >
			<label for="slm_partner_id">Partner Id
			</label>
			<input type="text" name="slm_partner_id" value="<?php echo $slm_partner_id_get_value;?>" />
		</p>
		
		<p class='slm-options-grid' >
			<label for="slm_store_phone">Store Phone <span style='color: red'>*</span>
				<span class="woocommerce-help-tip" tabindex="0"  data-tip="You need to store your phone so that the Service Level Manager (SLM) can contact you in any situation."></span>
			</label>
			
			<input type="text" name="slm_store_phone" required value="<?php echo $slm_store_phone_get_value;?>" />
		</p>
		
		<p class='slm-options-grid' >
			<label for="slm_status_on_create">WooCommerce Order Status on Voucher Create
				<span class="woocommerce-help-tip" tabindex="0"  data-tip="What WC Order status should be after the SLM Voucher is created."></span>
			</label>
			
			<select id="slm_status_on_create_select">
				<option value='slm_none_status'>Dont Change Status</option>
				<?php foreach ($wc_statuses as $status_code => $status){
					if($slm_status_on_create_get_value == $status_code){
						echo "<option selected value='{$status_code}'> {$status} </option>";
					}else{
						echo "<option value='{$status_code}'> {$status} </option>";
					}
					
				}
				?>
			</select>
			<input type="hidden" id="slm_status_on_create_hidden" name="slm_status_on_create" value="<?php echo $slm_status_on_create_get_value;?>" />
		</p>
		
		<p class='slm-options-grid' >
			<label for="slm_status_on_cancel">WooCommerce Order Status on Voucher Cancel
				<span class="woocommerce-help-tip" tabindex="0"  data-tip="What WC Order status should be after the SLM Voucher is cancelled."></span>
			</label>
			
			<select id="slm_status_on_cancel_select">
				<option value='slm_none_status'>Dont Change Status</option>
				<?php foreach ($wc_statuses as $status_code => $status){
					if($slm_status_on_cancel_get_value == $status_code){
						echo "<option selected value='{$status_code}'> {$status} </option>";
					}else{
						echo "<option value='{$status_code}'> {$status} </option>";
					}
					
				}
				?>
			</select>
			<input type="hidden" id="slm_status_on_cancel_hidden" name="slm_status_on_cancel" value="<?php echo $slm_status_on_cancel_get_value;?>" />
		</p>
		
		<p class='slm-options-grid' >
			<label for="slm_status_on_fail">WooCommerce Order Status on Voucher Fail
				<span class="woocommerce-help-tip" tabindex="0" data-tip="What WC Order status should be after the SLM Voucher is failed."></span>
			</label>
			
			<select id="slm_status_on_fail_select">
				<option value='slm_none_status'>Dont Change Status</option>
				<?php foreach ($wc_statuses as $status_code => $status){
					if($slm_status_on_fail_get_value == $status_code){
						echo "<option selected value='{$status_code}'> {$status} </option>";
					}else{
						echo "<option value='{$status_code}'> {$status} </option>";
					}
					
				}
				?>
			</select>
			<input type="hidden" id="slm_status_on_fail_hidden" name="slm_status_on_fail" value="<?php echo $slm_status_on_fail_get_value;?>" />
		</p>
		
		<p class='slm-options-grid' >
			<label for="slm_status_on_complete">WooCommerce Order Status on Voucher Complete
				<span class="woocommerce-help-tip" tabindex="0" data-tip="What WC Order status should be after the SLM Voucher is completed."></span>
			</label>
			
			<select id="slm_status_on_complete_select">
				<option value='slm_none_status'>Dont Change Status</option>
				<?php foreach ($wc_statuses as $status_code => $status){
					if($slm_status_on_complete_get_value == $status_code){
						echo "<option selected value='{$status_code}'> {$status} </option>";
					}else{
						echo "<option value='{$status_code}'> {$status} </option>";
					}
				}
				?>
			</select>
			<input type="hidden" id="slm_status_on_complete_hidden" name="slm_status_on_complete" value="<?php echo $slm_status_on_complete_get_value;?>" />
		</p>

		<p class='slm-options-grid' >
			<label for="slm_enable_weight">Calculate weight. 
				<span class="woocommerce-help-tip" tabindex="0" data-tip="SLM Delivery allows a maximum parcel weight of 25kg. When a customer attempts to place an order exceeding this weight limit, the option for SLM shipping will be deactivated. Accuracy of each product weight value is expected."></span>
			</label>
			
			<input type="checkbox" name="slm_enable_weight" <?php echo $slm_enable_weight_get_value == 'on' ? 'checked' : null ?> />
		</p>
		
		<p class='slm-options-grid' >
			<label for="slm_map_type">Choose map type. 
				<span class="woocommerce-help-tip" tabindex="0" data-tip="The &quot;popup&quot; method showcases the SLM Map
				 in a compact window atop the checkout page. Conversely, the &quot;iframe&quot;
				  method necessitates manual embedding using the shortcode [add-slm-map-iframe]."></span>
			</label>

			<select id="slm_map_type_select">
				<?php 
					echo  " <option ". ($slm_map_type_get_value === 'popup' ? 'selected' : '') . " value='popup'> popup </option>" 
					  	. " <option ". ($slm_map_type_get_value === 'iframe' ? 'selected' : '') . " value='iframe'> iframe </option>";
				?>
			</select>
			<input type="hidden" id="slm_map_type_select_hidden" name="slm_map_type" value="<?php echo $slm_map_type_get_value;?>" />
		</p>
		<hr>
		<div class='slm-options-grid'>

			<p>
				<label for="slm_include_categories"><strong>SLM Include Categories:</strong>
					<span class="woocommerce-help-tip" tabindex="0" data-tip="Only selected categories will allowed to be shipped with SLM. This dont include child categories if parent included."></span>
				</label>
	
				<div id="slm_include_categories_select">
					<?php 
						$slm_include_categories_get_value_to_array = explode(',',$slm_include_categories_get_value);
	
						foreach ($wc_categories as $category){
							if(in_array($category->term_id, $slm_include_categories_get_value_to_array)){
								echo "<label> {$category->name}</label> <input checked name='{$category->term_id}' type='checkbox'/> ";
							}else{
								echo "<label> {$category->name}</label> <input name='{$category->term_id}' type='checkbox'/>";
							}
						}
					?>
				</div>
	
				<input type="hidden" id="slm_include_categories_hidden" name="slm_include_categories" value="<?php echo $slm_include_categories_get_value;?>" />
			</p>
		</div>
		<hr>
		<p class='slm-options-grid' >
			<label for="slm_soft_include">Soft Include
				<span class="woocommerce-help-tip" tabindex="0" data-tip="For a product to be eligible for SLM Delivery. Disabled (Default): All categories of product must be included. Enabled: At least one category from the list of product categories must be included."></span>
			</label>
			
			<input type="checkbox" name="slm_soft_include" <?php echo $slm_soft_include_get_value == 'on' ? 'checked' : null ?> />
		</p>
		<hr>
	</div>
	<script>
			
		const statusSelectors = {
			"slm_status_on_create_select": "slm_status_on_create_hidden",
			"slm_status_on_cancel_select": "slm_status_on_cancel_hidden",
			"slm_status_on_fail_select": "slm_status_on_fail_hidden",
			"slm_status_on_complete_select": "slm_status_on_complete_hidden",
			"slm_map_type_select": "slm_map_type_select_hidden"
		};

		for (const selectId in statusSelectors) {
			const slm_status_on_x_select_element = document.querySelector(`#${selectId}`);
			const slm_status_on_x_select_hidden_element = document.querySelector(`#${statusSelectors[selectId]}`);
			
			if (slm_status_on_x_select_element) {
				slm_status_on_x_select_element.addEventListener('change', function(event) {
				const selectedValue = jQuery(event.target).val().toString();
				if (slm_status_on_x_select_hidden_element) {
					slm_status_on_x_select_hidden_element.value = selectedValue;
				}
				});
			}
		}

		jQuery('#slm_include_categories_select input').on('click', function() {

			const categoryId = parseInt(jQuery(this).attr('name'));
			const isChecked = jQuery(this).prop('checked');
			const slm_status_on_categories_select_hidden_element = document.querySelector(`#slm_include_categories_hidden`);
			if (slm_status_on_categories_select_hidden_element) {

				let categoryIds = [];
				if(slm_status_on_categories_select_hidden_element.value) {
					categoryIds = slm_status_on_categories_select_hidden_element.value.split(',').map(e => parseInt(e));
				}

				if(isChecked && !categoryIds.includes(categoryId)){
					categoryIds.push(categoryId);
				} else if(!isChecked && categoryIds.includes(categoryId)){
					
					const indexToRemove = categoryIds.indexOf(categoryId);
					if (indexToRemove !== -1) {
						categoryIds.splice(indexToRemove, 1);
					}
				}
				
				slm_status_on_categories_select_hidden_element.value = categoryIds.toString();

			}
			

		});


	</script>
	<?php
}

?>