<style>
	#slm-orders-table {
	font-family: Arial, Helvetica, sans-serif;
	border-collapse: collapse;
	width: 100%;
	}

	#slm-orders-table td, #slm-orders-table th {
	border: 1px solid #ddd;
	padding: 8px;
	}
	#slm-orders-table tr:nth-child(2n){background-color: #ffc697;}
	#slm-orders-table tr:hover {background-color: #ff7300;}
	#slm-orders-table th {
	padding-top: 12px;
	padding-bottom: 12px;
	text-align: left;
	background-color: #E8E8EB;
	color: black;
	font-weight: 700;
	}

	/* The alert message box */
	.slm-alert {
	padding: 10px;
	margin: 10px 0;
	background-color: #e49400; /* pale yellow */
	color: white;
	margin-bottom: 15px;
	}
	.slm-alert-permanent {
	padding: 10px;
	margin: 10px 0;
	background-color: #e49400; /* pale yellow */
	color: white;
	margin-bottom: 15px;
	font-size: 1rem;
	}

	.slm-alert-dev-environment {
		padding: 10px;
		height: 15px;
		color: white;
		font-size: 1rem;

		background: repeating-linear-gradient(
			45deg,
			yellow,
			yellow 30px,
			black 30px,
			black 60px
		);
	}

	.slm-alert-dev-environment-text {
		padding: 10px;
		color: white;
		font-size: 1rem;
		background-color: red;
	}

	/* The close button */
	.slm-alert-closebtn {
	margin-left: 15px;
	color: white;
	font-weight: bold;
	float: right;
	font-size: 22px;
	line-height: 20px;
	cursor: pointer;
	transition: 0.3s;
	}

	/* When moving the mouse over the close button */
	.slm-alert-closebtn:hover {
	color: black;
	}

	.select_show_only input{
		background-color: inherit;
		float: left;
		border: none;
		outline: none;
		cursor: pointer;
		padding: 14px 16px;
		transition: 0.3s;
		font-size: 17px;
		margin: 0;
	}

	.create_voucher{
		box-shadow: 2px 4px blue !important;
	}

	.dashicons{
		cursor:pointer;
	}


	@media (min-width: 768px) {
		body.disabled:before {
			content: '';
			position: fixed;
			z-index: 1;
			min-height: 100vh;
			width: 100%;
			left: 0;
			top: 0;
			background: rgba(0, 0, 0, 0.5);
			height: 100%;
			overflow-y: hidden;
		}
	}

	@media only screen and (max-width: 768px) {
		.popup-place-slm-map {
			width: 100vw;
			height: 70vh;
		}
	}

</style>
<script>
	var _skroutzPointsMapWidgetOptions ={};
</script>

<?php 
	
	$msg_bar_update = "";

	function checkPickupDate($order_info){

		$pickup_date = $order_info['pickup_date'];
		$pickup_date_enum = $order_info['pickup_time_enum'];


		$current = new DateTime('today');

		$selectedDate = new DateTime($pickup_date);
		$isToday = $selectedDate->getTimestamp() == $current->getTimestamp();

		$isLessThanToday = $selectedDate->getTimestamp() < $current->getTimestamp();

		if($isLessThanToday){
			$msg_bar_update = 
			"<script> jQuery('.slm-alert').css({ 'visibility': 'visible', 'background-color' : '#ff5000'});
					jQuery('.slm-alert-text').text('Cant select Pickup Date before today.');
			</script>";

			return $msg_bar_update;
		}

		$tomorrow = new DateTime('today');
		$tomorrow = $tomorrow->modify('+1 day');
		$isTomorrow = $selectedDate->getTimestamp() == $tomorrow->getTimestamp();

		// Get the current date and time in UTC
		$currentDateUTC = new DateTime("now", new DateTimeZone('UTC'));
		$currentHoursUTC = (int)$currentDateUTC->format('H');
		$currentMinutesUTC = (int)$currentDateUTC->format('i');
		$currentTimeUTC = $currentHoursUTC * 100 + $currentMinutesUTC;

		// Define the time ranges in UTC
		$timeRangesUTC = [
			['start' => 0, 'end' => 1100],
			['start' => 1101, 'end' => 1559],
			['start' => 1600, 'end' => 2359]
		];

		

		// Check the current time against each range using if-else statements
		if ($currentTimeUTC >= $timeRangesUTC[0]['start'] && $currentTimeUTC <= $timeRangesUTC[0]['end']) {
	
			//before 14:00 dont allow morning of the same day
			if($isToday && $pickup_date_enum == 'morning'){

				$msg_bar_update = 
				"<script> jQuery('.slm-alert').css({ 'visibility': 'visible', 'background-color' : '#ff5000'});
						jQuery('.slm-alert-text').text('Cant edit to -morning- Pickup Time before 14:00 if Pickup Date is set for today.');
				</script>";

				return $msg_bar_update;
			}

		} elseif ($currentTimeUTC >= $timeRangesUTC[1]['start'] && $currentTimeUTC <= $timeRangesUTC[1]['end']) {

			//after 14:00 dont allow morning/evening of the same day
			if($isToday && $pickup_date_enum == 'morning'){
				$msg_bar_update = 
				"<script> jQuery('.slm-alert').css({ 'visibility': 'visible', 'background-color' : '#ff5000'});
						jQuery('.slm-alert-text').text('Cant edit order bewteen 14:00 - 19:00 if Pickup Date is set for today.');
				</script>";

				return $msg_bar_update;
			}
			
		} elseif ($currentTimeUTC >= $timeRangesUTC[2]['start'] && $currentTimeUTC <= $timeRangesUTC[2]['end']) {

			//after 19:00 dont allow morning/evening of the same day and dont allow morning of the next day
			if($isToday){
				$msg_bar_update = 
				"<script> jQuery('.slm-alert').css({ 'visibility': 'visible', 'background-color' : '#ff5000'});
						jQuery('.slm-alert-text').text('Cant edit order after 19:00 if Pickup Date is set for today.');
				</script>";

				return $msg_bar_update;
			}

			if($isTomorrow && $pickup_date_enum == 'morning'){
				$msg_bar_update = 
				"<script> jQuery('.slm-alert').css({ 'visibility': 'visible', 'background-color' : '#ff5000'});
						jQuery('.slm-alert-text').text('Cant edit to -morning- Pickup Time after 19:00 if Pickup Date is set for tomorrow.');
				</script>";

				return $msg_bar_update;
			}

		} 

	}

	function getOrdersNum(){
		global $wpdb;
		$table_name = $wpdb->prefix . 'slm_orders';
		$result =  $wpdb->get_results( "SELECT COUNT(*) as num_orders FROM {$table_name}", OBJECT );
		$num_orders = $result[0]->num_orders;
		if(isset($num_orders) && !empty($num_orders)) {
			return $num_orders;
		}
		return 0;
	}
	$total_orders_num = getOrdersNum();
	$total_items_per_page = 20;
	$total_num_pages = (int) ceil($total_orders_num / 20);

	
	function getOrders($start, $how_many, $selectBy = null){
		global $wpdb;
		$table_name = $wpdb->prefix . 'slm_orders';
		
		$whereCondition='';
		if($selectBy == 'Pending'){
			$whereCondition = 'tracking_id IS NULL OR tracking_id = ""';
		}else if($selectBy == 'Active Orders'){
			$whereCondition = 'tracking_id IS NOT NULL AND status IN (2,5)';
		}else if($selectBy == 'Cancelled'){
			$whereCondition = 'status = 3';
		}else if($selectBy == 'Completed'){
			$whereCondition = 'status = 4';
		}else if($selectBy == 'Failed'){
			$whereCondition = 'status = 6';
		}

		if($whereCondition){
			$whereCondition = 'WHERE ' . $whereCondition;
		}
		
		return $wpdb->get_results( "SELECT * FROM {$table_name} {$whereCondition} ORDER BY id DESC LIMIT {$start}, {$how_many}", OBJECT );
	}

	function getOrderByTrackingId($tracking_id){
		global $wpdb;
		$table_name = $wpdb->prefix . 'slm_orders';
	
		return $wpdb->get_results( "SELECT * FROM {$table_name} WHERE tracking_id = '{$tracking_id}'", OBJECT );
	}


	function getActiveOrders(){
		global $wpdb;
		$table_name = $wpdb->prefix . 'slm_orders';
		
		
		$final_statuses = ['delivered','returned_to_sender','lost_or_damaged'];
		$final_statuses_wrapped = "'".implode("', '", $final_statuses)."'" ;

		return $wpdb->get_results( 
			"SELECT tracking_id FROM {$table_name} 
				WHERE status = 2 
				AND (slm_tracking_status IS NULL OR slm_tracking_status NOT IN " . "(" . $final_statuses_wrapped . ") )"
			, OBJECT );
		
	}

	/**
	 * @param mixed $status: slm_status_on_create, slm_status_on_cancel, slm_status_on_complete, slm_status_on_fail
	 */
	function updateWCOrder($order_id, $status){

		if(!isset($order_id) || !isset($status) ){
			return;
		}

		$order_id = (int) $order_id;

		$slm_status_on_ = get_option($status);
		
		if(isset($slm_status_on_) && !empty($slm_status_on_) && $slm_status_on_ != 'slm_none_status'){
			wp_update_post([
				'ID'          => $order_id,
				'post_status' => $slm_status_on_
			]);
		}
	}

	


	function updateOrder($updateData){

		global $wpdb;
		$table_name = $wpdb->prefix . 'slm_orders';

		$updateBy = '';
		if(isset($updateData['order_id'])){
			$updateBy = array( 'order_id' => $updateData['order_id']);
		} else if( isset($updateData['tracking_id']) ){
			$updateBy = array( 'tracking_id' => $updateData['tracking_id']);
		} else{
			return "<script> jQuery('.slm-alert').css({ 'visibility': 'visible', 'background-color' : '#ee0000'});
						jQuery('.slm-alert-text').text('Error updating {$table_name} table. order_id or tracking_id is null to find the order.');
					</script>";
		}

		$num_of_rows_updated = $wpdb->update( $table_name, $updateData, $updateBy);

		$searchingBy = ( isset($updateBy['order_id']) && !empty($updateBy['order_id']) ) ? $updateData['order_id'] : $updateData['tracking_id'];
		if($num_of_rows_updated === false){
			return "<script> jQuery('.slm-alert').css({ 'visibility': 'visible', 'background-color' : '#ee0000'});
						jQuery('.slm-alert-text').text('SQL Error updating slm_orders with order_id or tracking_id: {$searchingBy}');
					</script>";
		}

		
		return null;
	}

	function makeRequest($url, $type, $data = null){

		$request = curl_init();

		$authorization = "Authorization: Bearer " . ''.get_option('slm_api_token', '');

		$http_headers = array(
			$authorization,
			"Content-Type: application/json",
			"Content-Length:" . strlen($data)
		);

		curl_setopt_array($request, array(
			CURLOPT_URL => ''.get_option('slm_api_url', '').$url,
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => '',
			CURLOPT_MAXREDIRS => 5,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => 1,
			CURLOPT_ENCODING => 'gzip, deflate, br',
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => $type,
			CURLOPT_HTTPHEADER => $http_headers,
			CURLOPT_POSTFIELDS => $data
		));


		$response = curl_exec($request);
		curl_close($request);

		return $response;
	}

	//10:00-14:00 -> morning window
	//15:00-17:00 -> afternoon window	
	function pickupTimeWindowToTime($pickup_date, $time_window){
		$pickup_time_from  = $pickup_date.'T10:00:00';
		$pickup_time_to    = $pickup_date.'T14:00:00';
	
		if($time_window == 'evening'){
			$pickup_time_from = $pickup_date.'T15:00:00';
			$pickup_time_to   = $pickup_date.'T17:00:00';
		}
		
		$pickup_time_from = new DateTime($pickup_time_from, new DateTimeZone('Europe/Athens'));
		$pickup_time_from->setTimezone(new DateTimeZone('UTC'));
		$pickup_time_from = $pickup_time_from->format('Y-m-d\TH:i:sP');
		 
		 
		$pickup_time_to = new DateTime($pickup_time_to, new DateTimeZone('Europe/Athens'));
		$pickup_time_to->setTimezone(new DateTimeZone('UTC'));
		$pickup_time_to = $pickup_time_to->format('Y-m-d\TH:i:sP');
		
		return array($pickup_time_from, $pickup_time_to);
	}

	function post_shipping_order($order_info){
		$msg_bar_update = "";

		$error_pickup_date = checkPickupDate($order_info);

		if($error_pickup_date){
			$msg_bar_update = $error_pickup_date;
			return $msg_bar_update;
		}


		//set pickup date
		$pickup_date = $order_info['pickup_date'];
		if(!$pickup_date){
			$pickup_date = calculatePickupDate();
		}

		list($pickup_time_from, $pickup_time_to) = pickupTimeWindowToTime($pickup_date, $order_info['pickup_time_enum']);
		
		$total_weight = calculateOrderTotalWeight($order_info['order_id']);

		$data = array(
			"customer_reference"		=> $order_info['order_id'],//"CustRef123",
			"is_return"    				=> false,
			"number_of_parcels"			=> 1,
			"pickup_date"				=> $pickup_date,
			"pickup_location_code"		=> $order_info['pickup_location_code'],
			"pickup_notes"				=> "",
			"pickup_time_from"			=> $pickup_time_from,
			"pickup_time_to"			=> $pickup_time_to,
			"recipient_name"			=> $order_info['recipient_name'],
			"recipient_phone"			=> $order_info['recipient_phone'],
			"sender_phone"				=> get_option('slm_store_phone'),
			"skroutz_point_id"			=> $order_info['externalLockerId'],
			"weight"					=> $total_weight ? $total_weight : 0,
		);

		$data_to_json = json_encode($data);

		$response = makeRequest('/api/v1/shipping_order', 'POST', $data_to_json);

		if(isset($response) && $response) {
			$response_data = array();
			$response_data = JSON_DECODE($response,TRUE);

			$data_to_save = array();
			if(isset($response_data['success']) && $response_data['success'] == true && isset($response_data['tracking_ids']) && isset($response_data['order_id']) ) {
				$data_to_save['tracking_id']  			= $response_data['tracking_ids'][0];
				$data_to_save['soid'] 					= $response_data['order_id'];
				$data_to_save['status_message'] 		= 'Created Order at SLM';
				$data_to_save['status'] 				= 2;  
				$data_to_save['pickup_location_code']   = $order_info['pickup_location_code'];
				$data_to_save['pickup_date']  			= $pickup_date;
				$data_to_save['pickup_time_from']  	    = $pickup_time_from;
				$data_to_save['pickup_time_to']  		= $pickup_time_to;
				$data_to_save['pickup_time_enum']  	    = $order_info['pickup_time_enum'];
				$data_to_save['order_id']  	            = $order_info['order_id'];

				

				$msg_bar_update = updateOrder($data_to_save);
				if($msg_bar_update) {return $msg_bar_update;}

				updateWCOrder($order_info['order_id'],'slm_status_on_create');

				
				$msg_bar_update = 
				"<script> jQuery('.slm-alert').css({ 'visibility': 'visible', 'background-color' : '#00b51f'});
						jQuery('.slm-alert-text').text('Voucher: - {$response_data['tracking_ids'][0]} - has successfully created.');
				</script>";

			} else {
				$data_to_save['status'] 				= 5; 
				$data_to_save['status_message'] 	    = 'Voucher was not created. No response from SLM Server';
				$data_to_save['order_id']  	            = $order_info['order_id'];
				if(isset($response_data['error_description']) && $response_data['error_description']){
					$data_to_save['status_message'] 	= 'SLM: '.substr($response_data['error_description'],0,150);
				}

				$msg_bar_update = updateOrder($data_to_save);
				if($msg_bar_update) {return $msg_bar_update;}

				$msg_bar_update = 
				"<script> jQuery('.slm-alert').css({ 'visibility': 'visible', 'background-color' : '#ff1a49'});
						jQuery('.slm-alert-text').text('{$data_to_save['status_message']}');
				</script>";
			}
		} else{
			$data_to_save['status'] 				= 5; 
			$data_to_save['status_message'] 	    = "Fatal Error: Curl request failed. No response from SLM Server";
			$data_to_save['order_id']  	            = $order_info['order_id'];

			$msg_bar_update = updateOrder($data_to_save);
			if($msg_bar_update) {return $msg_bar_update;}

			$msg_bar_update = 
			"<script> jQuery('.slm-alert').css({ 'visibility': 'visible', 'background-color' : '#ee0000'});
					jQuery('.slm-alert-text').text('{$data_to_save['status_message']}');
			</script>";
		};

		

		return $msg_bar_update;

	}

	function update_shipping_order($order_info){
		$msg_bar_update = "";

		$error_pickup_date = checkPickupDate($order_info);

		if($error_pickup_date){
			$msg_bar_update = $error_pickup_date;
			return $msg_bar_update;
		}

		//set pickup date
		$pickup_date = $order_info['pickup_date'];
		list($pickup_time_from, $pickup_time_to) = pickupTimeWindowToTime($pickup_date, $order_info['pickup_time_enum']);

		$data = array(
					"pickup_date"				=> $pickup_date,
					"pickup_time_from"			=> $pickup_time_from,
					"pickup_time_to"			=> $pickup_time_to,
				);

		$data_to_json = json_encode($data);

		$response = makeRequest('/api/v1/shipping_order/'.$order_info['soid'], 'PUT', $data_to_json);

		if(isset($response) && $response) {
			$response_data = array();
			$response_data = JSON_DECODE($response,TRUE);

			$data_to_save = array();
			if( isset($response_data['success']) && $response_data['success'] == true ) {

				$data_to_save['pickup_time_enum'] 		= $order_info['pickup_time_enum']; 
				$data_to_save['pickup_date'] 			= $pickup_date; 
				$data_to_save['pickup_time_from'] 		= $pickup_time_from; 
				$data_to_save['pickup_time_to'] 		= $pickup_time_to; 
				$data_to_save['status'] 				= 2; 
				$data_to_save['status_message'] 	    = "Success: Updated Order Pickup Date and Time";
				$data_to_save['order_id']  	            = $order_info['order_id'];
				

				$msg_bar_update = updateOrder($data_to_save);
				if($msg_bar_update) {return $msg_bar_update;}

				$msg_bar_update = 
				"<script> jQuery('.slm-alert').css({ 'visibility': 'visible', 'background-color' : '#00ad8a'});
						jQuery('.slm-alert-text').text('Voucher: - {$response_data['tracking_ids'][0]} - has successfully updated.');
				</script>";
			} else {
				$data_to_save['status'] 				= 5; 
				$data_to_save['status_message'] 	    = "Voucher not Updated. Bad response from SLM Server";
				$data_to_save['order_id']  	            = $order_info['order_id'];
				if(isset($response_data['error_description']) && $response_data['error_description']){
					$data_to_save['status_message'] 	= 'SLM: '.substr($response_data['error_description'],0,150);
				}


				$msg_bar_update = updateOrder($data_to_save);
				if($msg_bar_update) {return $msg_bar_update;}

				$msg_bar_update = 
				"<script> jQuery('.slm-alert').css({ 'visibility': 'visible', 'background-color' : '#ff1a49'});
						jQuery('.slm-alert-text').text('{$data_to_save['status_message']}');
				</script>";

				
			};
				
		} else{
			$data_to_save['status'] 				= 5; 
			$data_to_save['status_message'] 	    = "Fatal Error: Curl request failed. No response from SLM Server";
			$data_to_save['order_id']  	            = $order_info['order_id'];

			$msg_bar_update = updateOrder($data_to_save);
			if($msg_bar_update) {return $msg_bar_update;}

			$msg_bar_update = 
			"<script> jQuery('.slm-alert').css({ 'visibility': 'visible', 'background-color' : '#ee0000'});
					jQuery('.slm-alert-text').text('{$data_to_save['status_message']}');
			</script>";
		};

		return $msg_bar_update;
	}

	function complete_shipping_order($order){
		$data_to_save['status'] 				= 4; 
		$data_to_save['status_message'] 	    = "Order Completed";
		$data_to_save['order_id']  	            = $order['order_id'];
		
		$msg_bar_update = updateOrder($data_to_save);
		if($msg_bar_update) {return $msg_bar_update;}

		updateWCOrder($order['order_id'],'slm_status_on_complete');

		$msg_bar_update = 
				"<script> jQuery('.slm-alert').css({ 'visibility': 'visible', 'background-color' : '#00ad8a'});
						jQuery('.slm-alert-text').text('Order succesfully marked as completed.');
				</script>";
		return $msg_bar_update;

	}
	function cancel_shipping_order($order){
		
		$params = $order['soid'];
		
		$response = makeRequest('/api/v1/shipping_order/'.$params, 'DELETE');

		if(isset($response) && $response) {

			$response_data = JSON_DECODE($response,TRUE);
			if(isset($response_data['success']) && $response_data['success'] === true){
				

				$data_to_save['status'] 				= 3; 
				$data_to_save['status_message'] 	    = "Order Cancelled";
				$data_to_save['order_id']  	            = $order['order_id'];
				
				$msg_bar_update = updateOrder($data_to_save);
				if($msg_bar_update) {return $msg_bar_update;}

				updateWCOrder($order['order_id'],'slm_status_on_cancel');

				$msg_bar_update = 
						"<script> jQuery('.slm-alert').css({ 'visibility': 'visible', 'background-color' : '#00b51f'});
							jQuery('.slm-alert-text').text('SLM: Shipment is cancelled successfully');
						</script>";

				return $msg_bar_update;
			} else{
				$error_msg = 'Unexpected error occured on communication with SLM servers. Cancel failed.';

				$data_to_save['status'] 				= 5; 
				$data_to_save['status_message'] 	    = 'Voucher was not Cancelled.';
				$data_to_save['order_id']  	            = $order['order_id'];
				if(isset($response_data['error_description']) && $response_data['error_description']){
					$data_to_save['status_message'] 	= 'SLM: '.substr($response_data['error_description'],0,150);
				}

				$msg_bar_update = updateOrder($data_to_save);
				if($msg_bar_update) {return $msg_bar_update;}


				if(isset($response_data['error_description'])){
					$error_msg = 'SLM: ' . $response_data['error_description'];
				}

				$msg_bar_update = 
					"<script> jQuery('.slm-alert').css({ 'visibility': 'visible', 'background-color' : '#ff1a49'});
						jQuery('.slm-alert-text').text('$error_msg');
					</script>";
				return $msg_bar_update;
			}
			
		} else {
			$msg_bar_update = 
					"<script> jQuery('.slm-alert').css({ 'visibility': 'visible', 'background-color' : '#ee0000'});
						jQuery('.slm-alert-text').text('Fatal Error: Curl request failed. No response from SLM Server');
					</script>";
			return $msg_bar_update;
		};
	}

	function getVoucherColor($slm_order){
			
		if(empty($slm_order->tracking_id) ){ //pending
			return '#F0E130';
		} else if((int) $slm_order->status === 2 || (int) $slm_order->status === 5){ //created
			return '#ADD8E6';
		} else if((int) $slm_order->status === 3) { // Cancelled
			return '#FF0000';
		} else if((int) $slm_order->status === 4) { // Completed
			return '#00FF00';
		} else if((int) $slm_order->status === 6) { // Failed
			return '#8B0000';
		}
	}

	function calculatePickupDate($pickup_day = null, $workingDaysForward = null,$holidays = null){
		 
		if($pickup_day){
			$origin = new DateTime("today", new DateTimeZone("UTC"));
			$target = new DateTime($pickup_day);
			$daysDiff = $origin->diff($target)->format('%a');
			
            $workingDaysForward = $workingDaysForward + $daysDiff;
		}
		
		if($workingDaysForward == null) {
			$workingDaysForward = 1; //default
		}
		if($holidays == null) {
			$holidays = ['01-01','01-06','03-25', '05-01', '15-08','28-10','25-12','26-12']; //default
		}
		
		//its the MAX sum of sundays and holidays (that can occur) we allow to skip
		$MAX_LOOPS = 10;
		//$x = 1 means today doesnt count
		for ($x = 1; $x <= $workingDaysForward && $x <= $MAX_LOOPS; $x++) {
			$origin = new DateTime("today", new DateTimeZone("UTC"));
			$thisForwardWeekDay = $origin->modify('+'.$x.' day')->format("N");
			// $thisForwardWeekDay = gmdate('N', strtotime("+".$x." day") );

			if($thisForwardWeekDay == 7){
				$workingDaysForward = $workingDaysForward + 1 ;
				continue;
			}   
			
			foreach ($holidays as $holiday){
				// $thisForwardDay = gmdate('m-d', strtotime("+".$x." day") );
				$origin = new DateTime("today", new DateTimeZone("UTC"));
				$thisForwardDay = $origin->modify('+'.$x.' day')->format("m-d");
				if($thisForwardDay == $holiday){
					$workingDaysForward = $workingDaysForward + 1 ;
					if(($key = array_search($holiday, $holidays)) !== false) {
						unset($holidays[$key]);
					}
					break;
				}
			}
			
		}

		// $pickup_date = gmdate('Y-m-d', strtotime("+".$workingDaysForward." day") );
		$origin = new DateTime("today", new DateTimeZone("UTC"));
		$pickup_date = $origin->modify('+'.$workingDaysForward.' day')->format("Y-m-d");
		return $pickup_date;
	}

	function calculateOrderTotalWeight($order_id) {

		$slm_enable_weight_get_value = get_option('slm_enable_weight');
		
		if($slm_enable_weight_get_value != 'on') {
			return 0;
		};
		
		$order = wc_get_order($order_id);
		$total_weight = 0;
		$weight_unit = get_option('woocommerce_weight_unit');
	
		foreach ($order->get_items() as $item) {
		  $product = $item->get_product();
		  $product_weight = (float) $product->get_weight();
		  $quantity =  (int) $item->get_quantity();
	  
		  $total_weight += $product_weight * $quantity;
		}

		//convert to kg if other unit
		if($weight_unit === 'g') {
			$total_weight = $total_weight / 1000;
		} else if($weight_unit === 'lbs'){
			$total_weight = $total_weight * 0.453592;
		} else if($weight_unit === 'oz'){
			$total_weight = $total_weight * 0.0283495;
		}
	  
		return $total_weight;
	}

	function convertUTCToLocalFormatted($utc_time){
		$created_at_utc = new DateTime($utc_time, new DateTimeZone("UTC"));
		$gmt_offset = get_option('gmt_offset');
		$created_at_with_default_timezone = $created_at_utc->modify($gmt_offset.' hour');
		$created_at = date_format($created_at_with_default_timezone,"Y/m/d H:i:s");

		return $created_at;
	}

	function getParcelPrintable($voucher_barcode) {

		$params = '?paper_size=thermal&direct_download=true';

		$response = makeRequest('/api/v1/shipping_order/voucher/'.$voucher_barcode.$params, 'GET');
		
		$error_description = 'Unexpected error occured on communication with SLM servers. Cant download voucher pdf.';

		if(isset($response) && $response) {
			$response_data = JSON_DECODE($response,TRUE);
			if( isset($response_data['success']) && $response_data['success'] === false) {
				if(isset($response_data['error_description'])){
					$error_description = 'SLM: '. $response_data['error_description'];
				}

				$msg_bar_update = 
					"<script> jQuery('.slm-alert').css({ 'visibility': 'visible', 'background-color' : '#ee0000'});
						jQuery('.slm-alert-text').text('{$error_description}');
					</script>";
				return $msg_bar_update;
			} else{
				
				ob_end_clean();

				header("Content-Description: File Transfer");
				header("Content-type: application/pdf");
				header("Content-Transfer-Encoding: binary");
				header("Content-Disposition: attachment; filename=" . $voucher_barcode . ".pdf");
				header("Accept-Encoding:gzip, deflate, br");
				echo $response;
			}
		}else{
			$msg_bar_update = 
					"<script> jQuery('.slm-alert').css({ 'visibility': 'visible', 'background-color' : '#ee0000'});
						jQuery('.slm-alert-text').text('{$error_description}');
					</script>";
			return $msg_bar_update;
		}

	}

	function syncWithSlm(){
	
		$active_SLM_parcels = getActiveOrders();
		
		if(count($active_SLM_parcels) > 0 ){
			$active_SLM_parcels_array    = [];

			foreach ($active_SLM_parcels as $parcel) {
				array_push($active_SLM_parcels_array,$parcel->tracking_id);
			}
			
			$data['barcodes'] = $active_SLM_parcels_array;
			
			$data_to_json = json_encode($data);

			$response = makeRequest('/api/v1/shipment/track/latestStatus', 'POST', $data_to_json);

			$barcode_statuses = json_decode($response, true);

			$msg_bar_update = "";

			if(isset($response) && $response) {

				$response_data = JSON_DECODE($response,TRUE);
				if( isset($response_data['success']) && $response_data['success'] === false || (isset($response_data['status']) && $response_data['status'] >= 400)) {
					
					$error_description = 'Unexpected error occured on communication with SLM servers. Sync failed.';
					if($response_data['error_description']){
						$error_description = $response_data['error_description'];
					}
					$msg_bar_update = 
						"<script> jQuery('.slm-alert').css({ 'visibility': 'visible', 'background-color' : '#ee0000'});
							jQuery('.slm-alert-text').text('$error_description');
						</script>";
					return $msg_bar_update;
					
				} else{
					foreach ($barcode_statuses as $status) {
						$data_to_save = array();
						$data_to_save['tracking_id']  			= $status['barcode'];
						$data_to_save['slm_tracking_msg']  	    = $status['latestStatusDescription'];
						$data_to_save['slm_tracking_status']  	= $status['status'];

						$order = getOrderByTrackingId($status['barcode']);
						if($status['status'] == 'delivered'){
							$data_to_save['status'] = 4;
							updateWCOrder($order['order_id'],'slm_status_on_complete');
						}else if(in_array($status['status'], ['returned_to_sender','lost_or_damaged'])){
							$data_to_save['status'] = 6;
							$data_to_save['status_message'] = 'Order Failed';

							updateWCOrder($order['order_id'],'slm_status_on_fail');
						} else if(in_array($status['latestStatusDescription'], ['Ακυρωμένη'])){
							$data_to_save['status'] = 3;
							$data_to_save['status_message'] = 'Order Cancelled';

							updateWCOrder($order['order_id'],'slm_status_on_cancel');
						}

						$msg_bar_update = updateOrder($data_to_save);
						if($msg_bar_update) {
							return $msg_bar_update;
						}
					}
				}
				
			} else {
				$msg_bar_update = 
						"<script> jQuery('.slm-alert').css({ 'visibility': 'visible', 'background-color' : '#ee0000'});
							jQuery('.slm-alert-text').text('Fatal Error: Curl request failed. No response from SLM Server');
						</script>";
				return $msg_bar_update;
			};

		}

		if(empty($msg_bar_update)) {
			$msg_bar_update = 
					"<script> jQuery('.slm-alert').css({ 'visibility': 'visible', 'background-color' : '#00b51f'});
						jQuery('.slm-alert-text').text('Sync Latest Status of SLM is completed successfully');
					</script>";


			$currentDateUTC = new DateTime("now", new DateTimeZone('UTC'));

			$created_at = date_format($currentDateUTC,"Y/m/d H:i:s");
			update_option('slm_last_sync',  $created_at);
		}

		return $msg_bar_update;
	
		
	}

	function generateDropdownSelect($order_id) {
		//Check if the "slm_plcodes" key exists in database
		
		if (!empty((get_option('slm_plcodes', '') ) ) ) {
			// Split the comma-separated values into an array
			$pickup_locations = explode(",", get_option('slm_plcodes', ''));
	
			// Start building the HTML select element
			$select_html = '<select id="drop_'.$order_id.'" name="pickup_location" >';
			
			// Loop through the pickup locations to create the options
			foreach ($pickup_locations as $location) {
				$location = trim($location); // Remove any extra spaces
				$select_html .= '<option value="' . $location . '">' . $location . '</option>';
			}
	
			// Close the select element
			$select_html .= '</select>';
	
			return $select_html;
		} 
		else{
			return '';
		}
	}

	function generatePaginationHtml(){
		return file_get_contents('pagination.php',FILE_USE_INCLUDE_PATH);
	}

	function need_slm_sync(){

		$now_utc = new DateTime('now', new DateTimeZone("UTC"));

		$threshhold  = $now_utc -> modify('-3 hour');

		$slm_last_sync = get_option('slm_last_sync');


		if(empty($slm_last_sync) ){
			return true;
		}
		

		$slm_last_sync_utc = new DateTime($slm_last_sync, new DateTimeZone("UTC"));

		if($slm_last_sync_utc < $threshhold ){
			return true;
		}

		return false;
		
	}

	if(isset($_POST['create_voucher_btn'])) {
		$msg_bar_update = post_shipping_order($_POST);
	}
	if(isset($_POST['update_voucher_btn'])) {
		$msg_bar_update = update_shipping_order($_POST);
	}
	if(isset($_POST['complete_voucher_btn'])) {	
		$msg_bar_update = complete_shipping_order($_POST);
	}
	if(isset($_POST['cancel_voucher_btn'])) {
		$msg_bar_update = cancel_shipping_order($_POST);
	}
	if(isset($_POST['download_voucher_pdf']) && !empty($_POST['download_voucher_pdf'])) {
		$msg_bar_update = getParcelPrintable($_POST['download_voucher_pdf']);
	}
	if(isset($_POST['sync_btn']) || need_slm_sync()){
		$msg_bar_update = syncWithSlm();
	}
	

	$selected_page = 1;


	if(isset($_POST['select_page']) && !empty($_POST['select_page'])) {
		$selected_page = (int) $_POST['select_page'];
	}

	$pagination_html = generatePaginationHtml() .
	"
	<script>
		jQuery('#go_to_page').attr({
			'max' : {$total_num_pages}
		 });

		function load(pg) {
		paginator({
			target: document.getElementById('slm_pagination'),
			total: {$total_num_pages},
			current: pg,
			click: load
		});
		}

		load({$selected_page});
	</script>

	";
	
	$start = $total_items_per_page * ($selected_page - 1);

	if(isset($_POST['show_only'])){
		$results = getOrders($start,$total_items_per_page, $_POST['show_only']);
	} else {
		$results = getOrders($start,$total_items_per_page);
		$_POST['show_only'] = null;
	}

	$slm_last_sync_time = !empty(get_option('slm_last_sync')) ? convertUTCToLocalFormatted(get_option('slm_last_sync')) : 'Never';

	function devWarning(){
		if ( (strpos(get_option('slm_api_url'), 'staging') !== FALSE )|| (strpos(get_option('slm_map_url'), 'staging') !== FALSE) ) {
			return '
					<div class="slm-alert-dev-environment"></div>
					<div class="slm-alert-dev-environment-text">
						<strong><span class="dashicons dashicons-warning"></span><span style="color:#ffffff"> DEV ENVIRONMENT: You are in a test environment of Skroutz Last Mile. Please, if you completed testing, replace the development keys with the production keys.</span></strong>
					</div>
					'
					;
					
		} else{
			return '';
		}
	};

	$dev_warning = devWarning();
	
	echo '
			<div class="slm-alert-permanent">
				<strong><span class="dashicons dashicons-warning"></span><span style="color:#ffffff">WARNING: Dont use the same VOUCHER PRINT for separate parcels. Even if its for the same order! One voucher goes for a single physical package!</span></strong>
			</div> '
			.$dev_warning.
			'
			<div class="slm-alert" style="visibility: hidden">
				<span class="slm-alert-closebtn" onclick="this.parentElement.style.visibility=
				'
				.
				"'hidden'"
				.
				
				'";">&times;
				</span>
				<strong><span class="slm-alert-text">SLM will notify you when something is happened here.</span></strong>
				
			</div>

			<script>
				var pickup_location_code_selector = "";
				var plcElement = "";
			</script>
		' .
		"<div style='margin-bottom:10px;'>
			<form method='post'>
				<input type='hidden' name='select_page' value='{$selected_page}'/>
				<input type='hidden' name='show_only' value='{$_POST['show_only']}'/>

				<label for='sync_btn' style='font-size: 1rem'>Sync Latest Status of SLM: <strong>{$slm_last_sync_time}</strong> </label>
			</form>
		</div>"
		. 
		"
		<form method='post' class='select_show_only'>
			<input id='show_only_all' type='submit' name='show_only' value='All' style='border-top: 4px dashed white'/>
			<input id='show_only_pending' type='submit' name='show_only' value='Pending' style='border-top: 4px dashed #F0E130'/>
			<input id='show_only_active_orders' type='submit' name='show_only' value='Active Orders' style='border-top: 4px dashed #ADD8E6'/>
			<input id='show_only_cancelled' type='submit' name='show_only' value='Cancelled' style='border-top: 4px dashed #FF0000'/>
			<input id='show_only_completed' type='submit' name='show_only' value='Completed' style='border-top: 4px dashed #00FF00'/>
			<input id='show_only_failed' type='submit' name='show_only' value='Failed' style='border-top: 4px dashed #8B0000'/>
		</form>

		<script>
			if('{$_POST['show_only']}'){

				const id = '{$_POST['show_only']}'.toLowerCase().replace(' ','_');
				jQuery('#show_only_'+id).css({'background-color':'#ddd'}) ;
			}else{
				jQuery('#show_only_all').css({'background-color':'#ddd'}) ;
			}
		
		</script>
		"
		.
		"<table id='slm-orders-table'>
			<tr >
				<th style='text-align:center'>Order ID</th>
				<th style='text-align:center'>WC Order Status</th>
				<th style='text-align:center'>Date Added</th>
				<th style='text-align:center'>Customer</th>
				<th style='text-align:center'>Locker</th>
				<th style='text-align:center'>Voucher</th>
				<th style='text-align:center'>Status</th>
				<th style='text-align:center'>SLM Tracking</th>
				<th style='text-align:center'>Pickup Date</th>
				<th style='text-align:center'>Pickup Time</th>
				<th style='text-align:center'>Pickup Location</th>
				<th></th>
				<th></th>
			</tr>
		"; 
		
		foreach ($results as $row => $slm_order){
			$created_at = convertUTCToLocalFormatted($slm_order->created_at);
			$voucher_download_btn_html = (empty($slm_order->tracking_id) ? '' : 
			
			"<div style='display: flex; align-items: center;'>
				<span class='button' style='letter-spacing: 1.5px; font-family: monospace;'>{$slm_order->tracking_id}</span>
				<form method='post' style='text-align: center; margin-left: 5px;'>
					<input type='hidden' name='select_page' value='{$selected_page}'/>
					<input type='hidden' name='show_only' value='{$_POST['show_only']}'/>
					<input type='hidden' name='download_voucher_pdf' value='{$slm_order->tracking_id}' />
					<button type='submit'> <span class='dashicons dashicons-download'></span></span> </button>
				</form>
				<a href='https://www.skroutzlastmile.gr/#{$slm_order->tracking_id}' target='_blank' style='margin-left: 5px'>
					<span class='dashicons dashicons-external'></span>
				</a>
			</div>
			");


			$pickup_location_html = ( !empty($slm_order->pickup_location_code) ? $slm_order->pickup_location_code : 
			  generateDropdownSelect($slm_order->order_id) 
			);
			
			$pickup_location_code = '';
			
			if(!empty($slm_order->pickup_location_code) ){
				$pickup_location_code = $slm_order->pickup_location_code;
			} else {
				if(!empty((get_option('slm_plcodes', ''))) ){
					if(!empty(explode(",", get_option('slm_plcodes', '')))){
						$pickup_location_code = explode(",", get_option('slm_plcodes', ''))[0];
					}
				}
			}

			$gmt_offset = get_option('gmt_offset');

			$now_utc = new DateTime('now', new DateTimeZone("UTC"));
			$now_utc_with_default_timezone = $now_utc->modify($gmt_offset.' hour');

			$min_date = date('Y-m-d');
			if((int) $now_utc_with_default_timezone->format('H') > 14 ){
				$min_date = date_format($now_utc->modify('1 day'),"Y-m-d");
			}

			$pickup_date = '';
			if(!empty($slm_order->pickup_date) ){
				$pickup_date = $slm_order->pickup_date;
			} else {
				$pickup_date = calculatePickupDate(null,null,null);
			}

			$pickup_time_enum = 'morning';
			$pickup_time_enum_html = 
			"<select id='pt_{$slm_order->order_id}'>
				<option value='morning' selected>morning</option>
				<option value='evening'>evening</option>
			</select>";

			if(!empty($slm_order->pickup_time_enum) ){
				$pickup_time_enum = $slm_order->pickup_time_enum;
				if($pickup_time_enum == 'evening'){
					$pickup_time_enum_html = 
					"<select id='pt_{$slm_order->order_id}'>
						<option value='morning'>morning</option>
						<option value='evening' selected >evening</option>
					</select>";
				}
			}

			
			$actionBtn_html = "";
			if(empty($slm_order->tracking_id)){
				$actionBtn_html = 
					"
					<form method='post'>
						<input type='hidden' name='order_id' value='{$slm_order->order_id}' />
						<input type='hidden' name='created_at' value='{$slm_order->created_at}' />
						<input type='hidden' name='recipient_name' value='{$slm_order->recipient_name}' />
						<input type='hidden' name='recipient_phone' value='{$slm_order->recipient_phone}' />
						<input type='hidden' name='externalLockerId' value='{$slm_order->externalLockerId}' />
						<input type='hidden' id=pdInput_{$slm_order->order_id} name='pickup_date' value='{$pickup_date}' />
						<input type='hidden' id=ptInput_{$slm_order->order_id} name='pickup_time_enum' value='{$pickup_time_enum}' />
						<input type='hidden' id=plc_{$slm_order->order_id} name='pickup_location_code' value='{$pickup_location_code}' />
						<input type='hidden' name='select_page' value='{$selected_page}'/>
						<input type='hidden' name='show_only' value='{$_POST['show_only']}'/>
						<input type='submit' name='create_voucher_btn' class='button create_voucher' value='Create Voucher' onclick='var e=this;setTimeout(function(){e.disabled=true;},0);return true;'/>
						
					</form>
					";
			} else if(!empty($slm_order->tracking_id) && ($slm_order->status == 2 || $slm_order->status == 5) ){
				
				
				
				$cancel_complete_btns_html = "
					<!-- <button name='complete_voucher_btn' onclick='return completeVoucherBtnHandler()'> <span class='dashicons dashicons-yes'></span></button> -->

					<button name='cancel_voucher_btn' onclick='return cancelVoucherBtnHandler()'> <span class='dashicons dashicons-dismiss'></span></button>

					<script>
						function completeVoucherBtnHandler(){
							if (confirm('Are you sure you want to Complete the Voucher?')) {
								return true;
							} else{
								return false;
							}
						}

						function cancelVoucherBtnHandler(){
							if (confirm('Are you sure you want to Cancel the Voucher?')) {
								return true;
							} else{
								return false;
							}
						}
					</script>
				";
				
				$actionBtn_html = 
					"
						<form method='post'>
							<input type='hidden' name='order_id' value='{$slm_order->order_id}' />
							<input type='hidden' name='soid' value='{$slm_order->soid}' />
							<input type='hidden' id=pdInput_{$slm_order->order_id} name='pickup_date' value='{$pickup_date}' />
							<input type='hidden' id=ptInput_{$slm_order->order_id} name='pickup_time_enum' value='{$pickup_time_enum}' />
							<input type='hidden' name='select_page' value='{$selected_page}'/>
							<input type='hidden' name='show_only' value='{$_POST['show_only']}'/>

							<input type='submit' name='update_voucher_btn' class='button update_voucher' value='Update Voucher'/>
							"
								.$cancel_complete_btns_html .
							"
						</form>
					";
			} else{
				
				$actionBtn_html =  "<button disabled > Order In Final State </button>";
			}
			$site_url = site_url();
			$map_url = get_option('slm_map_url');

			
			$lockerName = '';
			
			if(isset($slm_order->locker_name) && !empty($slm_order->locker_name)){
				$lockerName = $slm_order->locker_name;
			}else if(isset($slm_order->externalLockerId) && !empty($slm_order->externalLockerId)){
				$lockerName = $slm_order->externalLockerId;
			}

			$status_color = getVoucherColor($slm_order);

			$wcOrderStatusBgColor = '';
			$wcOrderStatus = '';
			try {
				$wcOrder = wc_get_order( $slm_order->order_id );
				$wcOrderStatus = $wcOrder->get_status();
	
				if($wcOrderStatus == 'cancelled'){
					$wcOrderStatusBgColor = 'red';
				} else if($wcOrderStatus == 'completed'){
					$wcOrderStatusBgColor = 'green';
				}
			} catch (\Throwable $th) {
			}

			echo "
				<tr id={$slm_order->order_id}>
					<td><a href='{$site_url}/wp-admin/post.php?post={$slm_order->order_id}&action=edit'>{$slm_order->order_id}</a></td>
					<td bgcolor='{$wcOrderStatusBgColor}'>{$wcOrderStatus}</td>
					<td>{$created_at}</td>
					<td>{$slm_order->recipient_name} - {$slm_order->recipient_phone}</td>
					<td id='locName_{$slm_order->order_id}'>{$lockerName}</td>
					<td>".
						$voucher_download_btn_html .
					"
					</td>
					<td>{$slm_order->status_message}</td>
					<td>{$slm_order->slm_tracking_msg}</td>
					<td><input type='date' id='pd_{$slm_order->order_id}' value='{$pickup_date}' min='{$min_date}'></td>
					<td>". 
						$pickup_time_enum_html .	
					"</td>
					<td>" .
						$pickup_location_html . 
					"
					</td>
					<td>" .
						$actionBtn_html .	
					"</td>
					<td>
						<div style='background-color: {$status_color}; width: 20px; height: 20px; border-radius: 30px;'>
						</div>
					</td>
					";
						echo "
						<script>
							

							pickup_location_dropdown_selector = '#drop_{$slm_order->order_id}';
							pcDropdownElement = document.querySelector(pickup_location_dropdown_selector);
							if(pcDropdownElement){
								pcDropdownElement.addEventListener('change', function() {
									const pickup_location_code_selector = '#plc_{$slm_order->order_id}';
									const plcElement = document.querySelector(pickup_location_code_selector);
									const selectedValue = event.target.value;
									if(selectedValue && plcElement) {
										plcElement.value = selectedValue;
									}
								});
							}

							pickup_date_selector = '#pd_{$slm_order->order_id}';
							pdElement = document.querySelector(pickup_date_selector);
							if(pdElement){
								pdElement.addEventListener('change', function() {
									const pdInputSelector = '#pdInput_{$slm_order->order_id}';
									const pdInputElement = document.querySelector(pdInputSelector);
									const selectedValue = event.target.value;
									if(selectedValue && pdInputElement) {
										pdInputElement.value = selectedValue;
									}
									
								});
							}

							pickup_time_selector = '#pt_{$slm_order->order_id}';
							ptElement = document.querySelector(pickup_time_selector);
							if(ptElement){
								ptElement.addEventListener('change', function() {
									const ptInputSelector = '#ptInput_{$slm_order->order_id}';
									const ptInputElement = document.querySelector(ptInputSelector);
									const selectedValue = event.target.value;

									if(selectedValue && ptInputElement) {
										ptInputElement.value = selectedValue;
									}

									
								});
							}
							
							//broken popup map for admin page, remove it for now, fix it and add it if requested.
							/*
							document.querySelector('#locName_{$slm_order->order_id}').addEventListener('click', function() {
								jQuery('.plugin-slm-map .popup-place-slm-map').show();
								jQuery('body').removeClass('disabled');
								jQuery('body').toggleClass('disabled');

								try{
									_skroutPointsMapWidgetRemove();
								}catch(e){
								}
								_skroutzPointsMapWidgetOptions = {
									type: 'iframe',
									parentElement: '#skroutzLockerMap',
									requestUserLocation: false,
									lockerId: '{$slm_order->externalLockerId}'
								};
				
								
								var e = document.createElement('script');
								e.src = '{$map_url}'
								e.async = true;
								e.defer = true;
								document.getElementsByTagName('head')[0].appendChild(e);
								
								
							});
							*/
							
						</script>" 

						.
					
					"
				</tr>
				
				";
			
		};

		echo 
		"
			</table>
			
			<div class='plugin-slm-map' style='margin:8px auto'>
				<div class='popup-place-slm-map' style='text-align:right; display:none'>
					<span class='closeMapBtn dashicons dashicons-dismiss'></span>
					<div id='skroutzLockerMap'></div>
				</div>
			</div>

			<script type='text/javascript'>
			
				document.querySelector('.closeMapBtn').addEventListener('click', function () {
					jQuery('.plugin-slm-map .popup-place-slm-map').hide();
					jQuery('body').removeClass('disabled');
				});

				var mouse_is_inside = false;
				jQuery(document).ready(function()
				{	
					jQuery('#skroutzLockerMap').hover(function(){ 
						mouse_is_inside=true;
					}, function(){ 
						mouse_is_inside=false; 
					});

					jQuery('body').mouseup(function(){ 
						if(! mouse_is_inside) {
							jQuery('.plugin-slm-map .popup-place-slm-map').hide();
							jQuery('body').removeClass('disabled');
						}
					});
				});

			</script>
		";

	echo $pagination_html;
    echo $msg_bar_update;
?>