<script>
    function paginator(instance) {

      if (instance.current === undefined) {
        let param = new URLSearchParams(window.location.search);
        instance.current = param.has('pg')
          ? Number.parseInt(param.get('pg'))
          : 1;
      }
      if (instance.adj === undefined) {
        instance.adj = 2;
      }
      if (instance.adj <= 0) {
        instance.adj = 1;
      }
      if (instance.current <= 0) {
        instance.current = 1;
      }
      if (instance.current > instance.total) {
        instance.current = instance.total;
      }

      const jsmode = typeof instance.click == 'function';
      if (jsmode == false) {
        if (instance.click.indexOf('?') == -1) {
          instance.click += '?pg=';
        } else {
          instance.click += '&pg=';
        }
      }

      instance.target.innerHTML = '';
      instance.target.classList.add('paginate');

      const square = (txt, pg, css) => {
        let el = document.createElement('a');
        el.innerHTML = txt;
        if (css) {
          el.className = css;
        }
        if (jsmode) {
          el.onclick = () => instance.click(pg);
        } else {
          el.href = instance.click + pg;
        }
        instance.target.appendChild(el);
      };

      if (instance.current - instance.adj > 1) {
        square('&#10218;', 1, 'first');
      }

      let temp;
      if (instance.current > 1) {
        temp = instance.current - instance.adj;
        if (temp <= 0) {
          temp = 1;
        }
        for (let i = temp; i < instance.current; i++) {
          square(i, i);
        }
      }

      square(instance.current, instance.current, 'current');

      if (instance.current < instance.total) {
        temp = instance.current + instance.adj;
        if (temp > instance.total) {
          temp = instance.total;
        }
        for (let i = instance.current + 1; i <= temp; i++) {
          square(i, i);
        }
      }

      if (instance.current <= instance.total - instance.adj - 1) {
        square('&#10219;', instance.total, 'last');
      }


      go_to_page_selector = '#go_to_page';
      go_to_page_element = document.querySelector(go_to_page_selector);
      go_to_page_element.value = instance.current;
      
    }
  </script>

  <style>
    paginate {
      display: flex;
      align-items: center;
      /* display: block; */
    }

    #slm_pagination_layout{
      margin: 0 auto;
    }

    .paginate a {
      color: black;
      float: left;
      padding: 8px 16px;
      text-decoration: none;
      transition: background-color 0.3s;
      border: 1px solid #ddd;
      cursor: pointer;
    }

    .paginate a.current {
      background-color: #fc7227;
      color: white;
      border: 1px solid #af4c4c;
    }

    .paginate a:hover:not(.current) {
      background-color: #ddd;
    }
  </style>


  <table id="slm_pagination_layout">
    <tr>
      <td><div id="slm_pagination"></div></td>
    </tr>
    <tr>
      <td>
        <form method="post" style="text-align: center">
          <label for="go_to_page">page:</label>
          <input
            type="number"
            id="go_to_page"
            min="1"
            name="select_page"
            style="width: 100px"
          />
          <input type="submit" name='change_page' value="go" />
        </form>

        
      </td>
    </tr>
  </table>


  