<?php
/**
 * @link              https://www.webexpert.gr/wordpress/woocommerce-sms
 * @since             1.0.0
 * @package           Webexpert_Woocommerce_Sms
 *
 * @wordpress-plugin
 * Plugin Name:       WooCommerce SMS
 * Plugin URI:        https://www.webexpert.gr/wordpress/woocommerce-sms
 * Description:       Web Expert WooCommerce SMS simplifies the process of contacting client via an SMS gateway.
 * Version:           1.0.20
 * Requires at least: 4.0
 * Requires PHP:      7.0
 * Author:            Web Expert
 * Author URI:        https://www.webexpert.gr/
 * License:           Web Expert license
 * Text Domain:       webexpert-woocommerce-sms
 * Domain Path:       /languages
 * WC requires at least: 3.0
 * WC tested up to: 8.5.2
 **/

if (!defined('WPINC')) {
    die;
}
define('WEBEXPERT_WOOCOMMERCE_SMS', '1.0.20');
require plugin_dir_path(__FILE__) . 'includes/update/plugin-update-checker.php';
$myUpdateChecker = Puc_v4_Factory::buildUpdateChecker('https://www.webexpert.gr/plugins/updates/?action=get_metadata&slug=webexpert-woocommerce-sms', __FILE__, 'webexpert-woocommerce-sms');

$myUpdateChecker->addQueryArgFilter('webexpert_woocommerce_sms_update_checks');
function webexpert_woocommerce_sms_update_checks($queryArgs) {
    $license = get_option('webexpert_woocommerce_sms_license_key');
    $domain  = get_bloginfo('url');
    $parse   = parse_url($domain);
    $domain  = $parse['scheme'] . '://' . $parse['host'];
    if (!empty($license)) {
        $queryArgs['license_key'] = $license;
    }
    if (!empty($domain)) {
        $queryArgs['domain'] = $domain;
    }
    return $queryArgs;
}
function init_webexpert_woocommerce_sms_license_check() {
    if (get_option('init_webexpert_woocommerce_sms_license_check',false)==false) {
        webexpert_woocommerce_sms_license_check();
        update_option('init_webexpert_woocommerce_sms_license_check',true);
    }
}
add_action('admin_notices', 'init_webexpert_woocommerce_sms_license_check');
register_activation_hook( __FILE__, 'webexpert_woocommerce_sms_license_check' );
function webexpert_woocommerce_sms_license_check(){
    $url='https://www.webexpert.gr/plugins/updates/?action=get_metadata&slug=webexpert-woocommerce-sms&license_key='.get_option('webexpert_woocommerce_sms_license_key').'&domain='.get_bloginfo('url');
    $request = wp_remote_get($url);
    $response = wp_remote_retrieve_body( $request );
    $s = json_decode($response);
    if (isset($s->download_url)) {
        update_option('webexpert_woocommerce_sms_valid_license',true);
    }else {
        delete_option('webexpert_woocommerce_sms_valid_license');
    }
}

add_action('admin_menu', 'webexpert_woocommerce_sms_options_page');
function webexpert_woocommerce_sms_options_page() {
    $logo = file_get_contents(plugin_dir_path(__FILE__).'assets/webexpert-icon.svg');
    if (empty($GLOBALS['admin_page_hooks']['webexpert_plugins']))
        add_menu_page('Web Expert Plugins', 'Web Expert', 'manage_woocommerce', 'webexpert_plugins', 'webexpert_woocommerce_sms_settings_main_menu','data:image/svg+xml;base64,' . base64_encode($logo),20);
    add_submenu_page('webexpert_plugins', __('WooCommerce SMS', 'webexpert-woocommerce-sms'), __('WooCommerce SMS', 'webexpert-woocommerce-sms'), 'manage_woocommerce', 'webexpert-woocommerce-sms', 'webexpert_woocommerce_sms_options_page_html');
    remove_submenu_page('webexpert_plugins', 'webexpert_plugins');
}
add_action('admin_init', 'webexpert_woocommerce_sms_settings');
function webexpert_woocommerce_sms_settings() {

    register_setting('webexpert-woocommerce-sms-settings-group', 'webexpert_woocommerce_sms_email');
    register_setting('webexpert-woocommerce-sms-settings-group', 'webexpert_woocommerce_sms_license_key');
}
function webexpert_woocommerce_sms_settings_main_menu() {
    if (!current_user_can('manage_woocommerce')) {
        return;
    }
    ?>
    <div class="wrap">
        <h1><?= esc_html(get_admin_page_title()); ?></h1>
        <p>Ευχαριστούμε που επιλέγε την Web Expert.</p>
    </div>
    <?php
}
add_action('add_option_webexpert_woocommerce_sms_license_key', 'webexpert_woocommerce_sms_callback_update', 10, 2);
add_action('update_option_webexpert_woocommerce_sms_license_key', 'webexpert_woocommerce_sms_callback_update', 10, 2);
function webexpert_woocommerce_sms_callback_update( $old_value, $new_value ) {
    $url='https://www.webexpert.gr/plugins/updates/?action=get_metadata&slug=webexpert-woocommerce-sms&license_key='.$new_value.'&domain='.get_bloginfo('url');
    $request = wp_remote_get($url);
    $response = wp_remote_retrieve_body( $request );
    $s = json_decode($response);
    if (isset($s->download_url)) {
        update_option('webexpert_woocommerce_sms_valid_license',true);
    }else {
        delete_option('webexpert_woocommerce_sms_valid_license');
    }
}

function webexpert_woocommerce_sms_options_page_html() {
    if (!current_user_can('manage_woocommerce')) {
        return;
    }
    ?>
    <div class="wrap">
        <h1><?= esc_html(get_admin_page_title()); ?></h1>
        <p><?php _e('You can setup the SMS gateway at ', 'webexpert-woocommerce-sms'); ?> <a href="<?php echo admin_url("admin.php?page=wc-settings&tab=woocommerce_sms"); ?>"><?php _e('WooCommerce Settings', 'webexpert-woocommerce-sms'); ?></a>.</p>
        <p><?php _e('Please fill in the email address and the license key you received when purchasing the Web Expert WooCommerce SMS to enable automatic updates and ensure the full functionality of the plugin.', 'webexpert-woocommerce-sms'); ?></p>
        <p><?php _e('For any inquiries please contact ', 'webexpert-woocommerce-sms'); ?><a href="mailto:support@webexpert.gr">support@webexpert.gr</a> <?php _e('or visit our Helpdesk at ', 'webexpert-woocommerce-sms'); ?> <a target="_blank" href="http://support.webexpert.gr">http://support.webexpert.gr</a></p>
        <form action="options.php" method="post">
            <?php
            settings_fields('webexpert-woocommerce-sms-settings-group');
            do_settings_sections('webexpert-woocommerce-sms-settings-group');
            ?>
            <table class="form-table">
                <tr valign="top"><th scope="row">Email</th><td><input type="text" name="webexpert_woocommerce_sms_email" value="<?php echo esc_attr(get_option('webexpert_woocommerce_sms_email'));?>" /></td></tr>
                <tr valign="top"><th scope="row">API Key</th><td><input type="text" name="webexpert_woocommerce_sms_license_key" value="<?php echo esc_attr(get_option('webexpert_woocommerce_sms_license_key')); ?>" /></td></tr>
            </table>
            <?php submit_button(); ?>
            <input type="hidden" name="" value="<?php echo $_SERVER['HTTP_HOST'];?>">
        </form>
    </div>
    <?php
}

function activate_webexpert_woocommerce_sms()
{
    require_once plugin_dir_path(__FILE__) . 'includes/class-webexpert-woocommerce-sms-activator.php';
    Webexpert_Woocommerce_Sms_Activator::activate();
}

function deactivate_webexpert_woocommerce_sms()
{
    require_once plugin_dir_path(__FILE__) . 'includes/class-webexpert-woocommerce-sms-deactivator.php';
    Webexpert_Woocommerce_Sms_Deactivator::deactivate();
}

register_activation_hook(__FILE__, 'activate_webexpert_woocommerce_sms');
register_deactivation_hook(__FILE__, 'deactivate_webexpert_woocommerce_sms');
require plugin_dir_path(__FILE__) . 'includes/class-webexpert-woocommerce-sms.php';
function run_webexpert_woocommerce_sms()
{
    $plugin = new Webexpert_Woocommerce_Sms();
    $plugin->run();
}

run_webexpert_woocommerce_sms();

add_action('admin_notices', 'webexpert_woocommerce_sms_admin_notices');
function webexpert_woocommerce_sms_admin_notices() {
    if (empty(get_option('webexpert_woocommerce_sms_license_key')) || empty(get_option('webexpert_woocommerce_sms_email'))) {
        ?>
        <div class="notice notice-error">
            <p><?php _e('Please activate <strong>Web Expert WooCommerce SMS</strong> to enable all it\'s features and automatic updates.', 'webexpert-woocommerce-sms'); ?></p>
        </div>
        <?php
    }
    if (get_option('webexpert_woocommerce_sms_valid_license',false)===false) {
        ?>
        <div class="notice notice-error">
            <p><?php _e('The license for <strong>Web Expert WooCommerce SMS</strong> is invalid. Please fill in a valid license key.', 'webexpert-woocommerce-sms'); ?></p>
        </div>
        <?php
    }
}

add_action( 'before_woocommerce_init', function() {
    if ( class_exists( '\Automattic\WooCommerce\Utilities\FeaturesUtil' ) ) {
        \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', __FILE__, true );
    }
} );