<?php

class Webexpert_Woocommerce_Sms_Public
{
    private $plugin_name;
    private $version;

    public function __construct($plugin_name, $version)
    {
        $this->plugin_name = $plugin_name;
        $this->version = $version;
    }

    public function webexpert_woocommerce_sms_billing_fields($billing_fields)
    {
        $force = get_option('webex_woocommerce_sms_force_cellphone', 0);
        $billing_fields['billing_cellphone'] = array(
            'priority' => 100,
            'type' => 'text',
            'label' => __('Cellphone', 'webexpert-woocommerce-sms'),
            'placeholder' => _x('Cellphone', 'placeholder', 'webexpert-woocommerce-sms'),
            'class' => array('form-row-wide', '', 'validate-required'),
            'required' => $force,
            'clear' => true
        );
        return $billing_fields;
    }

    public function webexpert_woocommerce_sms_customer_meta_fields($billing_fields)
    {
        if (isset($billing_fields['billing']['fields'])) {
            $billing_fields['billing']['fields']['billing_cellphone'] = array(
                'label' => __('Cellphone', 'webexpert-woocommerce-sms'),
                'description' => ''
            );
        }
        return $billing_fields;
    }

    public function webexpert_woocommerce_sms_checkout_field_process()
    {
        $billing_cellphone = filter_input(INPUT_POST, 'billing_cellphone');
	    if (!$billing_cellphone) {
		    wc_add_notice(apply_filters('woocommerce_checkout_required_field_notice', sprintf(__('%s is a required field.', 'woocommerce'), '<strong>' . esc_html(sprintf(__('Billing %s', 'woocommerce'), __('Cellphone', 'webexpert-woocommerce-sms'))) . '</strong>'), 'billing_cellphone'),'error');
	    }
    }

    function webexpert_woocommerce_sms_found_customer_details($customer_data, $user_id, $type_to_load)
    {
        if ($type_to_load == 'billing') {
            $customer_data[$type_to_load . '_cellphone'] = get_user_meta($user_id, $type_to_load . '_cellphone', true);
        }
        return $customer_data;
    }
}
