<?php
class Webexpert_Woocommerce_Sms_Yuboto extends Webexpert_Woocommerce_Sms_Gateway
{
    public function __construct()
    {
        $this->id = 'yuboto';
        $this->method_title = 'Yuboto';
        $this->method_description = sprintf(__('These options refers to <a target="_blank" href="%s">yuboto.gr</a> SMS service','webexpert-woocommerce-sms'), "https://sms.yuboto.gr/");
        $this->settings = array(
            $this->id . '_section_title' => array(
                'name' => __($this->method_title, 'webexpert-woocommerce-sms'),
                'type' => 'title',
                'desc' => $this->method_description,
                'id' => 'webex_woocommerce_sms_' . $this->id . '_section_title'
            ),
            $this->id . '_auth_key' => array(
                'name' => __('API Key', 'webexpert-woocommerce-sms'),
                'type' => 'text',
                'id' => 'webex_woocommerce_sms_' . $this->id . '_auth_key'
            ),
            $this->id . '_viber_enable' => array(
                'name' => __('Enable Viber', 'webexpert-woocommerce-sms'),
                'type' => 'checkbox',
                'id' => 'webex_woocommerce_sms_' . $this->id . '_enable_viber'
            ),
            $this->id . '_viber_sender' => array(
                'name' => __('Viber Sender Name', 'webexpert-woocommerce-sms'),
                'type' => 'text',
                'id' => 'webex_woocommerce_sms_' . $this->id . '_viber_sender'
            ),
            $this->id . '_section_end' => array(
                'type' => 'sectionend',
                'id' => 'webex_woocommerce_sms_' . $this->id . '_section_end'
            )
        );
    }

    function send($recipient, $sender, $message)
    {
        $auth_key = get_option('webex_woocommerce_sms_yuboto_auth_key');
        $ucs = get_option('webex_woocommerce_sms_service_ucs');
        $parameters = array(
            'phonenumbers' => $recipient,
            'sms.sender'=>$sender,
            'sms.text' => $message,
            "sms.validity"=>180,
            'sms.typesms' => ($ucs == "gsm" ? 'sms' : 'unicode')
        );

        if(get_option('webex_woocommerce_sms_yuboto_enable_viber') == "yes") {
            $parameters['viber.sender']=empty(get_option('webex_woocommerce_sms_yuboto_viber_sender')) ? $sender : get_option('webex_woocommerce_sms_yuboto_viber_sender');
            $parameters['viber.text']=$message;
            $parameters['viber.image']=null;
            $parameters['viber.buttonAction']=null;
            $parameters['viber.buttonCaption']=null;
            $parameters['viber.fileName']=null;
            $parameters['viber.fileType']=null;
            $parameters['viber.validity']=180;
            $parameters['viber.expiryText']='';
            $parameters['viber.priority']=0;
            $parameters['sms.priority']=1;
        }

        $wp_request_headers = array(
            'Authorization' => 'Basic ' . base64_encode( $auth_key ),
            'Cache-Control' => 'no-cache'
        );
        $request=wp_remote_get("https://services.yuboto.com/omni/v1/Send",[
            'headers'   => $wp_request_headers,
            'body'=>$parameters
        ]);

        if (wp_remote_retrieve_response_code($request) != 200) {
            return ['success'=>false,'error'=>"Response code".wp_remote_retrieve_response_code($request)];
        }

        $response_decoded = json_decode(wp_remote_retrieve_body( $request ));

        if (!empty($response_decoded->ErrorMessage)) {
            return ['success'=>false,'error'=>$response_decoded->ErrorMessage];
        } else {
            return ['success' => 1];
        }
    }
}

add_filter('webexpert_woocommerce_sms_gateways', 'webexpert_woocommerce_add_sms_yuboto');
function webexpert_woocommerce_add_sms_yuboto($gateways)
{
    $gateways[] = new Webexpert_Woocommerce_Sms_Yuboto();
    return $gateways;
}