<?php
class Webexpert_Woocommerce_Sms_SMSnet extends Webexpert_Woocommerce_Sms_Gateway
{
    public function __construct()
    {
        $this->id = 'smsnet';
        $this->method_title = 'sms.net.gr';
        $this->method_description = sprintf(__('These options refers to <a target="_blank" href="%s">sms.net.gr</a> SMS service','webexpert-woocommerce-sms'), "https://sms.net.gr/");
        $this->settings = array(
            $this->id . '_section_title' => array(
                'name' => __($this->method_title, 'webexpert-woocommerce-sms'),
                'type' => 'title',
                'desc' => $this->method_description,
                'id' => 'webex_woocommerce_sms_' . $this->id . '_section_title'
            ),
            $this->id . '_api_token' => array(
	            'name' => __('API token', 'webexpert-woocommerce-sms'),
	            'type' => 'text',
	            'id' => 'webex_woocommerce_sms_' . $this->id . '_api_token'
            ),
            $this->id . '_username' => array(
	            'name' => __('Username', 'webexpert-woocommerce-sms'),
	            'type' => 'text',
	            'id' => 'webex_woocommerce_sms_' . $this->id . '_username'
            ),
            $this->id . '_api_password' => array(
	            'name' => __('API password', 'webexpert-woocommerce-sms'),
	            'type' => 'text',
	            'id' => 'webex_woocommerce_sms_' . $this->id . '_api_password'
            ),
            $this->id . '_section_end' => array(
                'type' => 'sectionend',
                'id' => 'webex_woocommerce_sms_' . $this->id . '_section_end'
            )
        );
    }

    function send($recipient, $sender, $message)
    {
        $username = get_option('webex_woocommerce_sms_smsnet_username');
        $api_password = get_option('webex_woocommerce_sms_smsnet_api_password');
        $api_token = get_option('webex_woocommerce_sms_smsnet_api_token');
        $ucs = get_option('webex_woocommerce_sms_service_ucs');

        $url='https://sms.net.gr/index.php/api/do';
        $fields = array(
            'username'=>urlencode($username),
            'api_password'=>urlencode($api_password),
            'api_token'=>urlencode($api_token),
            'to'=>urlencode($recipient),
            'from'=>urlencode($sender),
            'message'=>urlencode($message),
            'is_long'=>urlencode(0),
            'unicode'=>urlencode($ucs == "gsm" ? 0 : 1)
        );

        $fields_string="";
        foreach($fields as $key=>$value) { $fields_string .= $key.'='.$value.'&'; }
        rtrim($fields_string,'&');

        $result = wp_remote_get("https://sms.net.gr/index.php/api/do?{$fields_string}");

        if($result['response']['code'] == 200 && strpos($result['body'], "message submited") !== false) {
            return ['success' => 1];
        } else{
            return ['error' => $result];
        }

    }
}

add_filter('webexpert_woocommerce_sms_gateways', 'webexpert_woocommerce_add_sms_smsnet');
function webexpert_woocommerce_add_sms_smsnet($gateways)
{
    $gateways[] = new Webexpert_Woocommerce_Sms_SMSnet();
    return $gateways;
}