<?php
class Webexpert_Woocommerce_Sms_SMSCanal extends Webexpert_Woocommerce_Sms_Gateway
{

  public function __construct()
  {
        $this->id = 'smscanal';
        $this->method_title = 'SmsCanal';
        $this->method_description = sprintf(__('These options refers to <a target="_blank" href="%s">Sms Canal</a> SMS service','webexpert-woocommerce-sms'), "http://smscanal.com/sms/");
        $this->settings = array(
            $this->id . '_section_title' => array(
                'name' => __($this->method_title, 'webexpert-woocommerce-sms'),
                'type' => 'title',
                'desc' => $this->method_description,
                'id' => 'webex_woocommerce_sms_' . $this->id . '_section_title'
            ),
            $this->id . '_username' => array(
                'name' => __('Username', 'webexpert-woocommerce-sms'),
                'type' => 'text',
                'id' => 'webex_woocommerce_sms_' . $this->id . '_username'
            ),
            $this->id . '_password' => array(
                'name' => __('Password', 'webexpert-woocommerce-sms'),
                'type' => 'text',
                'id' => 'webex_woocommerce_sms_' . $this->id . '_password'
            ),
            $this->id . '_section_end' => array(
                'type' => 'sectionend',
                'id' => 'webex_woocommerce_sms_' . $this->id . '_section_end'
            )
        );
    }

    function send($recipient, $sender, $message)
    {
        $username = get_option('webex_woocommerce_sms_smscanal_username');
        $password = get_option('webex_woocommerce_sms_smscanal_password');
        $mobiles = $recipient;
        $sender_name = $sender;
        $message = urlencode(stripslashes($message));

        $URL="http://messaging.smscanal.com/sms/sendsms.jsp?";
        $http_request="user=".$username."&password=".$password."&mobiles=".$mobiles."&senderid=".$sender_name."&sms=".$message."&unicode=1";

        $ch = curl_init($URL);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $http_request);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_ENCODING, 'UTF-8');

        $output = curl_exec($ch);
        curl_close($ch);

        $curlerror = $message_id = $mobile = $smsclient_id = $error_action = $error_description = $error_code = "";

        try{
          $output = simplexml_load_string($output);
        }catch(Exception $e){
          $curlerror = "failed";
        }

        if(isset($output->sms) && $curlerror != "failed"){
            return ['success' => 1];
        }
        if(isset($output->error) && $curlerror != "failed") {
          $response = [];
          foreach ($output->error as $error){
            $error_description = $error->{'error-description'};
            $response[] =  $error_description;
          }
          return $response;
        }

        return [];
    }

}


add_filter('webexpert_woocommerce_sms_gateways', 'webexpert_woocommerce_add_sms_smscanal');
function webexpert_woocommerce_add_sms_smscanal($gateways)
{
    $gateways[] = new Webexpert_Woocommerce_Sms_SMSCanal();
    return $gateways;
}
