<?php

class Webexpert_Woocommerce_Sms_Smsbox extends Webexpert_Woocommerce_Sms_Gateway
{
    public function __construct()
    {
        $this->id = 'smsbox';
        $this->method_title = 'Smsbox';
        $this->method_description = sprintf(__('These options refers to <a target="_blank" href="%s">Smsbox</a> SMS service','webexpert-woocommerce-sms'), "https://www.smsbox.gr");
        $this->settings = array(
            $this->id . '_section_title' => array(
                'name' => __($this->method_title, 'webexpert-woocommerce-sms'),
                'type' => 'title',
                'desc' => $this->method_description,
                'id' => 'webex_woocommerce_sms_' . $this->id . '_section_title'
            ),
            $this->id . '_username' => array(
                'name' => __('Username', 'webexpert-woocommerce-sms'),
                'type' => 'text',
                'id' => 'webex_woocommerce_sms_' . $this->id . '_username'
            ),
            $this->id . '_password' => array(
                'name' => __('Password', 'webexpert-woocommerce-sms'),
                'type' => 'password',
                'id' => 'webex_woocommerce_sms_' . $this->id . '_password'
            ),
            $this->id . '_section_end' => array(
                'type' => 'sectionend',
                'id' => 'webex_woocommerce_sms_' . $this->id . '_section_end'
            )
        );
    }

    function send($recipient, $sender, $message)
    {
        $username = get_option('webex_woocommerce_sms_' . $this->id . '_username');
        $password = get_option('webex_woocommerce_sms_' . $this->id . '_password');
        $ucs = get_option('webex_woocommerce_sms_service_ucs');
        $parameters = array(
            'username' => $username,
            'password' => $password,
            'text' => $message,
            'from' => $sender,
            'to' => $recipient,
        );

        if ($ucs == "unicode") {
            $parameters['coding'] = "UTF8";
        }else if($ucs == 'gsm') {
            $parameters['text'] = str_replace("Λ" , "%14", $parameters['text']);
            $parameters['text'] = str_replace("Δ" , "%10", $parameters['text']);
            $parameters['text'] = str_replace("Θ" , "%19", $parameters['text']);
            $parameters['text'] = str_replace("Γ" , "%13", $parameters['text']);
            $parameters['text'] = str_replace("Ξ" , "%1A", $parameters['text']);
            $parameters['text'] = str_replace("Π" , "%16", $parameters['text']);
            $parameters['text'] = str_replace("Σ" , "%18", $parameters['text']);
            $parameters['text'] = str_replace("Φ" , "%12", $parameters['text']);
            $parameters['text'] = str_replace("Ψ" , "%17", $parameters['text']);
            $parameters['text'] = str_replace("Ω" , "%15", $parameters['text']);
            $parameters['text'] = str_replace("Ώ" , "%15", $parameters['text']);
            $parameters['text'] = str_replace("€" , "%80", $parameters['text']);
        }

        $qString = http_build_query($parameters);
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => "http://www.smsbox.gr/httpapi/sendsms.php?" . $qString,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET"
        ));
        $response = curl_exec($curl);
        $err = curl_error($curl);
        curl_close($curl);
        if ($err) {
            return "cURL Error #:" . $err;
        } else {
            $expl=explode(" ",$response);
            if ($expl[0] == 20)
                return ['success' => 1];
            return $response;
        }
    }
}

add_filter('webexpert_woocommerce_sms_gateways', 'webexpert_woocommerce_add_sms_smsbox');
function webexpert_woocommerce_add_sms_smsbox($gateways)
{
    $gateways[] = new Webexpert_Woocommerce_Sms_Smsbox();
    return $gateways;
}
