<?php
class Webexpert_Woocommerce_Sms_SMSAlert extends Webexpert_Woocommerce_Sms_Gateway
{

  public function __construct()
  {
        $this->id = 'smsalert';
        $this->method_title = 'SmsAlert';
        $this->method_description = sprintf(__('These options refers to <a target="_blank" href="%s">Sms Alert</a> SMS service','webexpert-woocommerce-sms'), "http://smsalert.co.in");
        $this->settings = array(
            $this->id . '_section_title' => array(
                'name' => __($this->method_title, 'webexpert-woocommerce-sms'),
                'type' => 'title',
                'desc' => $this->method_description,
                'id' => 'webex_woocommerce_sms_' . $this->id . '_section_title'
            ),
            $this->id . '_apikey' => array(
                'name' => __('Api Key', 'webexpert-woocommerce-sms'),
                'type' => 'text',
                'id' => 'webex_woocommerce_sms_' . $this->id . '_apikey'
            ),
            $this->id . '_section_end' => array(
                'type' => 'sectionend',
                'id' => 'webex_woocommerce_sms_' . $this->id . '_section_end'
            )
        );
    }

function send($recipient, $sender, $message)
{
    $apikey =  get_option('webex_woocommerce_sms_smsalert_apikey') ;
    $mobiles = $recipient;
    $sender_name = $sender;
    $message = urlencode(stripslashes($message));

    $URL="http://www.smsalert.co.in/api/push.json?apikey=$apikey&sender=$sender&mobileno=$mobiles&text=$message";

    $resp = wp_remote_post($URL);

    if(!is_array($resp) || is_wp_error($resp)) {
       $response = ['Άγνωστο σφάλμα'];
       return $response;
    }

    $respObject = json_decode($resp['body']);
    if($respObject->status == 'success') {
        $response = ['success' => 1];
        return $response;
    }
    else {
        if(!empty($respObject->description)) {
          $response = [];
          $response[] = $respObject->description;
          return $response;
        }else {
             $response = ['Άγνωστο σφάλμα'];
             return $response;
        }
    }

    return $response;

}


}


add_filter('webexpert_woocommerce_sms_gateways', 'webexpert_woocommerce_add_sms_smsalert');
function webexpert_woocommerce_add_sms_smsalert($gateways)
{
    $gateways[] = new Webexpert_Woocommerce_Sms_SMSAlert();
    return $gateways;
}
