<?php

class Webexpert_Woocommerce__Sms_Sms365 extends Webexpert_Woocommerce_Sms_Gateway
{
    public function __construct()
    {
        $this->id = 'sms365';
        $this->method_title = 'SMS365';
        $this->method_description = sprintf(__('These options refers to <a target="_blank" href="%s">SMS365</a> SMS service','webexpert-woocommerce-sms'), "https://sms365.gr");
        $this->settings = array(
            $this->id . '_section_title' => array(
                'name' => __($this->method_title, 'webexpert-woocommerce-sms'),
                'type' => 'title',
                'desc' => $this->method_description,
                'id' => 'webex_woocommerce_sms_' . $this->id . '_section_title'
            ),
            $this->id . '_api_key' => array(
	            'name' => __('Token', 'webexpert-woocommerce-sms'),
	            'type' => 'text',
	            'id' => 'webex_woocommerce_sms_' . $this->id . '_api_key'
            ),
            $this->id . '_section_end' => array(
                'type' => 'sectionend',
                'id' => 'webex_woocommerce_sms_' . $this->id . '_section_end'
            )
        );
    }

    function send($recipient, $sender, $message)
    {

	    $response = wp_remote_post("https://sms365.gr/api/sms/bulk", array(
	    	'body' => array(
	    	  'key'     => get_option('webex_woocommerce_sms_sms365_api_key'),
		      'text'    => $message,
		      'from'    => $sender,
		      'to[]'    => $recipient,
		      'type'    => 'json' 
	    	)
	    ));


	    $api_response = json_decode( wp_remote_retrieve_body( $response ), true );

        if(isset($api_response['remarks'])){
            if(strpos(trim($api_response['remarks']) , 'Success') == 0) {
                return ['success' => 1];
            }
        }

        return $api_response;

    }
}

add_filter('webexpert_woocommerce_sms_gateways', 'webexpert_woocommerce_add_sms_sms365');
function webexpert_woocommerce_add_sms_sms365($gateways)
{
    $gateways[] = new Webexpert_Woocommerce__Sms_Sms365();
    return $gateways;
}