<?php

class Webexpert_Woocommerce_Sms_LabsMobile extends Webexpert_Woocommerce_Sms_Gateway
{
    public function __construct()
    {
        $this->id = 'labsmobile';
        $this->method_title = 'LabsMobile';
        $this->method_description = sprintf(__('These options refers to <a target="_blank" href="%s">LabsMobile</a> SMS service','webexpert-woocommerce-sms'), "https://www.labsmobile.com");
        $this->settings = array(
            $this->id . '_section_title' => array(
                'name' => __($this->method_title, 'webexpert-woocommerce-sms'),
                'type' => 'title',
                'desc' => $this->method_description,
                'id' => 'webex_woocommerce_sms_' . $this->id . '_section_title'
            ),
            $this->id . '_username' => array(
                'name' => __('Username', 'webexpert-woocommerce-sms'),
                'type' => 'text',
                'id' => 'webex_woocommerce_sms_' . $this->id . '_username'
            ),
            $this->id . '_password' => array(
                'name' => __('Password', 'webexpert-woocommerce-sms'),
                'type' => 'password',
                'id' => 'webex_woocommerce_sms_' . $this->id . '_password'
            ),
            $this->id . '_section_end' => array(
                'type' => 'sectionend',
                'id' => 'webex_woocommerce_sms_' . $this->id . '_section_end'
            )
        );
    }

    function send($recipient, $sender, $message)
    {
        $username = get_option('webex_woocommerce_sms_' . $this->id . '_username');
        $password = get_option('webex_woocommerce_sms_' . $this->id . '_password');
        $auth_basic = base64_encode("{$username}:{$password}");
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://api.labsmobile.com/json/send",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => '{"message":"' . $message . '", "tpoa":"' . $sender . '","recipient":[{"msisdn":"' . $recipient . '"}]}',
            CURLOPT_HTTPHEADER => array(
                "Authorization: Basic " . $auth_basic,
                "Cache-Control: no-cache",
                "Content-Type: application/json"
            ),
        ));
        $response = curl_exec($curl);
        $err = curl_error($curl);
        curl_close($curl);
        if ($err) {
            return "cURL Error #:" . $err;
        } else {
            $jsonArray = json_decode($response);
            if ($jsonArray->code == 0)
                return ['success' => 1];
            return $response;
        }
    }
}

add_filter('webexpert_woocommerce_sms_gateways', 'webexpert_woocommerce_add_sms_labsmobile');
function webexpert_woocommerce_add_sms_labsmobile($gateways)
{
    $gateways[] = new Webexpert_Woocommerce_Sms_LabsMobile();
    return $gateways;
}