<?php

class Webexpert_Woocommerce_Sms_EasySMS extends Webexpert_Woocommerce_Sms_Gateway
{
    public function __construct()
    {
        $this->id = 'easysms';
        $this->method_title = 'easySMS';
        $this->method_description = sprintf(__('These options refers to <a target="_blank" href="%s">easysms.gr</a> SMS service','webexpert-woocommerce-sms'), "https://www.easysms.gr");
        $this->settings = array(
            $this->id . '_section_title' => array(
                'name' => __($this->method_title, 'webexpert-woocommerce-sms'),
                'type' => 'title',
                'desc' => $this->method_description,
                'id' => 'webex_woocommerce_sms_' . $this->id . '_section_title'
            ),
            $this->id . '_api_key' => array(
                'name' => __('API Key', 'webexpert-woocommerce-sms'),
                'type' => 'text',
                'id' => 'webex_woocommerce_sms_' . $this->id . '_api_key'
            ),
            $this->id . '_section_end' => array(
                'type' => 'sectionend',
                'id' => 'webex_woocommerce_sms_' . $this->id . '_section_end'
            )
        );
    }

    function send($recipient, $sender, $message)
    {
        $api_key = get_option('webex_woocommerce_sms_easysms_api_key');
        $ucs = get_option('webex_woocommerce_sms_service_ucs');
        $parameters = array(
            'key' => $api_key,
            'text' => $message,
            'from' => $sender,
            'to' => $recipient,
            'ucs' => ($ucs == "gsm" ? false : true),
            'type' => 'xml'  // type of return format
        );
        $qString = http_build_query($parameters);
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://easysms.gr/api/sms/send?" . $qString,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET"
        ));
        $response = curl_exec($curl);
        $err = curl_error($curl);
        curl_close($curl);
        if ($err) {
            return "cURL Error #:" . $err;
        } else {
            $xml = simplexml_load_string($response);
            if ((int)$xml->status === 1 && (int)$xml->error === 0)
                return ['success' => 1];
            return $response;
        }
    }
}

add_filter('webexpert_woocommerce_sms_gateways', 'webexpert_woocommerce_add_sms_easysms');
function webexpert_woocommerce_add_sms_easysms($gateways)
{
    $gateways[] = new Webexpert_Woocommerce_Sms_EasySMS();
    return $gateways;
}