<?php

class Webexpert_Woocommerce_Sms_Clicksend extends Webexpert_Woocommerce_Sms_Gateway
{
    public function __construct()
    {
        $this->id = 'clicksend';
        $this->method_title = 'ClikSend';
        $this->method_description = sprintf(__('These options refers to <a target="_blank" href="%s">ClickSend</a> SMS service','webexpert-woocommerce-sms'), "https://www.clicksend.com");
        $this->settings = array(
            $this->id . '_section_title' => array(
                'name' => __($this->method_title, 'webexpert-woocommerce-sms'),
                'type' => 'title',
                'desc' => $this->method_description,
                'id' => 'webex_woocommerce_sms_' . $this->id . '_section_title'
            ),
            $this->id . '_username' => array(
                'name' => __('Username', 'webexpert-woocommerce-sms'),
                'type' => 'text',
                'id' => 'webex_woocommerce_sms_clicksend_username'
            ),
            $this->id . '_api_key' => array(
                'name' => __('Auth Key', 'webexpert-woocommerce-sms'),
                'type' => 'text',
                'id' => 'webex_woocommerce_sms_' . $this->id . '_api_key'
            ),
            $this->id . '_section_end' => array(
                'type' => 'sectionend',
                'id' => 'webex_woocommerce_sms_' . $this->id . '_section_end'
            )
        );
    }

    function send($recipient, $sender, $message)
    {
        $username = get_option('webex_woocommerce_sms_clicksend_username');
        $api_key = get_option('webex_woocommerce_sms_clicksend_api_key');
        $auth_basic = base64_encode("{$username}:{$api_key}");
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://rest.clicksend.com/v3/sms/send",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => "{
                      \"messages\": [
                        {
                          \"source\": \"wordpress\",
                          \"from\": \"$sender\",
                          \"body\": \"$message\",
                          \"to\": \"+$recipient\"
                        }
                      ]
                    }",
            CURLOPT_HTTPHEADER => array(
                "Authorization: Basic " . $auth_basic,
                "Cache-Control: no-cache",
                "Content-Type: application/json"
            ),
        ));
        $response = curl_exec($curl);
        $err = curl_error($curl);
        curl_close($curl);
        if ($err) {
            return "cURL Error #:" . $err;
        } else {
            $jsonArray = json_decode($response);
            if ($jsonArray->response_code == "SUCCESS") {
                return ['success' => 1];
            }
            return $response;
        }
    }
}

add_filter('webexpert_woocommerce_sms_gateways', 'webexpert_woocommerce_add_sms_clicksend');
function webexpert_woocommerce_add_sms_clicksend($gateways)
{
    $gateways[] = new Webexpert_Woocommerce_Sms_Clicksend();
    return $gateways;
}