<?php

class Webexpert_Woocommerce_Sms_Clickatell extends Webexpert_Woocommerce_Sms_Gateway
{
    public function __construct()
    {
        $this->id = 'clickatell';
        $this->method_title = 'Clickatell';
        $this->method_description = sprintf(__('These options refers to <a target="_blank" href="%s">Clickatell</a> SMS service','webexpert-woocommerce-sms'), "https://www.clickatell.com");
        $this->settings = array(
            $this->id . '_section_title' => array(
                'name' => __($this->method_title, 'webexpert-woocommerce-sms'),
                'type' => 'title',
                'desc' => $this->method_description,
                'id' => 'webex_woocommerce_sms_' . $this->id . '_section_title'
            ),
            $this->id . '_api_key' => array(
                'name' => __('API Key', 'webexpert-woocommerce-sms'),
                'type' => 'text',
                'id' => 'webex_woocommerce_sms_' . $this->id . '_api_key'
            ),
            $this->id . '_way' => array(
                'name' => __('Messaging type', 'webexpert-woocommerce-sms'),
                'type' => 'radio',
                'id' => 'webex_woocommerce_sms_' . $this->id . '_way',
                'default' => 'one_way',
                'options' => [
                    'one_way' => 'One-way messaging',
                    'two_way' => 'Two-way messaging',
                ]
            ),
            $this->id . '_section_end' => array(
                'type' => 'sectionend',
                'id' => 'webex_woocommerce_sms_' . $this->id . '_section_end'
            )
        );
    }

    function send($recipient, $sender, $message)
    {
        $api_key = get_option('webex_woocommerce_sms_' . $this->id . '_api_key');
        $way = get_option('webex_woocommerce_sms_' . $this->id . '_way');
        $parameters = array(
            'apiKey' => $api_key,
            'content' => $message,
            'to' => $recipient,
        );

        if ($way == "two_way") {
            $parameters['from'] = $sender;
        }

        $qString = http_build_query($parameters);
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://platform.clickatell.com/messages/http/send?" . $qString,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET"
        ));
        $response = curl_exec($curl);
        $err = curl_error($curl);
        curl_close($curl);
        if ($err) {
            return "cURL Error #:" . $err;
        } else {
            $jsonArray = json_decode($response);
            if ($jsonArray->messages[0]-> accepted == 1)
                return ['success' => 1];
            return $response;
        }
    }
}

add_filter('webexpert_woocommerce_sms_gateways', 'webexpert_woocommerce_add_sms_clickatell');
function webexpert_woocommerce_add_sms_clickatell($gateways)
{
    $gateways[] = new Webexpert_Woocommerce_Sms_Clickatell();
    return $gateways;
}