<?php

class Webexpert_Woocommerce_Sms_Bulker extends Webexpert_Woocommerce_Sms_Gateway
{
    public function __construct()
    {
        $this->id = 'bulker';
        $this->method_title = 'Bulker.gr';
        $this->method_description = sprintf(__('These options refers to <a target="_blank" href="%s">bulker.gr</a> SMS service','webexpert-woocommerce-sms'), "https://www.bulker.gr");
        $this->settings = array(
            $this->id . '_section_title' => array(
                'name' => __($this->method_title, 'webexpert-woocommerce-sms'),
                'type' => 'title',
                'desc' => $this->method_description,
                'id' => 'webex_woocommerce_sms_' . $this->id . '_section_title'
            ),
            $this->id . '_auth_key' => array(
                'name' => __('Auth Key', 'webexpert-woocommerce-sms'),
                'type' => 'text',
                'id' => 'webex_woocommerce_sms_' . $this->id . '_auth_key'
            ),
            $this->id . '_section_end' => array(
                'type' => 'sectionend',
                'id' => 'webex_woocommerce_sms_' . $this->id . '_section_end'
            )
        );
    }

    function send($recipient, $sender, $message)
    {
        $auth_key = get_option('webex_woocommerce_sms_bulker_auth_key');
        $ucs = get_option('webex_woocommerce_sms_service_ucs');
        $parameters = array(
            'auth_key' => $auth_key,
            'text' => $message,
            'from' => strtoupper($sender),
            'to' => $recipient,
            'coding' => ($ucs == "gsm" ? 0 : 1),
            'id' => time()  // type of return format
        );
        $qString = http_build_query($parameters);
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => "http://api.bulker.gr/http/sms.php?" . $qString,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET"
        ));
        $response = curl_exec($curl);
        $err = curl_error($curl);
        curl_close($curl);
        if ($err) {
            return "cURL Error #:" . $err;
        } else {
            $expl = explode(";", $response);
            if ($expl[0] == "OK") {
                return ['success' => 1];
            }
            return $response;
        }
    }
}

add_filter('webexpert_woocommerce_sms_gateways', 'webexpert_woocommerce_add_sms_bulker');
function webexpert_woocommerce_add_sms_bulker($gateways)
{
    $gateways[] = new Webexpert_Woocommerce_Sms_Bulker();
    return $gateways;
}