<?php

class Webexpert_Woocommerce_Sms_Beeper extends Webexpert_Woocommerce_Sms_Gateway
{
    public function __construct()
    {
        $this->id = 'beeper';
        $this->method_title = 'Beeper';
        $this->method_description = sprintf(__('These options refers to <a target="_blank" href="%s">Beeper</a> SMS service','webexpert-woocommerce-sms'), "https://app.beeper.gr");
        $this->settings = array(
            $this->id . '_section_title' => array(
                'name' => __($this->method_title, 'webexpert-woocommerce-sms'),
                'type' => 'title',
                'desc' => $this->method_description,
                'id' => 'webex_woocommerce_sms_' . $this->id . '_section_title'
            ),
            $this->id . '_api_token' => array(
	            'name' => __('Token', 'webexpert-woocommerce-sms'),
	            'type' => 'text',
	            'id' => 'webex_woocommerce_sms_' . $this->id . '_api_token'
            ),
            $this->id . '_secret' => array(
	            'name' => __('Secret', 'webexpert-woocommerce-sms'),
	            'type' => 'text',
	            'id' => 'webex_woocommerce_sms_' . $this->id . '_secret'
            ),
            $this->id . '_section_end' => array(
                'type' => 'sectionend',
                'id' => 'webex_woocommerce_sms_' . $this->id . '_section_end'
            )
        );
    }

    function send($recipient, $sender, $message)
    {
	    $api_token = get_option('webex_woocommerce_sms_beeper_api_token');
	    $secret = get_option('webex_woocommerce_sms_beeper_secret');

	    $curl = curl_init();
	    $fields = [
		    "secret" => $secret,
		    "sender" => $sender,
		    "recipient" => $recipient,
		    "message" => $message
	    ];
	    $fields = http_build_query($fields);

	    curl_setopt_array($curl, array(
		    CURLOPT_URL => "https://app.beeper.gr/api/send-sms",
		    CURLOPT_RETURNTRANSFER => true,
		    CURLOPT_ENCODING => "",
		    CURLOPT_MAXREDIRS => 10,
		    CURLOPT_POST => 1,
		    CURLOPT_POSTFIELDS => $fields,
		    CURLOPT_TIMEOUT => 30,
		    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		    CURLOPT_HTTPHEADER => array(
			    "Authorization: Bearer $api_token"
		    ),
	    ));

	    $response = curl_exec($curl);
	    $err = curl_error($curl);
	    curl_close($curl);

	    if ($err) {
		    echo"cURL Error #:" . $err;
	    } else {
		    $obj = json_decode($response);
		    if($obj->statusCode == 200){
			    return ['success' => 1];
		    }
		    return $response;
	    }
    }
}

add_filter('webexpert_woocommerce_sms_gateways', 'webexpert_woocommerce_add_sms_beeper');
function webexpert_woocommerce_add_sms_beeper($gateways)
{
    $gateways[] = new Webexpert_Woocommerce_Sms_Beeper();
    return $gateways;
}