<?php
class Webexpert_Woocommerce_Sms_Apifon extends Webexpert_Woocommerce_Sms_Gateway
{
    public function __construct()
    {
        $this->id = 'apifon';
        $this->method_title = 'Apifon';
        $this->method_description = sprintf(__('These options refers to <a target="_blank" href="%s">Apifon</a> SMS service','webexpert-woocommerce-sms'), "https://www.apifon.com/");
        $this->settings = array(
            $this->id . '_section_title' => array(
                'name' => __($this->method_title, 'webexpert-woocommerce-sms'),
                'type' => 'title',
                'desc' => $this->method_description,
                'id' => 'webex_woocommerce_sms_' . $this->id . '_section_title'
            ),
            $this->id . '_token' => array(
	            'name' => __('API Token', 'webexpert-woocommerce-sms'),
	            'type' => 'text',
	            'id' => 'webex_woocommerce_sms_' . $this->id . '_token'
            ),
            $this->id . '_secret_key' => array(
	            'name' => __('Secret Key', 'webexpert-woocommerce-sms'),
	            'type' => 'text',
	            'id' => 'webex_woocommerce_sms_' . $this->id . '_secret_key'
            ),
            $this->id . '_viber_enable' => array(
                'name' => __('Enable Viber', 'webexpert-woocommerce-sms'),
                'type' => 'checkbox',
                'id' => 'webex_woocommerce_sms_' . $this->id . '_enable_viber'
            ),
            $this->id . '_viber_sender' => array(
                'name' => __('Viber Sender Name', 'webexpert-woocommerce-sms'),
                'type' => 'text',
                'id' => 'webex_woocommerce_sms_' . $this->id . '_viber_sender'
            ),
            $this->id . '_section_end' => array(
                'type' => 'sectionend',
                'id' => 'webex_woocommerce_sms_' . $this->id . '_section_end'
            )
        );
    }

    function send($recipient, $sender, $message)
    {
	    $token = get_option('webex_woocommerce_sms_apifon_token');
	    $secretKey = get_option('webex_woocommerce_sms_apifon_secret_key');

        if(get_option('webex_woocommerce_sms_apifon_enable_viber') == "yes") {
            $endpoint = "/services/api/v1/im/send";
            $body = json_encode(array(
                "subscribers" => [
                    ["number" => "$recipient"]
                ],
                "message" => [
                    "sender_id" => strtoupper($sender),
                    "text" => "$message",
                ],
                'im_channels'=> [
                    [
                        'sender_id'=>empty(get_option('webex_woocommerce_sms_apifon_viber_sender')) ? $sender : get_option('webex_woocommerce_sms_apifon_viber_sender'),
                        "text" => "$message",
                    ]
                ]
            ));
        }else {
            $endpoint = "/services/api/v1/sms/send";

            $body = json_encode(array(
                "subscribers" => [
                    ["number" => "$recipient"]
                ],
                "message" => [
                    "sender_id" => strtoupper($sender),
                    "text" => "$message",
                ]
            ));
        }
        $url = "https://ars.apifon.com" . $endpoint;

	    $dateTime = new \DateTime();
	    $dateTime->setTimezone(new \DateTimeZone('GMT'));
	    $requestDate = $dateTime->format('D, d M Y H:i:s T');

	    $message = "POST"."\n"
		    . $endpoint . "\n"
		    . $body . "\n"
		    . $requestDate;

	    $signature = base64_encode(hash_hmac('SHA256', $message, $secretKey, true));

	    $header = array();
	    $header[] = "Content-type: application/json";
	    $header[] = "Authorization: ApifonWS " . $token . ":" . $signature;
	    $header[] = "X-ApifonWS-Date: " . $requestDate;

	    $curl = curl_init($url);
	    curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
	    curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
	    curl_setopt($curl, CURLOPT_HEADER, false);
	    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
	    curl_setopt($curl, CURLOPT_HTTPHEADER, $header);
	    curl_setopt($curl, CURLOPT_POST, true);
	    curl_setopt($curl, CURLOPT_POSTFIELDS, $body);

	    $response = curl_exec($curl);
	    $response_decoded=json_decode($response);
        if ($response_decoded->result_info->description!="OK") {
            return $response_decoded;
        } else {
	        return ['success' => 1];
        }
    }
}

add_filter('webexpert_woocommerce_sms_gateways', 'webexpert_woocommerce_add_sms_apifon');
function webexpert_woocommerce_add_sms_apifon($gateways)
{
    $gateways[] = new Webexpert_Woocommerce_Sms_Apifon();
    return $gateways;
}
