<?php

class Webexpert_Woocommerce_Sms
{
    protected $loader;
    protected $plugin_name;
    protected $version;

    public function __construct()
    {
        if (defined('PLUGIN_NAME_VERSION')) {
            $this->version = PLUGIN_NAME_VERSION;
        } else {
            $this->version = '1.0.0';
        }
        $this->plugin_name = 'webexpert-woocommerce-sms';
        $this->load_dependencies();
        $this->set_locale();
        $this->define_admin_hooks();
        $this->define_public_hooks();
    }

    private function load_dependencies()
    {
        require_once plugin_dir_path(dirname(__FILE__)) . 'includes/class-webexpert-woocommerce-sms-loader.php';
	    require_once plugin_dir_path(dirname(__FILE__)) . 'includes/class-webexpert-woocommerce-sms-i18n.php';
	    require_once plugin_dir_path(dirname(__FILE__)) . 'includes/class-webexpert-woocommerce-sms-general-functions.php';
        require_once plugin_dir_path(dirname(__FILE__)) . 'admin/class-webexpert-woocommerce-sms-admin.php';
        require_once plugin_dir_path(dirname(__FILE__)) . 'public/class-webexpert-woocommerce-sms-public.php';
        require_once plugin_dir_path(dirname(__FILE__)) . 'includes/class-webexpert-woocommerce-sms-gateway.php';
	    require_once plugin_dir_path(dirname(__FILE__)) . 'includes/gateways/class-webexpert-woocommerce-sms-apifon.php';
	    require_once plugin_dir_path(dirname(__FILE__)) . 'includes/gateways/class-webexpert-woocommerce-sms-beeper.php';
        require_once plugin_dir_path(dirname(__FILE__)) . 'includes/gateways/class-webexpert-woocommerce-sms-sms365.php';
	    require_once plugin_dir_path(dirname(__FILE__)) . 'includes/gateways/class-webexpert-woocommerce-sms-bulker.php';
        require_once plugin_dir_path(dirname(__FILE__)) . 'includes/gateways/class-webexpert-woocommerce-sms-clicksend.php';
        require_once plugin_dir_path(dirname(__FILE__)) . 'includes/gateways/class-webexpert-woocommerce-sms-clickatell.php';
        require_once plugin_dir_path(dirname(__FILE__)) . 'includes/gateways/class-webexpert-woocommerce-sms-easysms.php';
        require_once plugin_dir_path(dirname(__FILE__)) . 'includes/gateways/class-webexpert-woocommerce-sms-labsmobile.php';
	    require_once plugin_dir_path(dirname(__FILE__)) . 'includes/gateways/class-webexpert-woocommerce-sms-senditnow.php';
	    require_once plugin_dir_path(dirname(__FILE__)) . 'includes/gateways/class-webexpert-woocommerce-sms-smsbox.php';
	    require_once plugin_dir_path(dirname(__FILE__)) . 'includes/gateways/class-webexpert-woocommerce-sms-smscanal.php' ;
        require_once plugin_dir_path(dirname(__FILE__)) . 'includes/gateways/class-webexpert-woocommerce-sms-smsalert.php' ;
	    require_once plugin_dir_path(dirname(__FILE__)) . 'includes/gateways/class-webexpert-woocommerce-sms-smsnet.php';
	    require_once plugin_dir_path(dirname(__FILE__)) . 'includes/gateways/class-webexpert-woocommerce-sms-yuboto.php';
        $this->loader = new Webexpert_Woocommerce_Sms_Loader();
    }

    private function set_locale()
    {
        $plugin_i18n = new Webexpert_Woocommerce_Sms_i18n();
        $this->loader->add_action('plugins_loaded', $plugin_i18n, 'load_plugin_textdomain');
    }

    private function define_admin_hooks()
    {
        $add_cellphone=get_option('webex_woocommerce_sms_add_cellphone');
        $plugin_admin = new Webexpert_Woocommerce_Sms_Admin($this->get_plugin_name(), $this->get_version());
        $this->loader->add_action('admin_enqueue_scripts', $plugin_admin, 'enqueue_styles');
        $this->loader->add_action('admin_enqueue_scripts', $plugin_admin, 'enqueue_scripts');
        $this->loader->add_action('admin_enqueue_scripts', $plugin_admin, 'enqueue_scripts');
        $this->loader->add_filter('woocommerce_settings_tabs_array', $plugin_admin, 'add_woocommerce_sms_tab', 50);
        $this->loader->add_action('woocommerce_update_options_woocommerce_sms', $plugin_admin, 'woocommerce_sms_update_settings');
        $this->loader->add_action('woocommerce_settings_tabs_woocommerce_sms', $plugin_admin, 'woocommerce_sms_settings_tab');
        $this->loader->add_filter('woocommerce_get_sections_woocommerce_sms', $plugin_admin, 'get_sections', 10, 1);
        $this->loader->add_action('woocommerce_sections_woocommerce_sms', $plugin_admin, 'output_sections');
        $this->loader->add_action('add_meta_boxes', $plugin_admin, 'webexpert_woocommerce_sms_add_order_sms_box');
        $this->loader->add_action('wp_ajax_woocommerce_send_sms_act', $plugin_admin, 'webexpert_woocommerce_send_sms_act');

        if ($add_cellphone=="yes") {
            $this->loader->add_filter('woocommerce_admin_billing_fields', $plugin_admin, 'webexpert_woocommerce_sms_admin_billing_fields');
            $this->loader->add_filter('woocommerce_formatted_address_replacements', $plugin_admin, 'webexpert_woocommerce_sms_formatted_address_replacements', 10, 2);
            $this->loader->add_filter('woocommerce_order_formatted_billing_address', $plugin_admin, 'webexpert_woocommerce_sms_order_fields', 10, 2);
        }
    }

    public function get_plugin_name()
    {
        return $this->plugin_name;
    }

    public function get_version()
    {
        return $this->version;
    }

    private function define_public_hooks()
    {
        $add_cellphone=get_option('webex_woocommerce_sms_add_cellphone');
        $plugin_public = new Webexpert_Woocommerce_Sms_Public($this->get_plugin_name(), $this->get_version());
        if ($add_cellphone=="yes") {
            $this->loader->add_filter('woocommerce_billing_fields', $plugin_public, 'webexpert_woocommerce_sms_billing_fields');
            $this->loader->add_filter('woocommerce_customer_meta_fields', $plugin_public, 'webexpert_woocommerce_sms_customer_meta_fields');
            $this->loader->add_action('woocommerce_checkout_process', $plugin_public, 'webexpert_woocommerce_sms_checkout_field_process');
            $this->loader->add_action('woocommerce_found_customer_details', $plugin_public, 'webexpert_woocommerce_sms_found_customer_details', 10, 3);
        }
    }

    public function run()
    {
        $this->loader->run();
    }

    public function get_loader()
    {
        return $this->loader;
    }
}
