(function ($) {
    'use strict';
    $(document).ready(function () {
        function count() {
            var txtVal = $('#woocommerce_sms_message').val();
            var chars = txtVal.length;
            $('#woocommerce_sms_message_counter span').html(chars);
        }

        function enable_disable_cellphone() {
            if ($('#webex_woocommerce_sms_add_cellphone').is(':checked')) {
                $('#webex_woocommerce_sms_force_cellphone').attr('disabled',false);
            }else {
                $('#webex_woocommerce_sms_force_cellphone').attr('disabled',true);
            }
        }

        function check_if_gr_mobile() {
            if ($('#woocommerce_sms_recipient').data('country')=="GR" && $('#woocommerce_sms_recipient').val().startsWith("302")) {
                $('#woocommerce_sms_send_sms').attr('disabled',true);
            }else {
                $('#woocommerce_sms_send_sms').attr('disabled',false);
            }
        }

        check_if_gr_mobile();
        $('#woocommerce_sms_recipient').on('propertychange change click keyup input paste',function(){
            check_if_gr_mobile();
        });

        enable_disable_cellphone();
        $('#webex_woocommerce_sms_add_cellphone').on('click',function(){
            enable_disable_cellphone();
        });

        $('#woocommerce_sms_message').on('keyup propertychange paste', function () {
            count();
        });

        $(document).on('click', '#woocommerce_sms_send_sms', function (e) {
            var $btn = $(this);
            $btn.html($btn.data('sending')).attr("disabled", true);
            e.preventDefault();
            if (!$.trim($("#woocommerce_sms_message").val()) || !$.trim($("#woocommerce_sms_recipient").val())) {
                $btn.html($btn.data('send')).attr("disabled", false);
                alert($btn.data('no-message'));
            }
            var data = {
                'action': 'woocommerce_send_sms_act',
                'message': $("#woocommerce_sms_message").val(),
                'order_id': $("#woocommerce_sms_order_id").val(),
                'recipient': $("#woocommerce_sms_recipient").val()
            };
            $.ajax({
                type: 'POST',
                url: webexpert_ajax_object.ajax_url,
                data: data,
                success: function (response) {
                    if (response.success===1) {
                        $btn.html($btn.data('sent'));
                    }else {
                        $btn.html($btn.data('send')).attr("disabled", false);
                        alert($btn.data('error'));
                    }

                    console.log(response);
                },
                error: function (xhr, textStatus, error) {
                    console.log(xhr.statusText);
                    console.log(textStatus);
                    console.log(error);
                }
            });
        })
    })
})(jQuery);
