<?php

class Webexpert_Woocommerce_Sms_Admin
{
    private $plugin_name;
    private $version;

    public function __construct($plugin_name, $version)
    {
        $this->plugin_name = $plugin_name;
        $this->version = $version;
    }

    public static function add_woocommerce_sms_tab($settings_tabs)
    {
        $settings_tabs['woocommerce_sms'] = __('WooCommerce SMS', 'webexpert-woocommerce-sms');
        return $settings_tabs;
    }

    public function enqueue_styles()
    {
        wp_enqueue_style($this->plugin_name, plugin_dir_url(__FILE__) . 'css/webexpert-woocommerce-sms-admin.css', array(), $this->version, 'all');
    }

    public function enqueue_scripts()
    {
        wp_enqueue_script($this->plugin_name, plugin_dir_url(__FILE__) . 'js/webexpert-woocommerce-sms-admin.js', array('jquery'), $this->version, false);
        wp_localize_script($this->plugin_name, 'webexpert_ajax_object', array('ajax_url' => admin_url('admin-ajax.php')));
    }

    function woocommerce_sms_settings_tab()
    {
        woocommerce_admin_fields(self::woocommerce_sms_tab());
    }

    function woocommerce_sms_tab()
    {
        global $current_section;
        $gateways = $this->get_gateways();
        $not_found = 1;
        foreach ($gateways as $gateway) {
            if ($gateway->id . '_settings' == $current_section) {
                $settings = $gateway->get_settings();
                $not_found = 0;
                continue;
            }
        }
        if ($not_found) {
            $settings = array(
                'section_title' => array(
                    'name' => __('General settings', 'webexpert-woocommerce-sms'),
                    'type' => 'title',
                    'desc' => '',
                    'id' => 'webex_woocommerce_sms_section_title'
                ),
                'title' => array(
                    'name' => __('SMS Service', 'webexpert-woocommerce-sms'),
                    'type' => 'select',
                    'id' => 'webex_woocommerce_sms_service',
                    'options' => $this->webexpert_woocommerce_sms_list_gateways()
                ),
                'sender' => array(
                    'name' => __('Sender', 'webexpert-woocommerce-sms'),
                    'type' => 'text',
                    'desc' => '',
                    'id' => 'webex_woocommerce_sms_service_sender'
                ),
                'ucs' => array(
                    'name' => __('Encoding', 'webexpert-woocommerce-sms'),
                    'type' => 'radio',
                    'id' => 'webex_woocommerce_sms_service_ucs',
                    'options' => array(
                        'gsm' => 'GSM',
                        'unicode' => 'Unicode'
                    )
                ),
                'add_cellphone' => array(
                    'name' => '',
                    'type' => 'checkbox',
                    'id' => 'webex_woocommerce_sms_add_cellphone',
                    'desc' => __('Add cellphone field to checkout form (Leave unchecked to use phone field instead)', 'webexpert-woocommerce-sms'),
                    'checkboxgroup'=>'start',
                ),
                'force_cellphone' => array(
                    'name' => '',
                    'type' => 'checkbox',
                    'id' => 'webex_woocommerce_sms_force_cellphone',
                    'desc' => __('Force cellphone field to checkout form', 'webexpert-woocommerce-sms'),
                    'checkboxgroup' => 'end',
                ),
                'section_end' => array(
                    'type' => 'sectionend',
                    'id' => 'webex_woocommerce_sms_settings'
                )
            );
        }
        return apply_filters('woocommerce_get_settings_woocommerce_sms', $settings, $current_section);
    }

    public function get_gateways()
    {
        return apply_filters('webexpert_woocommerce_sms_gateways', []);
    }

    public function webexpert_woocommerce_sms_list_gateways()
    {
        $options = [];
        $gateways = $gateways = $this->get_gateways();
        foreach ($gateways as $gateway) {
            $options[get_class($gateway)] = $gateway->method_title;
        }
        return $options;
    }

    function woocommerce_sms_update_settings()
    {
        woocommerce_update_options(self::woocommerce_sms_tab());
    }

    function output_sections()
    {
        global $current_section;
        $sections = $this->get_sections();
        if (empty($sections) || 1 === sizeof($sections)) {
            return;
        }
        echo '<ul class="subsubsub">';
        $array_keys = array_keys($sections);
        foreach ($sections as $id => $label) {
            echo '<li><a href="' . admin_url('admin.php?page=wc-settings&tab=woocommerce_sms&section=' . sanitize_title($id)) . '" class="' . ($current_section == $id ? 'current' : '') . '">' . $label . '</a> ' . (end($array_keys) == $id ? '' : '|') . ' </li>';
        }
        echo '</ul><br class="clear" />';
    }

    public function get_sections()
    {
        $sections = array(
            '' => __('General settings', 'webexpert-woocommerce-sms'),
        );
        $gateways = $this->get_gateways();
        foreach ($gateways as $gateway) {
            $sections[$gateway->get_id() . '_settings'] = $gateway->get_method_title();
        }
        return $sections;
    }

    public function freeship_add_settings_tab($settings_tab)
    {
        $settings_tab['general_settings'] = __('General settings');
        return $settings_tab;
    }

    public function webexpert_woocommerce_sms_admin_billing_fields($billing_fields)
    {
        $billing_fields['cellphone'] = array(
            'type' => 'text',
            'label' => __('Cellphone', 'webexpert-woocommerce-sms'),
            'placeholder' => _x('Cellphone', 'placeholder', 'webexpert-woocommerce-sms'),
            'required' => false,
            'clear' => false,
            'show' => true,
            'wrapper_class' => 'form-field-left',
        );
        return $billing_fields;
    }

    function webexpert_woocommerce_sms_order_fields($address, $order)
    {
        $address['billing_cellphone'] = $order->get_meta( 'billing_cellphone');
        return $address;
    }

    function webexpert_woocommerce_sms_formatted_address_replacements($replace, $args)
    {
        $replace['{billing_cellphone}'] = !empty($args['billing_cellphone']) ? __('Cellphone', 'webexpert-woocommerce-sms') . ': ' . $args['billing_cellphone'] : '';
        return $replace;
    }

    function webexpert_woocommerce_sms_add_order_sms_box()
    {
	    $screen = wc_get_container()->get( \Automattic\WooCommerce\Internal\DataStores\Orders\CustomOrdersTableController::class )->custom_orders_table_usage_is_enabled()
		    ? wc_get_page_screen_id( 'shop-order' )
		    : 'shop_order';

        add_meta_box('webexpert_woocommerce_meta_box',__('WooCommerce SMS','webexpert-woocommerce-sms'),array($this, 'webexpert_woocommerce_sms_order_box_html'),$screen,'side');
    }

    function webexpert_woocommerce_sms_get_recipeint($order=null) {
        global $post;
        $post_id=null;

        if ( false === $order && is_a( $post, 'WP_Post' ) && 'shop_order' === get_post_type( $post ) ) {
            $post_id = $post->ID;
        } elseif ( is_numeric( $order ) ) {
            $post_id =  $order;
        } elseif ( $order instanceof WC_Abstract_Order ) {
            $post_id =  $order->get_id();
        } elseif ( ! empty( $order->ID ) ) {
            $post_id =  $order->ID;
        }
        if ($post_id) {
            $the_order=wc_get_order($post_id);
            if ($the_order) {
                $phone = get_option('webex_woocommerce_sms_add_cellphone')=="yes" ? $the_order->get_meta('_billing_cellphone') : $the_order->get_billing_phone();
                if (substr( $phone, 0, 3 ) == "302") {
                    return false;
                }
                return $phone;
            }
        }
        return false;
    }

    function webexpert_woocommerce_sms_order_box_html($post)
    {
	    $order = ( $post instanceof WP_Post ) ? wc_get_order( $post->ID ) : $post;
        if ($order) {
            $country = $order->get_billing_country();
            $message = apply_filters('webexpert_woocommerce_sms_default_message','');
            $recipient = $this->webexpert_woocommerce_sms_get_recipeint($post->ID);
        ?>
            <div>
                <label for="woocommerce_sms_message"><?php _e('Add message', 'webexpert-woocommerce-sms'); ?></label><br>
                <textarea id="woocommerce_sms_message" name="woocommerce_sms_message" class="input-text" cols="20"
                          rows="5"><?php echo $message; ?></textarea>
                <div id="woocommerce_sms_message_counter">
                    <span><?php echo mb_strlen($message); ?></span>/<?php echo(get_option('webex_woocommerce_sms_service_ucs') == "gsm" ? '160' : '70'); ?>
                </div>
            </div>
            <div>
                <label for="woocommerce_sms_recipient"><?php _e('Recipient', 'webexpert-woocommerce-sms'); ?></label><br>
                <input data-country="<?php echo $country;?>" type="text" id="woocommerce_sms_recipient" name="woocommerce_sms_recipient"
                       value="<?php echo $this->format_number(apply_filters('webexpert_woocommerce_sms_recipient',$recipient), $country); ?>"
                       class="input-text">
            </div>
            <div>
                <br>
                <button data-sending="<?php _e('Sending...', 'webexpert-woocommerce-sms'); ?>"
                        data-no-message="<?php _e('No message', 'webexpert-woocommerce-sms'); ?>"
                        data-sent="<?php _e('SMS has been sent!', 'webexpert-woocommerce-sms'); ?>"
                        data-error="<?php _e('An error has occurred!', 'webexpert-woocommerce-sms'); ?>"
                        data-send="<?php _e('Send SMS', 'webexpert-woocommerce-sms'); ?>" type="button"
                        class="woocommerce_sms_send_sms button"
                        id="woocommerce_sms_send_sms"><?php _e('Send SMS', 'webexpert-woocommerce-sms'); ?></button>
                <input type="hidden" name="woocommerce_sms_order_id" id="woocommerce_sms_order_id" value="<?php echo $post->ID;?>">
            </div>
        <?php
        }
    }

    function format_number($cellphone, $country = null)
    {
        $country_codes = array('AC' => '247', 'AD' => '376', 'AE' => '971', 'AF' => '93', 'AG' => '1268', 'AI' => '1264', 'AL' => '355', 'AM' => '374', 'AO' => '244', 'AQ' => '672', 'AR' => '54', 'AS' => '1684', 'AT' => '43', 'AU' => '61', 'AW' => '297', 'AX' => '358', 'AZ' => '994', 'BA' => '387', 'BB' => '1246', 'BD' => '880', 'BE' => '32', 'BF' => '226', 'BG' => '359', 'BH' => '973', 'BI' => '257', 'BJ' => '229', 'BL' => '590', 'BM' => '1441', 'BN' => '673', 'BO' => '591', 'BQ' => '599', 'BR' => '55', 'BS' => '1242', 'BT' => '975', 'BW' => '267', 'BY' => '375', 'BZ' => '501', 'CA' => '1', 'CC' => '61', 'CD' => '243', 'CF' => '236', 'CG' => '242', 'CH' => '41', 'CI' => '225', 'CK' => '682', 'CL' => '56', 'CM' => '237', 'CN' => '86', 'CO' => '57', 'CR' => '506', 'CU' => '53', 'CV' => '238', 'CW' => '599', 'CX' => '61', 'CY' => '357', 'CZ' => '420', 'DE' => '49', 'DJ' => '253', 'DK' => '45', 'DM' => '1767', 'DO' => '1809', 'DO' => '1829', 'DO' => '1849', 'DZ' => '213', 'EC' => '593', 'EE' => '372', 'EG' => '20', 'EH' => '212', 'ER' => '291', 'ES' => '34', 'ET' => '251', 'EU' => '388', 'FI' => '358', 'FJ' => '679', 'FK' => '500', 'FM' => '691', 'FO' => '298', 'FR' => '33', 'GA' => '241', 'GB' => '44', 'GD' => '1473', 'GE' => '995', 'GF' => '594', 'GG' => '44', 'GH' => '233', 'GI' => '350', 'GL' => '299', 'GM' => '220', 'GN' => '224', 'GP' => '590', 'GQ' => '240', 'GR' => '30', 'GT' => '502', 'GU' => '1671', 'GW' => '245', 'GY' => '592', 'HK' => '852', 'HN' => '504', 'HR' => '385', 'HT' => '509', 'HU' => '36', 'ID' => '62', 'IE' => '353', 'IL' => '972', 'IM' => '44', 'IN' => '91', 'IO' => '246', 'IQ' => '964', 'IR' => '98', 'IS' => '354', 'IT' => '39', 'JE' => '44', 'JM' => '1876', 'JO' => '962', 'JP' => '81', 'KE' => '254', 'KG' => '996', 'KH' => '855', 'KI' => '686', 'KM' => '269', 'KN' => '1869', 'KP' => '850', 'KR' => '82', 'KW' => '965', 'KY' => '1345', 'KZ' => '7', 'LA' => '856', 'LB' => '961', 'LC' => '1758', 'LI' => '423', 'LK' => '94', 'LR' => '231', 'LS' => '266', 'LT' => '370', 'LU' => '352', 'LV' => '371', 'LY' => '218', 'MA' => '212', 'MC' => '377', 'MD' => '373', 'ME' => '382', 'MF' => '590', 'MG' => '261', 'MH' => '692', 'MK' => '389', 'ML' => '223', 'MM' => '95', 'MN' => '976', 'MO' => '853', 'MP' => '1670', 'MQ' => '596', 'MR' => '222', 'MS' => '1664', 'MT' => '356', 'MU' => '230', 'MV' => '960', 'MW' => '265', 'MX' => '52', 'MY' => '60', 'MZ' => '258', 'NA' => '264', 'NC' => '687', 'NE' => '227', 'NF' => '672', 'NG' => '234', 'NI' => '505', 'NL' => '31', 'NO' => '47', 'NP' => '977', 'NR' => '674', 'NU' => '683', 'NZ' => '64', 'OM' => '968', 'PA' => '507', 'PE' => '51', 'PF' => '689', 'PG' => '675', 'PH' => '63', 'PK' => '92', 'PL' => '48', 'PM' => '508', 'PR' => '1787', 'PR' => '1939', 'PS' => '970', 'PT' => '351', 'PW' => '680', 'PY' => '595', 'QA' => '974', 'QN' => '374', 'QS' => '252', 'QY' => '90', 'RE' => '262', 'RO' => '40', 'RS' => '381', 'RU' => '7', 'RW' => '250', 'SA' => '966', 'SB' => '677', 'SC' => '248', 'SD' => '249', 'SE' => '46', 'SG' => '65', 'SH' => '290', 'SI' => '386', 'SJ' => '47', 'SK' => '421', 'SL' => '232', 'SM' => '378', 'SN' => '221', 'SO' => '252', 'SR' => '597', 'SS' => '211', 'ST' => '239', 'SV' => '503', 'SX' => '1721', 'SY' => '963', 'SZ' => '268', 'TA' => '290', 'TC' => '1649', 'TD' => '235', 'TG' => '228', 'TH' => '66', 'TJ' => '992', 'TK' => '690', 'TL' => '670', 'TM' => '993', 'TN' => '216', 'TO' => '676', 'TR' => '90', 'TT' => '1868', 'TV' => '688', 'TW' => '886', 'TZ' => '255', 'UA' => '380', 'UG' => '256', 'UK' => '44', 'US' => '1', 'UY' => '598', 'UZ' => '998', 'VA' => '379', 'VA' => '39', 'VC' => '1784', 'VE' => '58', 'VG' => '1284', 'VI' => '1340', 'VN' => '84', 'VU' => '678', 'WF' => '681', 'WS' => '685', 'XC' => '991', 'XD' => '888', 'XG' => '881', 'XL' => '883', 'XN' => '857', 'XN' => '858', 'XN' => '870', 'XP' => '878', 'XR' => '979', 'XS' => '808', 'XT' => '800', 'XV' => '882', 'YE' => '967', 'YT' => '262', 'ZA' => '27', 'ZM' => '260', 'ZW' => '263');
        if ($country===null) {
	        $default_country = get_option('woocommerce_default_country');
	        if (strpos($default_country, ':') !== false) {
		        $expl = explode(":", $default_country);
		        $default_country = $expl[0];
		        $country = $default_country;
	        }
        }
        $default_country_code = $country_codes[$country];
        $numbers = [$cellphone => $country];
        foreach ($numbers as $n => $c) {
            $n = preg_replace("/\([0-9]+?\)/", "", $n);
            $n = preg_replace("/[^0-9]/", "", $n);
            $n = ltrim($n, '0');
            if (array_key_exists($c, $country_codes)) {
                $pfx = $country_codes[$c];
            } else {
                $pfx = $default_country_code;
            }
            if (!preg_match('/^' . $pfx . '/', $n)) {
                $n = $pfx . $n;
            }
            return $n;
        }

        return $cellphone;
    }

    function webexpert_woocommerce_send_sms_act()
    {
        $order_id = isset($_POST['order_id']) ? sanitize_text_field($_POST['order_id']) : null;
        $message = sanitize_text_field($_POST['message']);
        $recipient = sanitize_text_field($_POST['recipient']);
        $response = $this->webexpert_woocommerce_send_sms($message, $recipient);
        do_action('webexpert_send_sms_action',$order_id,$message,$recipient,$response);
        wp_send_json($response);
    }

    function webexpert_woocommerce_send_sms($message, $recipient)
    {
        $service = get_option('webex_woocommerce_sms_service');
        $sender = get_option('webex_woocommerce_sms_service_sender');
        $type = get_option('webex_woocommerce_sms_service_ucs');
	    $recipient=$this->format_number($recipient);

	    if (substr( $recipient, 0, 3 ) == "302") {
		    return ['success' => 0,'error'=>__('Landline phone detected','webexpert-woocommerce-sms')];
	    }

        if ($type == "gsm") {
            $message = $this->webexpert_woocommerce_send_sms_convert_to_gsm($message);
        }
        if ($service && is_string($service) && class_exists($service)) {
            $engine = new $service();
            return $engine->send($recipient, $sender, $message);
        }
        return ['success' => 0];
    }

    function webexpert_woocommerce_send_sms_convert_to_gsm($message)
    {
        $message = mb_strtoupper($message);
        $pattern = array(
            '/Α/', '/Ά/', '/Β/', '/Ε/', '/Έ/', '/Ζ/', '/Η/', '/Ή/', '/Ι/', '/Ί/', '/Κ/', '/Μ/', '/Ν/', '/Ο/', '/Ό/', '/Ρ/', '/Τ/', '/Υ/', '/Χ/'
        );
        $replacement = array(
            'A', 'A', 'B', 'E', 'E', 'Z', 'H', 'H', 'I', 'I', 'K', 'M', 'N', 'O', 'O', 'P', 'T', 'Y', 'X'
        );
        return preg_replace($pattern, $replacement, $message);
    }

    function webexpert_woocommerce_sms_send_order_message($order,$message) {
	    $recipient = $this->webexpert_woocommerce_sms_get_recipeint($order);
	    return $this->webexpert_woocommerce_send_sms($message, $recipient);
    }
}
