(function( $ ) {
	'use strict';

	/**
	 * All of the code for your admin-facing JavaScript source
	 * should reside in this file.
	 *
	 * Note: It has been assumed you will write jQuery code here, so the
	 * $ function reference has been prepared for usage within the scope
	 * of this function.
	 *
	 * This enables you to define handlers, for when the DOM is ready:
	 *
	 * $(function() {
	 *
	 * });
	 *
	 * When the window is loaded:
	 *
	 * $( window ).load(function() {
	 *
	 * });
	 *
	 * ...and/or other possibilities.
	 *
	 * Ideally, it is not considered best practise to attach more than a
	 * single DOM-ready or window-load handler for a particular page.
	 * Although scripts in the WordPress core, Plugins and Themes may be
	 * practising this, we should strive to set a better example in our own work.
	 */

	jQuery( document ).ready(function() {
		const $userSelect = $('#webexpert_skroutz_smart_cart_user_id');
		if ($userSelect.length) {
			$userSelect.select2({
				placeholder: ajax_object.search_user,
				allowClear: true,
				minimumInputLength: 2,

				ajax: {
					url: ajax_object.ajax_url,
					dataType: 'json',
					delay: 250,
					method: 'GET',

					data: function (params) {
						return {
							action: 'webexpert_skroutz_smart_cart_user_search',
							q: params.term
						};
					},

					processResults: function (data) {
						return data;
					},

					cache: true
				}
			});
		}

		const $variationSelect = $('#webexpert_skroutz_smart_cart_variation_attributes');
		if ($variationSelect.length)
			$variationSelect.select2({width:'350px'});

		jQuery('#webexpert_skroutz_smart_cart_grab_order').on('click',function(e){
			e.preventDefault();
			var $this=$(this);
			jQuery.ajax({
				type : "post",
				dataType : "json",
				url : ajax_object.ajax_url,
				data : {action: "webexpert_skroutz_smart_cart_grab_order",order_id: jQuery('#webexpert_skroutz_smart_cart_grab_order_id').val()},
				success: function(response) {
					if (response.success) {
						const orderId = response.data.order_id;
						const orderUrl = response.data.order_url;
						const confirmMsg = $this.data('confirm').replace('{id}', orderId);
						let popupMsg   = $this.data('popup').replace('{id}', orderUrl);

						// Confirm open
						if (confirm(confirmMsg)) {
							const win = window.open(orderUrl, "_blank");
							if (!win) {
								alert(popupMsg);
							}
						}
					}else {
						alert($this.data('fail'));
					}
				}
			});
		})

		jQuery('#smart_cart_accept_order').on('click',function(e){
			e.preventDefault();
			var $this=$(this);
			jQuery.ajax({
				type : "post",
				dataType : "json",
				url : ajax_object.ajax_url,
				data : {action: "webexpert_skroutz_smart_cart_accept_order", pickup_location: jQuery('#smart_cart_order_pickup_location').val(), pickup_window: jQuery('#smart_cart_order_pickup_window').val(), order_id:$this.data('order')},
				success: function(response) {
					if (response.success===1) {
						alert("Order accepted.");
						location.reload();
					}else {
						alert(response.errors);
					}
				}
			});
		});

		jQuery('#smart_cart_reject_toggle').on('click',function(e){
			jQuery('#smart_cart_order_reject_container').slideToggle();
		});

		jQuery('#smart_cart_reject_order').on('click',function(e){
			e.preventDefault();
			var $this=$(this);

			jQuery.ajax({
				type : "post",
				dataType : "json",
				url : ajax_object.ajax_url,
				data : {action: "webexpert_skroutz_smart_cart_reject_order", reject_reason: jQuery('#smart_cart_order_reject_reason').val(), reject_reason_other: jQuery('#smart_cart_order_reject_reason_other').val(), order_id:$this.data('order'), line_numbers: jQuery('#smart_cart_order_line_numbers').val()},
				success: function(response) {
					console.log(response);
					if (response.success===1) {
						alert("Order rejected.");
						location.reload();
					}else {
						alert(response.errors);
					}
				}
			});
		});

	});

})( jQuery );
