<?php

/**
 * The admin-specific functionality of the plugin.
 *
 * @link       https://www.webexpert.gr/
 * @since      1.0.0
 *
 * @package    Webexpert_Woocommerce_Skroutz_Smart_Cart
 * @subpackage Webexpert_Woocommerce_Skroutz_Smart_Cart/admin
 */

/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Webexpert_Woocommerce_Skroutz_Smart_Cart
 * @subpackage Webexpert_Woocommerce_Skroutz_Smart_Cart/admin
 * @author     Web Expert <info@webexpert.gr>
 */
class Webexpert_Woocommerce_Skroutz_Smart_Cart_Admin {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of this plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {

		$this->plugin_name = $plugin_name;
		$this->version = $version;

	}

	/**
	 * Register the stylesheets for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Webexpert_Woocommerce_Skroutz_Smart_Cart_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Webexpert_Woocommerce_Skroutz_Smart_Cart_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */
		if( ! wp_style_is( 'select2', 'registered' ) ) {
			wp_register_style( 'select2', WC()->plugin_url() . '/assets/css/select2.css', null, $this->version );
		}
		wp_enqueue_style( 'select2' );
		wp_enqueue_style( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'css/webexpert-woocommerce-skroutz-smart-cart-admin.css', array('select2'), $this->version, 'all' );
	}

	/**
	 * Register the JavaScript for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Webexpert_Woocommerce_Skroutz_Smart_Cart_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Webexpert_Woocommerce_Skroutz_Smart_Cart_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */
		if( ! wp_script_is( 'select2', 'registered' ) ) {
			wp_register_script( 'select2', WC()->plugin_url() . '/assets/js/select2/select2.full.min.js', array( 'jquery' ), $this->version );
		}
		wp_enqueue_script('select2');
		wp_enqueue_script( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'js/webexpert-woocommerce-skroutz-smart-cart-admin.js', array( 'jquery','select2' ), $this->version, false );
		wp_localize_script($this->plugin_name, 'ajax_object', array('ajax_url' => admin_url('admin-ajax.php'),'search_user'=>__('Search user...','webexpert-woocommerce-skroutz-smart-cart')));
	}

    function webexpert_skroutz_smart_cart_user_search() {
        $term = sanitize_text_field($_GET['q'] ?? '');
        $results = [];
        $users = get_users([
                'search'         => '*' . $term . '*',
                'search_columns' => ['user_login', 'user_email', 'display_name'],
                'number'         => 20,
                'fields'         => ['ID', 'display_name']
        ]);
        foreach ($users as $u) {
            $results[] = [
                    'id'   => $u->ID,
                    'text' => $u->display_name . " (ID: {$u->ID})"
            ];
        }
        wp_send_json([
                'results' => $results
        ]);
    }

	function wpse230212_callback_update( $old_value, $new_value ) {
		$license=get_option('webexpert_skroutz_smart_cart_valid_license',false);
		if ($license===false) {
			$url='https://www.webexpert.gr/plugins/updates/?action=get_metadata&slug=webexpert-woocommerce-skroutz-smart-cart&license_key='.get_option('webexpert_skroutz_smart_cart_license_key').'&domain='.get_bloginfo('url');
			$request = wp_remote_get($url);
			$response = wp_remote_retrieve_body( $request );
			$s = json_decode($response);
			if (isset($s->download_url)) {
				update_option('webexpert_skroutz_smart_cart_valid_license',true);
			}else {
				delete_option('webexpert_skroutz_smart_cart_valid_license');
			}
		}
	}

	function webexpert_smart_cart_license_admin_notices() {
		if (empty(get_option('webexpert_skroutz_smart_cart_email')) || empty(get_option('webexpert_skroutz_smart_cart_license_key'))) {
			?>
			<div class="notice notice-error">
				<p><?php _e('Please activate <strong>Web Expert WooCommerce Skroutz Smart Cart</strong> to enable all it\'s features and automatic updates.', 'webexpert-woocommerce-skroutz-smart-cart'); ?></p>
			</div>
			<?php
		}
		if (get_option('webexpert_skroutz_smart_cart_valid_license',false)===false) {
			?>
			<div class="notice notice-error">
				<p><?php _e('The license for <strong>Web Expert WooCommerce Skroutz Smart Cart</strong> is invalid. Please fill in a valid license key.', 'webexpert-woocommerce-skroutz-smart-cart'); ?></p>
			</div>
			<?php
		}
	}

	function woocommerce_shop_order_search_order_key($search_fields) {
		$search_fields[] = '_order_key';
		return $search_fields;
    }

	function add_account_orders_column_rows( $column, $the_order ) {
		if ( ! is_a( $the_order, 'WC_Order' ) ) {
			global $post;
			$the_order = wc_get_order( $post->ID );
		}

		if ( empty( $the_order ) ) {
			return;
		}

		$is_skroutz=null;
		if (strpos($the_order->get_order_key(), 'SC-') !== false) {
			$is_skroutz=1;
		}

        if ( !empty($is_skroutz) && $column == 'order_number' ) {
            echo '<img width=20 src="' . rtrim(plugin_dir_url(__FILE__),'/') . '/img/skroutzsc_orange.png'.'" style="position: absolute;transform: translate(-10px, -10px);">';
            $transform=25;
            if (!empty($the_order->get_meta('_skroutz_express'))) {
                echo '<img width=18 src="' . rtrim(plugin_dir_url(__FILE__),'/') . '/img/express.png'.'" style="position: absolute;transform: translate(-'.$transform.'px, -10px);">';
                $transform+=20;
            }
            if (!empty($the_order->get_meta('_skroutz_fulfilled'))) {
                echo '<img width=18 src="' . rtrim(plugin_dir_url(__FILE__),'/') . '/img/fulfilled.png'.'" style="position: absolute;transform: translate(-'.$transform.'px, -10px);">';
                $transform+=20;
            }
            if (!empty($the_order->get_meta('_skroutz_store_pickup'))) {
                echo '<img width=18 src="' . rtrim(plugin_dir_url(__FILE__),'/') . '/img/pickup.png'.'" style="position: absolute;transform: translate(-'.$transform.'px, -10px);">';
                $transform+=20;
            }
            if (!empty($the_order->get_meta('_skroutz_gift_wrap'))) {
                echo '<img width=18 src="' . rtrim(plugin_dir_url(__FILE__),'/') . '/img/giftbox.png'.'" style="position: absolute;transform: translate(-'.$transform.'px, -10px);">';
            }
        }
    }

    function webexpert_skroutz_order_tracking__notice( $order ){
        $is_skroutz=null;
        if (strpos($order->get_order_key(), 'SC-') !== false) {
            $is_skroutz=1;
        }

        if ( !empty($is_skroutz) ) {
            echo '<img src="' . plugin_dir_url(__FILE__) . '/img/header_image.png'.'">';
            $transform=20;
            if (!empty($order->get_meta('_skroutz_express'))) {
                echo '<img width=20 src="' . rtrim(plugin_dir_url(__FILE__),'/') . '/img/express.png'.'" style="position: absolute;transform: translate(-'.$transform.'px, -10px);">';
                $transform+=25;
            }
            if (!empty($order->get_meta('_skroutz_fulfilled'))) {
                echo '<img width=18 src="' . rtrim(plugin_dir_url(__FILE__),'/') . '/img/fulfilled.png'.'" style="position: absolute;transform: translate(-'.$transform.'px, -10px);">';
                $transform+=25;
            }
            if (!empty($order->get_meta('_skroutz_store_pickup'))) {
                echo '<img width=18 src="' . rtrim(plugin_dir_url(__FILE__),'/') . '/img/pickup.png'.'" style="position: absolute;transform: translate(-'.$transform.'px, -10px);">';
                $transform+=25;
            }
            if (!empty($order->get_meta('_skroutz_gift_wrap'))) {
                echo '<img width=18 src="' . rtrim(plugin_dir_url(__FILE__),'/') . '/img/giftbox.png'.'" style="position: absolute;transform: translate(-'.$transform.'px, -10px);">';
            }
        }
    }

	function webexpert_skroutz_order_tracking__filter() {
		global $typenow;
		if ( 'shop_order' != $typenow ) {
			return;
		}

		$getData = isset($_GET['webexperrt_skroutz_order_tracking__filter']) ? sanitize_text_field( $_GET['webexperrt_skroutz_order_tracking__filter'] ) : null;
		?>

        <select name='webexperrt_skroutz_order_tracking__filter' id='webexperrt_skroutz_order_tracking__filter'>
            <option
				<?php
				if ( !isset( $getData ) && !$getData ) {
					selected( 'no', '' );
				}
				?>
                    value="no"><?php _e( 'All orders', 'webexpert-woocommerce-skroutz-smart-cart' ); ?></option>
            <option <?php
			        if ( isset( $getData ) && $getData ) {
				        selected( 'yes', $getData );
			        }
			        ?>value="yes"><?php _e( __('Skroutz Orders','webexpert-woocommerce-skroutz-smart-cart')); ?></option>
        </select>

		<?php
	}

	function hide_meta_data_from_wc_admin($formatted_meta) {
		foreach ( $formatted_meta as $key => $meta ) {
			if ( 'item_id' === $meta->key ) {
				unset( $formatted_meta[$key] );
			}
		}
		return $formatted_meta;
	}

	function webexpert_skroutz_order_tracking__filter_action( $query ) {
		global $pagenow;
		$postClear = isset($_GET['post_type']) ? sanitize_text_field( $_GET['post_type'] ) : null;
		$getData = isset($_GET['webexperrt_skroutz_order_tracking__filter']) ? sanitize_text_field( $_GET['webexperrt_skroutz_order_tracking__filter'] ) : null;

		$post_type = $postClear ?? '';

		if ( $post_type == 'shop_order' && isset( $getData ) && $getData =='yes' ) {
			$meta_query = (array)$query->get('meta_query');
			$meta_query[] = array(
				'key'     => '_order_key',
				'value'   => 'SC-',
				'compare' => 'LIKE',
			);
			$query->set('meta_query',$meta_query);
		}
	}
}