<?php

namespace CTXFeed\V5\Merchant;

use CTXFeed\V5\Common\Helper;
use function cli\err;

class TemplateConfig {

	private static $brand;
	private static $currency;

	public function __construct( $currency = null, $brand = null ) {
		self::$brand    = ! empty( $brand ) ? $brand : self::default_brand();
		self::$currency = ! empty( $currency ) ? $currency : get_woocommerce_currency();
	}


	/**
	 * Guess Brand name from Site URL
	 *
	 * @return string
	 */
	public static function default_brand() {
		$brand = apply_filters( 'woo_feed_pre_get_default_brand_name', null );
		if ( ! is_null( $brand ) ) {
			return $brand;
		}
		if( ! empty( self::$brand ) ) {
			return self::$brand;
		}
		$brand = '';
		$url   = filter_var( site_url(), FILTER_SANITIZE_URL );
		if ( false !== $url ) {
			$url = wp_parse_url( $url );
			if ( array_key_exists( 'host', $url ) ) {
				if ( strpos( $url['host'], "." ) !== false ) {
					$arr   = explode( '.', $url['host'] );
					$brand = $arr[ count( $arr ) - 2 ];
					$brand = ucfirst( $brand );
				} else {
					$brand = $url['host'];
					$brand = ucfirst( $brand );
				}
			}
		}

		self::$brand = $brand;

		return apply_filters( 'woo_feed_get_default_brand_name', $brand );
	}

	/**
	 * Get Woocommerce Currency
	 *
	 * @return string
	 */
	public static function get_currency() {
		if( ! empty( self::$currency ) ) {
			return self::$currency;
		}
		self::$currency = get_woocommerce_currency();

		return self::$currency;
	}

	public static function get( $merchant = 'custom', $currency = null, $brand = null ) {
		self::$brand    = ! empty( $brand ) ? $brand :  self::default_brand();
		self::$currency = ! empty( $currency ) ? $currency : self::get_currency();

		$config = array(
			'default'                => array(
				'mattributes' => array(
					'id',
					'title',
					'description',
					'link',
					'image_link',
					'price',
					'categories',
					'brand',
				),
				'prefix'      => array( '', '', '', '', '', '', '', '' ),
				'type'        => array(
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
				),
				'attributes'  => array(
					'id',
					'title',
					'description',
					'link',
					'image',
					'price',
					'product_type',
					'',
				),
				'default'     => array( '', '', '', '', '', '', '', self::$brand ),
				'suffix'      => array( '', '', '', '', '', '', '', '' ),
				'output_type' => array( '1', '1', '11', '1', '1', '1', '1', '1' ),
				'limit'       => array( '', '', '', '', '', '', '', '' ),
			),
			'google'                 => array(
				'mattributes' => array(
					'id',
					'title',
					'description',
					'item_group_id',
					'link',
					'product_type',
					'current_category',
					'image',
					'condition',
					'availability',
					'price',
					'sale_price',
					'sku',
					'brand',
					'canonical_link',
					'images_1',
					'images_2',
					'images_3',
					'images_4',
					'images_5'
				),
				'prefix'      => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					''
				),
				'type'        => array(
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute'
				),
				'attributes'  => array(
					'id',
					'title',
					'description',
					'item_group_id',
					'link',
					'product_type',
					'',
					'image',
					'',
					'availability',
					'price',
					'current_price',
					'sku',
					'',
					'canonical_link',
					'image_1',
					'image_2',
					'image_3',
					'image_4',
					'image_5'
				),
				'default'     => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'new',
					'',
					'',
					'',
					'',
					self::$brand,
					'',
					'',
					'',
					'',
					'',
					''
				),
				'suffix'      => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					' ' . self::$currency,
					' ' . self::$currency,
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					''
				),
				'output_type' => array(
					'1',
					'1',
					'11',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'6',
					'6',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1'
				),
				'limit'       => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					''
				),
			),
			'facebook'               => array(
				'mattributes' => array(
					'id',
					'title',
					'description',
					'item_group_id',
					'link',
					'product_type',
					'fb_product_category',
					'image',
					'condition',
					'availability',
					'price',
					'sale_price',
					'brand',
					'images_1',
					'images_2',
					'images_3',
					'images_4',
					'images_5'
				),
				'prefix'      => array( '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '' ),
				'type'        => array(
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute'
				),
				'attributes'  => array(
					'id',
					'title',
					'description',
					'item_group_id',
					'link',
					'product_type',
					'',
					'image',
					'',
					'availability',
					'price',
					'current_price',
					'',
					'image_1',
					'image_2',
					'image_3',
					'image_4',
					'image_5'
				),
				'default'     => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'new',
					'',
					'',
					'',
					self::$brand,
					'',
					'',
					'',
					'',
					''
				),
				'suffix'      => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					' ' . self::$currency,
					' ' . self::$currency,
					'',
					'',
					'',
					'',
					'',
					''
				),
				'output_type' => array(
					'1',
					'1',
					'11',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'6',
					'6',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1'
				),
				'limit'       => array( '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '' ),
			),
			'pinterest_rss'          => array(
				'mattributes' => array( 'title', 'description', 'link', 'image', 'pubDate', 'guid' ),
				'prefix'      => array( '', '', '', '', '', '' ),
				'type'        => array( 'attribute', 'attribute', 'attribute', 'attribute', 'attribute', 'attribute' ),
				'attributes'  => array( 'title', 'description', 'link', 'image', 'date_created', 'link' ),
				'default'     => array( '', '', '', '', '', '' ),
				'suffix'      => array( '', '', '', '', '', '' ),
				'output_type' => array( '1', '11', '1', '1', '1', '1' ),
				'limit'       => array( '', '', '', '', '', '' ),
			),
			'bol'                    => array(
				'mattributes' => array(
					'EAN',
					'Internal Reference',
					'Name',
					'Product Classification',
					'Description',
					'Cover Image URL',
					'Brand',
				),
				'prefix'      => array( '', '', '', '', '', '', '' ),
				'type'        => array(
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
				),
				'attributes'  => array(
					'sku',
					'id',
					'title',
					'product_type',
					'description',
					'image',
					'',
				),
				'default'     => array( '', '', '', '', '', '', self::$brand ),
				'suffix'      => array( '', '', '', '', '', '', '' ),
				'output_type' => array( '1', '1', '1', '1', '1, 2, 11', '1', '' ),
				'limit'       => array( '', '', '', '', '', '', '' ),
			),
			'adform'                 => array(
				'mattributes' => array(
					'product_id',
					'product_name',
					'product_category_id',
					'product_deeplink',
					'product_image',
					'product_price',
				),
				'prefix'      => array( '', '', '', '', '', '' ),
				'type'        => array(
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
				),
				'attributes'  => array( 'id', 'title', 'product_type', 'link', 'image', 'price' ),
				'default'     => array( '', '', '', '', '', '' ),
				'suffix'      => array( '', '', '', '', '', '' ),
				'output_type' => array( '1', '1', '1', '1', '1', '1' ),
				'limit'       => array( '', '', '', '', '', '' ),
			),
			'avantlink'              => array(
				'mattributes' => array(
					'SKU',
					'Brand Name',
					'Product Name',
					'Long Description',
					'Category',
					'Standardized Categorization',
					'Image URL',
					'Buy Link',
					'Retail Price',
					'Sale Price',
					'UPC',
				),
				'prefix'      => array( '', '', '', '', '', '', '', '', '', '', '' ),
				'type'        => array(
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
				),
				'attributes'  => array(
					'sku',
					'',
					'title',
					'description',
					'product_type',
					'',
					'image',
					'link',
					'price',
					'sale_price',
					'',
				),
				'default'     => array(
					'',
					self::$brand,
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'suffix'      => array( '', '', '', '', '', '', '', '', '', '', '' ),
				'output_type' => array( '1', '1', '1', '11', '1', '1', '1', '1', '1', '1', '1' ),
				'limit'       => array( '', '', '', '', '', '', '', '', '', '', '' ),
			),
			'become'                 => array(
				'mattributes' => array(
					'Unique ID',
					'Title',
					'Description',
					'Category',
					'Product URL',
					'Image URL',
					'Condition',
					'Availability',
					'Current Price',
				),
				'prefix'      => array( '', '', '', '', '', '', '', '', '' ),
				'type'        => array(
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
				),
				'attributes'  => array(
					'id',
					'title',
					'description',
					'product_type',
					'link',
					'image',
					'condition',
					'availability',
					'price',
				),
				'default'     => array( '', '', '', '', '', '', '', '', '' ),
				'suffix'      => array( '', '', '', '', '', '', '', '', '' ),
				'output_type' => array( '1', '1', '11', '1', '1', '1', '1', '1', '6' ),
				'limit'       => array( '', '', '', '', '', '', '', '', '' ),
			),
			'bonanza'                => array(
				'mattributes' => array(
					'id',
					'title',
					'description',
					'price',
					'images',
					'category',
					'booth_category',
					'shipping_price',
					'shipping_type',
					'shipping_service',
					'shipping_lbs',
					'shipping_oz',
					'shipping_carrier',
					'shipping_package',
					'sku',
					'worldwide_shipping_price',
					'worldwide_shipping_type',
					'worldwide_shipping_carrier',
					'quantity',
					'trait',
					'force_update',
				),
				'prefix'      => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'type'        => array(
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'pattern',
					'pattern',
					'pattern',
					'pattern',
					'pattern',
					'pattern',
					'pattern',
					'attribute',
					'pattern',
					'pattern',
					'pattern',
					'attribute',
					'pattern',
					'pattern',
				),
				'attributes'  => array(
					'id',
					'title',
					'description',
					'price',
					'image',
					'',
					'product_type',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'sku',
					'',
					'',
					'',
					'quantity',
					'',
					'',
				),
				'default'     => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'suffix'      => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'output_type' => array(
					'1',
					'1',
					'11',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
				),
				'limit'       => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
			),
			'criteo'                 => array(
				'mattributes' => array(
					'ID',
					'title',
					'description',
					'google_product_category',
					'link',
					'image_link',
					'additional_image_link',
					'availability',
					'price',
					'sale_price',
					'gtin',
					'mpn',
					'brand',
					'product_type',
					'product_type_key',
					'number_of_reviews',
					'product_rating',
					'filters',
					'adult',
				),
				'prefix'      => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'type'        => array(
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
				),
				'attributes'  => array(
					'id',
					'title',
					'description',
					'product_type',
					'link',
					'image',
					'images',
					'availability',
					'price',
					'sale_price',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'default'     => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					self::$brand,
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'suffix'      => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'output_type' => array(
					'1',
					'1',
					'11',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
				),
				'limit'       => array(
					'240',
					'150',
					'5000',
					'',
					'1024',
					'2000',
					'2000',
					'25',
					'14',
					'50',
					'50',
					'70',
					'70',
					'500',
					'500',
					'8',
					'8',
					'2000',
					'',
				),
			),
			'crowdfox'               => array(
				'mattributes' => array(
					'sku ',
					'image',
					'name',
					'price',
					'ean',
					'dlv_time',
					'dlv_cost',
					'obl_info',
					'brand',
					'mpn',
					'link',
					'desc',
					'sell_max',
					'shop_cat',
				),
				'prefix'      => array( '', '', '', '', '', '', '', '', '', '', '', '', '', '' ),
				'type'        => array(
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'pattern',
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
				),
				'attributes'  => array(
					'sku',
					'image',
					'title',
					'price',
					'',
					'',
					'',
					'',
					'',
					'',
					'link',
					'description',
					'quantity',
					'product_type',
				),
				'default'     => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					self::$brand,
					'',
					'',
					'',
					'',
					'',
				),
				'suffix'      => array( '', '', '', '', '', '', '', '', '', '', '', '', '', '' ),
				'output_type' => array(
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'11',
					'1',
					'1',
				),
				'limit'       => array( '', '', '', '', '', '', '', '', '', '', '', '', '', '' ),
			),
			'fruugo'                 => array(
				'mattributes' => array(
					'ProductId',
					'SkuId',
					'EAN',
					'Brand',
					'Category',
					'Imageurl1',
					'StockStatus',
					'StockQuantity',
					'Title',
					'Description',
					'NormalPriceWithoutVAT',
					'DiscountPriceWithoutVAT',
					'VatRate',
					'Currency',
					'Country',
				),
				'prefix'      => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'type'        => array(
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
				),
				'attributes'  => array(
					'id',
					'sku',
					'',
					'',
					'product_type',
					'image',
					'availability',
					'quantity',
					'title',
					'description',
					'price',
					'sale_price',
					'',
					'',
					'',
				),
				'default'     => array(
					'',
					'',
					'',
					self::$brand,
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					' ' . self::$currency,
					'',
				),
				'suffix'      => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'output_type' => array(
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'11',
					'1',
					'1',
					'1',
					'1',
					'1',
				),
				'limit'       => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
			),
			'jet'                    => array(
				'mattributes' => array(
					'Merchant SKU ID',
					'Unique ID',
					'Multi-pack Quantity',
					'Product Title',
					'Description',
					'Image',
					'Product Price',
					'Jet Category',
					'Brand',
				),
				'prefix'      => array( '', '', '', '', '', '', '', '', '' ),
				'type'        => array(
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'pattern',
				),
				'attributes'  => array(
					'sku',
					'id',
					'',
					'title',
					'description',
					'image',
					'price',
					'',
					'',
				),
				'default'     => array( '', '', '', '', '', '', '', '', self::$brand ),
				'suffix'      => array( '', '', '', '', '', '', '', '', '' ),
				'output_type' => array( '1', '1', '1', '1', '11', '1', '1', '1', '1' ),
				'limit'       => array( '', '', '', '', '', '', '', '', '' ),
			),
			'kelkoo'                 => array(
				'mattributes' => array(
					'title',
					'product-url',
					'price',
					'merchant-category',
					'ean',
					'delivery-cost',
					'brand',
					'description',
					'image-url',
					'availability',
					'mpn',
				),
				'prefix'      => array( '', '', '', '', '', '', '', '', '', '', '' ),
				'type'        => array(
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
				),
				'attributes'  => array(
					'title',
					'link',
					'price',
					'',
					'',
					'',
					'',
					'description',
					'image',
					'availability',
					'',
				),
				'default'     => array(
					'',
					'',
					'',
					'',
					'',
					'',
					self::$brand,
					'',
					'',
					'',
					'',
				),
				'suffix'      => array( '', '', '', '', '', '', '', '', '', '', '' ),
				'output_type' => array( '1', '1', '1', '1', '1', '1', '1', '11', '1', '1', '1' ),
				'limit'       => array( '', '', '', '', '', '', '', '', '', '', '' ),
			),
			'kieskeurig.nl'          => array(
				'mattributes' => array(
					'id',
					'productgroep',
					'merk',
					'type',
					'toevoeging-type',
					'extra-productbeschrijving',
					'partnumber',
					'ean-code',
					'prijs',
					'verzendkosten',
					'afhaalkosten',
					'levertijd',
					'deeplink',
					'imagelink',
					'voorraad',
				),
				'prefix'      => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'type'        => array(
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
				),
				'attributes'  => array(
					'id',
					'product_type',
					'title',
					'type',
					'',
					'description',
					'',
					'',
					'price',
					'',
					'',
					'',
					'link',
					'image',
					'quantity',
				),
				'default'     => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'suffix'      => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'output_type' => array(
					'1',
					'1',
					'1',
					'1',
					'1',
					'11',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
				),
				'limit'       => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
			),
			'kijiji.ca'              => array(
				'mattributes' => array(
					'id',
					'title',
					'description',
					'link',
					'image_link',
					'price',
					'categories',
					'brand',
				),
				'prefix'      => array( '', '', '', '', '', '', '', '' ),
				'type'        => array(
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
				),
				'attributes'  => array(
					'id',
					'title',
					'description',
					'link',
					'image',
					'price',
					'product_type',
					'',
				),
				'default'     => array( '', '', '', '', '', '', '', self::$brand ),
				'suffix'      => array( '', '', '', '', '', '', '', '' ),
				'output_type' => array( '1', '1', '11', '1', '1', '1', '1', '1' ),
				'limit'       => array( '', '', '', '', '', '', '', '' ),
			),
			'leguide'                => array(
				'mattributes' => array(
					'category',
					'unique_id',
					'title',
					'description',
					'price',
					'product_URL',
					'landing_URL',
					'image_URL',
					'EAN',
					'delivery_charge',
					'delivery_time',
					'availability',
					'guarantee',
				),
				'prefix'      => array( '', '', '', '', '', '', '', '', '', '', '', '', '' ),
				'type'        => array(
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'pattern',
					'pattern',
					'pattern',
				),
				'attributes'  => array(
					'product_type',
					'id',
					'title',
					'description',
					'price',
					'link',
					'',
					'image',
					'sku',
					'',
					'',
					'',
					'',
				),
				'default'     => array( '', '', '', '', '', '', '', '', '', '', '', '', '' ),
				'suffix'      => array( '', '', '', '', '', '', '', '', '', '', '', '', '' ),
				'output_type' => array(
					'1',
					'1',
					'1',
					'11',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
				),
				'limit'       => array( '', '', '', '', '', '', '', '', '', '', '', '', '' ),
			),
			'modina.de'              => array(
				'mattributes' => array(
					'id',
					'brand',
					'title',
					'description',
					'productLink',
					'imageLink',
					'imageLinkAdditional',
					'price',
					'priceOld',
					'shippingCost',
					'shippingDuration',
					'availability',
					'gtin',
					'mpn',
					'category',
					'subcategory',
					'color',
					'gender',
					'material',
					'pattern',
					'size',
				),
				'prefix'      => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'type'        => array(
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
				),
				'attributes'  => array(
					'id',
					'',
					'title',
					'description',
					'link',
					'image',
					'images',
					'price',
					'',
					'',
					'',
					'availability',
					'',
					'',
					'product_type',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'default'     => array(
					'',
					self::$brand,
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'suffix'      => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'output_type' => array(
					'1',
					'1',
					'1',
					'11',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
				),
				'limit'       => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
			),
			'myshopping.com.au'      => array(
				'mattributes' => array(
					'Code',
					'Id',
					'Name',
					'Description',
					'Category',
					'price',
					'Product_URL',
					'Image_URL',
					'Brand',
					'InStock',
					'MPN',
				),
				'prefix'      => array( '', '', '', '', '', '', '', '', '', '', '' ),
				'type'        => array(
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'pattern',
					'attribute',
				),
				'attributes'  => array(
					'',
					'id',
					'title',
					'description',
					'product_type',
					'price',
					'link',
					'image',
					'',
					'',
					'sku',
				),
				'default'     => array( '', '', '', '', '', '', '', '', self::$brand, 'Y', '' ),
				'suffix'      => array( '', '', '', '', '', '', '', '', '', '', '' ),
				'output_type' => array( '1', '1', '1', '11', '1', '1', '1', '1', '1', '1', '1' ),
				'limit'       => array( '', '', '', '', '', '', '', '', '', '', '' ),
			),
			'nextag'                 => array(
				'mattributes' => array(
					'Manufacturer',
					'Product Name',
					'Product Description',
					'Price',
					'Click-Out URL',
					'Category',
					'Image URL',
					'Stock Status',
					'Condition',
				),
				'prefix'      => array( '', '', '', '$', '', '', '', '', '' ),
				'type'        => array(
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
				),
				'attributes'  => array(
					'',
					'title',
					'description',
					'price',
					'link',
					'product_type',
					'image',
					'availability',
					'condition',
				),
				'default'     => array( self::$brand, '', '', '', '', '', '', '', '' ),
				'suffix'      => array( '', '', '', '', '', '', '', '', '' ),
				'output_type' => array( '1', '1', '11', '1', '1', '1', '1', '1', '1' ),
				'limit'       => array( '', '', '', '', '', '', '', '', '' ),
			),
			'polyvore'               => array(
				'mattributes' => array(
					'title',
					'brand',
					'url',
					'imgurl',
					'price',
					'currency',
					'description',
					'subject',
				),
				'prefix'      => array( '', '', '', '', '', '', '', '' ),
				'type'        => array(
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'pattern',
				),
				'attributes'  => array(
					'title',
					'',
					'link',
					'image',
					'price',
					'',
					'description',
					'',
				),
				'default'     => array(
					'',
					self::$brand,
					'',
					'',
					'',
					' ' . self::$currency,
					'',
					'',
				),
				'suffix'      => array( '', '', '', '', '', '', '', '' ),
				'output_type' => array( '1', '1', '1', '1', '1', '1', '11', '1' ),
				'limit'       => array( '', '', '', '', '', '', '', '' ),
			),
			'pricegrabber'           => array(
				'mattributes' => array(
					'Retsku',
					'Product Title',
					'Detailed Description',
					'Categorization',
					'Product URL',
					'Primary Image URL',
					'Selling Price',
					'Regular Price',
					'Condition',
					'Availability',
					'Manufacturer Name',
					'GTIN',
				),
				'prefix'      => array( '', '', '', '', '', '', '', '', '', '', '', '' ),
				'type'        => array(
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
				),
				'attributes'  => array(
					'sku',
					'title',
					'description',
					'product_type',
					'link',
					'image',
					'sale_price',
					'price',
					'condition',
					'availability',
					'',
					'',
				),
				'default'     => array( '', '', '', '', '', '', '', '', '', '', '', '' ),
				'suffix'      => array( '', '', '', '', '', '', '', '', '', '', '', '' ),
				'output_type' => array(
					'1',
					'1',
					'11',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
				),
				'limit'       => array( '', '', '', '', '', '', '', '', '', '', '', '' ),
			),
			'pricerunner'            => array(
				'mattributes' => array(
					'Category',
					'SKU',
					'Price',
					'Product URL',
					'Product name',
					'Manufacturer SKU',
					'Manufacturer',
					'EAN',
					'Description',
					'Graphic URL',
					'In Stock',
					'Stock Level',
					'Shipping Cost',
					'Delivery time'
				),
				'prefix'      => array( '', '', '', '', '', '', '', '', '', '', '', '', '', '' ),
				'type'        => array(
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'pattern'
				),
				'attributes'  => array(
					'product_type',
					'id',
					'price',
					'link',
					'title',
					'sku',
					'',
					'sku',
					'description',
					'image',
					'availability',
					'quantity',
					'',
					''
				),
				'default'     => array( '', '', '', '', '', '', self::$brand, '', '', '', '', '', '10.00', '5-7 days' ),
				'suffix'      => array( '', '', '', '', '', '', '', '', '', '', '', '', '', '' ),
				'output_type' => array( '1', '1', '1', '1', '1', '1', '1', '1', '11', '1', '1', '1', '1', '1' ),
				'limit'       => array( '', '', '', '', '', '', '', '', '', '', '', '', '', '' ),
			),
			'prisjakt'               => array(
				'mattributes' => array(
					'Produktnamn',
					'Art.nr.',
					'Kategori',
					'Pris inkl.moms',
					'Produkt-URL',
					'Tillverkare',
					'Tillverkar-SKU',
					'Frakt',
					'Bild-URL',
					'Lagerstatus',
				),
				'prefix'      => array( '', '', '', '', '', '', '', '', '', '' ),
				'type'        => array(
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'pattern',
					'attribute',
					'attribute',
				),
				'attributes'  => array(
					'title',
					'id',
					'product_type',
					'price',
					'link',
					'',
					'sku',
					'',
					'image',
					'condition',
				),
				'default'     => array( '', '', '', '', '', '', '', '', 'mens, womens', '' ),
				'suffix'      => array( '', '', '', '', '', '', '', '', '', '' ),
				'output_type' => array( '1', '1', '1', '1', '1', '1', '1', '1', '1', '1' ),
				'limit'       => array( '', '', '', '', '', '', '', '', '', '' ),
			),
			'real'                   => array(
				'mattributes' => array(
					'ean',
					'category',
					'title',
					'description',
					'picture',
					'manufacturer',
				),
				'prefix'      => array( '', '', '', '', '', '' ),
				'type'        => array(
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
				),
				'attributes'  => array(
					'sku',
					'product_type',
					'title',
					'description',
					'image',
					'',
				),
				'default'     => array( '', '', '', '', '', self::$brand ),
				'suffix'      => array( '', '', '', '', '', '' ),
				'output_type' => array( '1', '1', '1', '11', '1', '1' ),
				'limit'       => array( '', '', '', '', '', '' ),
			),
			'shareasale'             => array(
				'mattributes' => array(
					'ProductID',
					'Name',
					'MerchantID',
					'Merchant',
					'Link',
					'Thumbnail',
					'BigImage',
					'Price',
					'RetailPrice',
					'Category',
					'Subcategory',
					'Description',
				),
				'prefix'      => array( '', '', '', '', '', '', '', '', '', '', '', '' ),
				'type'        => array(
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
				),
				'attributes'  => array(
					'id',
					'title',
					'',
					'',
					'link',
					'image',
					'feature_image',
					'sale_price',
					'price',
					'product_type',
					'',
					'description',
				),
				'default'     => array( '', '', '', '', '', '', '', '', '', '', '', '' ),
				'suffix'      => array( '', '', '', '', '', '', '', '', '', '', '', '' ),
				'output_type' => array(
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'6',
					'6',
					'1',
					'1',
					'11',
				),
				'limit'       => array(
					'8',
					'255',
					'8',
					'255',
					'255',
					'255',
					'255',
					'',
					'',
					'50',
					'50',
					'',
				),
			),
			'shopbot'                => array(
				'mattributes' => array(
					'ID',
					'Product Name',
					'URL',
					'Category',
					'Photo URL',
					'Price',
					'Original Price',
					'Description',
					'MPN',
					'Brand',
					'Shipment Cost',
					'Stock',
					'Promotional Phrase',
					'Model',
					'Color',
					'Product Type',
				),
				'prefix'      => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'type'        => array(
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
				),
				'attributes'  => array(
					'id',
					'title',
					'link',
					'product_type',
					'image',
					'sale_price',
					'price',
					'description',
					'sku',
					'',
					'',
					'quantity',
					'',
					'',
					'',
					'',
				),
				'default'     => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'mens, womens',
					self::$brand,
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'suffix'      => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'output_type' => array(
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'11',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
				),
				'limit'       => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
			),
			'shopmania'              => array(
				'mattributes' => array(
					'Category',
					'Manufacturer',
					'Model',
					'MPC',
					'Name',
					'Description',
					'URL',
					'Image',
					'Price',
					'Currency',
					'Shipping',
					'Availability',
					'GTIN',
				),
				'prefix'      => array( '', '', '', '', '', '', '', '', '', '', '', '', '' ),
				'type'        => array(
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
				),
				'attributes'  => array(
					'product_type',
					'',
					'',
					'',
					'title',
					'description',
					'link',
					'image',
					'price',
					'',
					'',
					'availability',
					'',
				),
				'default'     => array( '', self::$brand, '', '', '', '', '', '', '', '', '', '', '' ),
				'suffix'      => array( '', '', '', '', '', '', '', '', '', '', '', '', '' ),
				'output_type' => array(
					'1',
					'1',
					'1',
					'1',
					'1',
					'11',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
				),
				'limit'       => array( '', '', '', '', '', '', '', '', '', '', '', '', '' ),
			),
			'shopping'               => array(
				'mattributes' => array(
					'Unique Merchant SKU',
					'Product Name',
					'Product URL',
					'Image URL',
					'Current Price',
					'Stock Availability',
					'Condition',
					'MPN',
					'UPC',
				),
				'prefix'      => array( '', '', '', '', '', '', '', '', '' ),
				'type'        => array(
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
				),
				'attributes'  => array(
					'sku',
					'title',
					'link',
					'image',
					'price',
					'availability',
					'condition',
					'',
					'',
				),
				'default'     => array( '', '', '', '', '', '', '', '', '' ),
				'suffix'      => array( '', '', '', '', '', '', '', '', '' ),
				'output_type' => array( '1', '1', '1', '1', '1', '1', '1', '1', '1' ),
				'limit'       => array( '', '', '', '', '', '', '', '', '' ),
			),
			'spartoo.fi'             => array(
				'mattributes' => array(
					'SKU',
					'Parent / Child',
					'Parent SKU',
					'Product name',
					'Manufacturer name',
					'Gender',
					'Product_description',
					'Product price',
					'Discount price',
					'Quantity',
					'Category',
					'Products selection',
					'Photo 1',
					'Photo 2',
					'Photo 3',
					'Photo 4',
					'Photo 5',
					'Photo 6',
					'Photo 7',
					'Photo 8',
					'Color id',
					'Color name',
					'Size name',
					'ean',
				),
				'prefix'      => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'type'        => array(
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
				),
				'attributes'  => array(
					'sku',
					'type',
					'parent_sku',
					'title',
					'',
					'',
					'description',
					'price',
					'sale_price',
					'quantity',
					'product_type',
					'',
					'image_1',
					'image_2',
					'image_3',
					'image_4',
					'image_5',
					'image_6',
					'image_7',
					'image_8',
					'',
					'',
					'',
					'',
				),
				'default'     => array(
					'',
					'',
					'',
					'',
					self::$brand,
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'suffix'      => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'output_type' => array(
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'11',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
				),
				'limit'       => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
			),
			'trovaprezzi'            => array(
				'mattributes' => array(
					'Code',
					'Name',
					'Description',
					'Link',
					'Price',
					'Categories',
					'Image',
					'Stock',
					'Availability',
					'ShippingCost',
					'SKU',
					'Brand',
				),
				'prefix'      => array( '', '', '', '', '', '', '', '', '', '', '', '' ),
				'type'        => array(
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'pattern',
				),
				'attributes'  => array(
					'id',
					'title',
					'short_description',
					'link',
					'current_price',
					'product_type',
					'image',
					'wf_cattr__stock',
					'availability',
					'',
					'sku',
					'',
				),
				'default'     => array( '', '', '', '', '', '', '', '', '', '0', '', self::$brand ),
				'suffix'      => array( '', '', '', '', '', '', '', '', '', '', '', '' ),
				'output_type' => array(
					'1',
					'1',
					'2, 11',
					'1',
					'6',
					'1',
					'1',
					'5',
					'1',
					'6',
					'1',
					'1',
				),
				'limit'       => array( '', '', '', '', '', '', '', '', '', '', '', '' ),
			),
			'twenga'                 => array(
				'mattributes' => array(
					'merchant_ref',
					'merchant_id',
					'upc_ean',
					'manufacturer_id',
					'product_url',
					'image_url',
					'price',
					'regular_price',
					'shipping_cost',
					'designation',
					'description',
					'category',
					'brand',
					'in_stock',
					'availability',
					'stock_detail',
					'unit_price',
					'merchant_margin',
					'ecotax',
					'item_display',
					'condition',
					'merchant_ref',
				),
				'prefix'      => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'type'        => array(
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'pattern',
					'pattern',
					'pattern',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'pattern',
					'pattern',
					'pattern',
					'pattern',
					'pattern',
					'pattern',
					'attribute',
				),
				'attributes'  => array(
					'sku',
					'id',
					'',
					'sku',
					'link',
					'image',
					'sale_price',
					'price',
					'',
					'',
					'description',
					'product_type',
					'',
					'availability',
					'quantity',
					'',
					'',
					'',
					'',
					'',
					'',
					'sku',
				),
				'default'     => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					self::$brand,
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'suffix'      => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'output_type' => array(
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'11',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
				),
				'limit'       => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
			),
			'vertaa.fi'              => array(
				'mattributes' => array(
					'Product category',
					'Product name',
					'Product brand',
					'Product price',
					'Product URL',
					'Delivery time',
					'Shipping method',
					'Delivery price',
					'Service country code',
				),
				'prefix'      => array( '', '', '', '', '', '', '', '', '' ),
				'type'        => array(
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
				),
				'attributes'  => array(
					'product_type',
					'title',
					'',
					'price',
					'link',
					'',
					'',
					'',
					'',
				),
				'default'     => array( '', '', self::$brand, '', '', '', '', '', '' ),
				'suffix'      => array( '', '', '', '', '', '', '', '', '' ),
				'output_type' => array( '1', '1', '1', '1', '1', '1', '1', '1', '1' ),
				'limit'       => array( '', '', '', '', '', '', '', '', '' ),
			),
			'walmart'                => array(
				'mattributes' => array(
					'Product Name',
					'SKU',
					'Product Tax Code',
					'Product ID Type',
					'Product ID',
					'Product Identifiers',
					'Description',
					'Brand',
					'Price',
					'Shipping Weight',
				),
				'prefix'      => array( '', '', '', '', '', '', '', '', '', '' ),
				'type'        => array(
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'attribute',
				),
				'attributes'  => array(
					'title',
					'sku',
					'',
					'',
					'id',
					'',
					'description',
					'',
					'price',
					'',
				),
				'default'     => array( '', '', '', '', '', '', '', self::$brand, '', '' ),
				'suffix'      => array( '', '', '', '', '', '', '', '', '', '' ),
				'output_type' => array( '1', '1', '1', '1', '1', '1', '11', '1', '1', '1' ),
				'limit'       => array( '', '', '', '', '', '', '', '', '', '' ),
			),
			'wish'                   => array(
				'mattributes' => array(
					'Main Image URL',
					'Price',
					'Product Name',
					'Quantity',
					'Shipping',
					'Tags',
					'Parent Unique Id',
					'Unique ID/SKU',
					'Description',
				),
				'prefix'      => array( '', '', '', '', '', '', '', '', '' ),
				'type'        => array(
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
				),
				'attributes'  => array(
					'image',
					'price',
					'title',
					'quantity',
					'',
					'tags',
					'item_group_id',
					'id',
					'description',
				),
				'default'     => array( '', '', '', '', '', '', '', '', '' ),
				'suffix'      => array( '', '', '', '', '', '', '', '', '' ),
				'output_type' => array( '1', '1', '1', '1', '1', '1', '1', '1', '11' ),
				'limit'       => array( '', '', '', '', '', '', '', '', '' ),
			),
			'yahoo_nfa'              => array(
				'mattributes' => array(
					'id',
					'title',
					'description',
					'image_link',
					'link',
					'availability',
					'condition',
					'price',
					'gtin',
				),
				'prefix'      => array( '', '', '', '', '', '', '', '', '' ),
				'type'        => array(
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
				),
				'attributes'  => array(
					'id',
					'title',
					'description',
					'image',
					'link',
					'availability',
					'condition',
					'price',
					'',
				),
				'default'     => array( '', '', '', '', '', '', '', '', '' ),
				'suffix'      => array( '', '', '', '', '', '', '', '', '' ),
				'output_type' => array( '1', '1', '11', '1', '1', '1', '1', '1', '1' ),
				'limit'       => array( '', '', '', '', '', '', '', '', '' ),
			),
			'zap.co.il'              => array(
				'mattributes' => array(
					'PRODUCT_URL',
					'PRODUCT_NAME',
					'DETAILS',
					'PRODUCTCODE',
					'CURRENCY',
					'PRICE',
					'SHIPMENT_COST',
					'DELIVERY_TIME',
					'IMAGE',
				),
				'prefix'      => array( '', '', '', '', '', '', '', '', '' ),
				'type'        => array(
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
				),
				'attributes'  => array(
					'link',
					'title',
					'description',
					'id',
					'',
					'price',
					'',
					'',
					'image',
				),
				'default'     => array( '', '', '', '', '', '', '', '', '' ),
				'suffix'      => array( '', '', '', '', '', '', '', '', '' ),
				'output_type' => array( '1', '1', '11', '1', '1', '1', '1', '1', '1' ),
				'limit'       => array( '', '', '', '', '', '', '', '', '' ),
			),
			'adwords'                => array(
				'mattributes' => array(
					'ID',
					'ID2',
					'Item title',
					'Final URL',
					'Image URL',
					'Item subtitle',
					'Item description',
					'Item category',
					'Price',
					'Sale price',
					'Contextual keywords',
					'Item address'
				),
				'prefix'      => array( '', '', '', '', '', '', '', '', '', '', '', '' ),
				'type'        => array(
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'pattern'
				),
				'attributes'  => array(
					'id',
					'id',
					'title',
					'link',
					'image',
					'short_description',
					'description',
					'product_type',
					'price',
					'sale_price',
					'',
					''
				),
				'default'     => array( '', '', '', '', '', '', '', '', '', '', '', '' ),
				'suffix'      => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					' ' . self::$currency,
					' ' . self::$currency,
					'',
					''
				),
				'output_type' => array( '1', '1', '1', '1', '1', '1', '11', '1', '6', '6', '1', '1' ),
				'limit'       => array( '', '', '', '', '', '', '', '', '', '', '', '' ),
			),
			'adwords_local_product'  => array(
				'mattributes' => array(
					'Rank',
					'Product Item Id',
					'Title',
					'Description',
					'Item URL',
					'Image URL',
					'Price',
					'Store code'
				),
				'prefix'      => array( '', '', '', '', '', '', '', '' ),
				'type'        => array(
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern'
				),
				'attributes'  => array( 'id', 'id', 'title', 'description', 'link', 'image', 'current_price', '' ),
				'default'     => array( '', '', '', '', '', '', '', '' ),
				'suffix'      => array( '', '', '', '', '', '', ' ' . self::$currency, '' ),
				'output_type' => array( '1', '1', '1', '11', '1', '1', '6', '1' ),
				'limit'       => array( '', '', '', '', '', '', '', '' ),
			),
			'bing'                   => array(
				'mattributes' => array(
					'id',
					'title',
					'link',
					'price',
					'sale_price',
					'description',
					'image_link',
					'mpn',
					'brand',
					'product_type',
					'availability',
					'item_group_id',
					'shipping'
				),
				'prefix'      => array( '', '', '', '', '', '', '', '', '', '', '', '', '' ),
				'type'        => array(
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'attribute'
				),
				'attributes'  => array(
					'id',
					'title',
					'link',
					'price',
					'current_price',
					'description',
					'image',
					'sku',
					'',
					'product_type',
					'availability',
					'item_group_id',
					'shipping'
				),
				'default'     => array( '', '', '', '', '', '', '', '', self::$brand, '', '', '', '' ),
				'suffix'      => array(
					'',
					'',
					'',
					' ' . self::$currency,
					' ' . self::$currency,
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					''
				),
				'output_type' => array( '1', '1', '1', '6', '6', '11', '1', '1', '1', '1', '1', '1', '1' ),
				'limit'       => array( '', '', '', '', '', '', '', '', '', '', '', '', '' ),
			),
			'bing_local_inventory'   => array(
				'mattributes' => array(
					'store_code',
					'itemid',
					'quantity',
					'weeks_of_supply',
					'pick_up_method',
					'pick_up_sla'
				),
				'prefix'      => array( '', '', '', '', '', '' ),
				'type'        => array( 'pattern', 'attribute', 'attribute', 'pattern', 'pattern', 'pattern' ),
				'attributes'  => array( '', 'id', 'quantity', '', '', '' ),
				'default'     => array( '', '', '', '', '', '' ),
				'suffix'      => array( '', '', '', '', '', '' ),
				'output_type' => array( '1', '1', '1', '1', '1', '1' ),
				'limit'       => array( '', '', '', '', '', '' ),
			),
			'google_local_inventory' => array(
				'mattributes' => array(
					'store_code',
					'id',
					'quantity',
					'price',
					'sale_price',
					'sale_price_effective_date',
					'availability',
					'pickup_method',
					'pickup_sla'
				),
				'prefix'      => array( '', '', '', '', '', '', '', '', '' ),
				'type'        => array(
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'pattern'
				),
				'attributes'  => array(
					'',
					'id',
					'quantity',
					'price',
					'sale_price',
					'sale_price_effective_date',
					'availability',
					'',
					''
				),
				'default'     => array( '', '', '', '', '', '', '', '', '' ),
				'suffix'      => array( '', '', '', ' ' . self::$currency, ' ' . self::$currency, '', '', '', '' ),
				'output_type' => array( '1', '1', '1', '6', '6', '1', '1', '1', '1' ),
				'limit'       => array( '', '', '', '', '', '', '', '', '' ),
			),
			'google_local'           => array(
				'mattributes' => array(
					'store_code',
					'id',
					'title',
					'description',
					'image',
					'upc',
					'brand',
					'condition',
					'price',
					'sale_price',
					'sale_price_effective_date',
					'energy_efficiency_class',
					'min_energy_efficiency_class',
					'max_energy_efficiency_class'
				),
				'prefix'      => array( '', '', '', '', '', '', '', '', '', '', '', '', '', '' ),
				'type'        => array(
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'pattern',
					'pattern'
				),
				'attributes'  => array(
					'',
					'id',
					'title',
					'description',
					'image',
					'sku',
					'',
					'',
					'price',
					'sale_price',
					'sale_price_effective_date',
					'',
					'',
					''
				),
				'default'     => array( '', '', '', '', '', '', self::$brand, 'new', '', '', '', '', '', '' ),
				'suffix'      => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					' ' . self::$currency,
					' ' . self::$currency,
					'',
					'',
					'',
					''
				),
				'output_type' => array( '1', '1', '1', '11', '1', '1', '1', '1', '6', '6', '1', '1', '1', '1' ),
				'limit'       => array( '', '', '', '', '', '', '', '', '', '', '', '', '', '' ),
			),
			'google_promotions'      => array(
				'mattributes' => array(
					'promotion_id',
					'product_applicability',
					'offer_type',
					'long_title',
					'promotion_effective_dates',
					'redemption_channel',
					'promotion_destination',
					'money_off_amount'
				),
				'prefix'      => array( '', '', '', '', '', '', '', '' ),
				'type'        => array(
					'pattern',
					'pattern',
					'pattern',
					'pattern',
					'pattern',
					'pattern',
					'pattern',
					'pattern'
				),
				'attributes'  => array( '', '', '', '', '', '', '', '' ),
				'default'     => array( '', '', '', '', '', '', '', '' ),
				'suffix'      => array( '', '', '', '', '', '', '', '' ),
				'output_type' => array( '1', '1', '1', '1', '1', '1', '1', '1' ),
				'limit'       => array( '', '', '', '', '', '', '', '' ),
			),
			'google_dynamic_ads'     => array(
				'mattributes' => array( 'Page URL', 'Custom Label' ),
				'prefix'      => array( '', '' ),
				'type'        => array( 'attribute', 'pattern' ),
				'attributes'  => array( 'link', '' ),
				'default'     => array( '', '' ),
				'suffix'      => array( '', '' ),
				'output_type' => array( '1', '1' ),
				'limit'       => array( '', '' ),
			),
			'snapchat'               => array(
				'mattributes' => array(
					'id',
					'title',
					'description',
					'item_group_id',
					'link',
					'product_type',
					'google_product_category',
					'image',
					'condition',
					'availability',
					'price',
					'sale_price',
					'sku',
					'brand',
					'canonical_link'
				),
				'prefix'      => array( '', '', '', '', '', '', '', '', '', '', '', '', '', '', '' ),
				'type'        => array(
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'attribute'
				),
				'attributes'  => array(
					'id',
					'title',
					'description',
					'item_group_id',
					'link',
					'product_type',
					'',
					'image',
					'condition',
					'availability',
					'price',
					'current_price',
					'sku',
					'',
					'canonical_link'
				),
				'default'     => array( '', '', '', '', '', '', '', '', '', '', '', '', '', self::$brand, '' ),
				'suffix'      => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					' ' . self::$currency,
					' ' . self::$currency,
					'',
					'',
					''
				),
				'output_type' => array( '1', '1', '11', '1', '1', '1', '1', '1', '1', '1', '6', '6', '1', '1', '1' ),
				'limit'       => array( '', '', '', '', '', '', '', '', '', '', '', '', '', '', '' ),
			),
			'idealo'                 => array(
				'mattributes' => array(
					'sku',
					'title',
					'description',
					'price',
					'imageUrls',
					'deliveryTime',
					'categoryPath',
					'url',
					'brand',
					'checkout',
					'eans',
					'fulfillmentType',
					'checkoutLimitPerPeriod',
					'size',
					'colour'
				),
				'prefix'      => array( '', '', '', '', '', '', '', '', '', '', '', '', '', '', '' ),
				'type'        => array(
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'pattern',
					'pattern',
					'pattern',
					'pattern',
					'pattern',
					'attribute',
					'attribute'
				),
				'attributes'  => array(
					'sku',
					'title',
					'description',
					'current_price',
					'images',
					'',
					'product_type',
					'link',
					'',
					'',
					'',
					'',
					'',
					'wf_attr_pa_size',
					'wf_attr_pa_color'
				),
				'default'     => array( '', '', '', '', '', '1-3 working days', '', '', self::$brand, '', '', '', '', '', '' ),
				'suffix'      => array( '', '', '', ' USD', '', '', '', '', '', '', '', '', '', '', '' ),
				'output_type' => array( '1', '1', '11', '6', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1' ),
				'limit'       => array( '', '', '', '', '', '', '', '', '', '', '', '', '', '', '' ),
			),
			'pricespy'               => array(
				'mattributes' => array(
					'Product-name',
					'Your-item-number',
					'category',
					'price-including-gst',
					'Product-URL',
					'manufacturer',
					'manufacturer-SKU',
					'shipping',
					'image-URL',
					'stock status',
				),
				'prefix'      => array( '', '', '', '', '', '', '', '', '', '' ),
				'type'        => array(
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'pattern',
					'attribute',
					'attribute',
				),
				'attributes'  => array(
					'title',
					'id',
					'product_type',
					'price',
					'link',
					'',
					'sku',
					'',
					'image',
					'condition',
				),
				'default'     => array( '', '', '', '', '', self::$brand, '', '', 'mens, womens', '' ),
				'suffix'      => array( '', '', '', '', '', '', '', '', '', '' ),
				'output_type' => array( '1', '1', '1', '1', '1', '1', '1', '1', '1', '1' ),
				'limit'       => array( '', '', '', '', '', '', '', '', '', '' ),
			),
			'yandex_csv'             => array(
				'mattributes' => array(
					'id',
					'available',
					'price',
					'currencyId',
					'category',
					'picture',
					'name',
					'description',
				),
				'prefix'      => array( '', '', '', '', '', '', '', '' ),
				'type'        => array(
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
				),
				'attributes'  => array(
					'id',
					'availability',
					'price',
					'',
					'product_type',
					'image',
					'title',
					'description',
				),
				'default'     => array( '', '', '', 'RUR', '', '', '', '' ),
				'suffix'      => array( '', '', '', '', '', '', '', '' ),
				'output_type' => array( '1', '1', '1', '1', '1', '1', '1', '11' ),
				'limit'       => array( '', '', '', '', '', '', '', '' ),
			),
			'fyndiq.se'              => array(
				'mattributes' => array(
					'product-id',
					'product-title',
					'product-description',
					'product-market',
					'product-currency',
					'product-price',
					'product-oldprice',
					'product-var-percent',
					'product-image-1-url',
					'product-image-1-identifier',
					'article-sku',
					'article-quantity',
					'article-name',
				),
				'prefix'      => array( '', '', '', '', '', '', '', '', '', '', '', '', '' ),
				'type'        => array(
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
				),
				'attributes'  => array(
					'id',
					'title',
					'description',
					'',
					'',
					'price',
					'',
					'',
					'image',
					'',
					'sku',
					'quantity',
					'',
				),
				'default'     => array(
					'',
					'',
					'',
					'',
					' ' . self::$currency,
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'suffix'      => array( '', '', '', '', '', '', '', '', '', '', '', '', '' ),
				'output_type' => array(
					'1',
					'1',
					'11',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
				),
				'limit'       => array( '', '', '', '', '', '', '', '', '', '', '', '', '' ),
			),
			'miinto.de'              => array(
				'mattributes' => array(
					'title',
					'description',
					'gtin',
					'item_group_id',
					'image_link',
					'product_type',
					'availability',
					'color',
					'season_tag',
					'brand',
					'material',
					'washing',
					'style_id',
					'retail_price_PLN',
					'retail_price_DKK',
					'retail_price_EUR'
				),
				'prefix'      => array( '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '' ),
				'type'        => array(
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'pattern',
					'pattern',
					'pattern',
					'pattern',
					'attribute',
					'attribute',
					'attribute'
				),
				'attributes'  => array(
					'title',
					'description',
					'id',
					'item_group_id',
					'image',
					'product_type',
					'availability',
					'wf_attr_pa_color',
					'',
					'',
					'',
					'',
					'',
					'price',
					'price',
					'price'
				),
				'default'     => array( '', '', '', '', '', '', '', '', '', self::$brand, '', '', '', '', '', '' ),
				'suffix'      => array( '', '', '', '', '', '', '', '', '', '', '', '', '', ' USD', ' USD', ' USD' ),
				'output_type' => array(
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'6',
					'6',
					'6'
				),
				'limit'       => array( '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '' ),
			),
			'miinto.nl'              => array(
				'mattributes' => array(
					'gtin',
					'item_group_id',
					'brand',
					'title',
					'product_type',
					'gender',
					'color',
					'size',
					'image_link',
					'stock_level',
					'season_tag',
					'description',
					'material',
					'washing',
					'retail_price_currencyCode',
				),
				'prefix'      => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'type'        => array(
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
				),
				'attributes'  => array(
					'',
					'item_group_id',
					'',
					'title',
					'product_type',
					'',
					'',
					'',
					'image',
					'quantity',
					'',
					'description',
					'',
					'',
					'',
				),
				'default'     => array(
					'',
					'',
					self::$brand,
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'suffix'      => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'output_type' => array(
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'11',
					'1',
					'1',
					'1',
				),
				'limit'       => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
			),
			'skroutz'                => array(
				'mattributes' => array(
					'id',
					'name',
					'description',
					'link',
					'image',
					'category',
					'price_with_vat',
					'mpn',
					'manufacturer',
					'availability',
				),
				'prefix'      => array( '', '', '', '', '', '', '', '', '', '' ),
				'type'        => array(
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'pattern',
				),
				'attributes'  => array(
					'id',
					'title',
					'short_description',
					'link',
					'image',
					'product_type',
					'current_price_with_tax',
					'sku',
					'',
					'',
				),
				'default'     => array( '', '', '', '', '', '', '', '', self::$brand, 'Delivery 1 to 3 days' ),
				'suffix'      => array( '', '', '', '', '', '', '', '', '', '' ),
				'output_type' => array( '1', '1', '8, 11', '1', '1', '1', '6', '1', '1', '1' ),
				'limit'       => array( '', '', '', '', '', '', '', '', '', '' ),
			),
			'bestprice'              => array(
				'mattributes' => array(
					'productId',
					'name',
					'description',
					'link',
					'image',
					'categoryPath',
					'categoryID',
					'price',
					'mpn',
					'manufacturer',
					'availability',
					'instock',
					'item_group_id'
				),
				'prefix'      => array( '', '', '', '', '', '', '', '', '', '', '', '', '' ),
				'type'        => array(
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'pattern',
					'pattern',
					'attribute',
					'attribute'
				),
				'attributes'  => array(
					'id',
					'title',
					'description',
					'link',
					'image',
					'product_type',
					'',
					'price',
					'sku',
					'',
					'',
					'availability',
					'item_group_id'
				),
				'default'     => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					self::$brand,
					'Delivery up to 30 days',
					'',
					'Item'
				),
				'suffix'      => array( '', '', '', '', '', '', '', '', '', '', '', '', '' ),
				'output_type' => array( '1', '1', '8, 11', '1', '1', '1', '1', '6', '1', '1', '1', '1', '1' ),
				'limit'       => array( '', '', '', '', '', '', '', '', '', '', '', '', '' ),
			),
			'googlereview'           => array(
				'mattributes' => array(
					'product_name',
					'product_url',
					'review_temp_gtin',
					'review_temp_mpn',
					'review_temp_sku',
					'review_temp_brand'
				),
				'prefix'      => array( '', '', '', '', '', '' ),
				'type'        => array( 'attribute', 'attribute', 'pattern', 'pattern', 'attribute', 'pattern' ),
				'attributes'  => array( 'title', 'link', '', '', 'sku', '' ),
				'default'     => array( '', '', '', '', '', self::$brand ),
				'suffix'      => array( '', '', '', '', '', '' ),
				'output_type' => array( '1', '1', '1', '1', '1', '1' ),
				'limit'       => array( '', '', '', '', '', '' ),
			),
			'google_shopping_action' => array(
				'mattributes' => array(
					'id',
					'title',
					'description',
					'item_group_id',
					'link',
					'product_type',
					'current_category',
					'image',
					'condition',
					'availability',
					'price',
					'sku',
					'brand',
					'sell_on_google_quantity',
					'min_handling_time',
					'max_handling_time',
					'return_address_label',
					'return_policy_label',
					'google_funded_promotion_eligibility',
				),
				'prefix'      => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'type'        => array(
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'pattern',
					'pattern',
					'pattern',
					'pattern',
					'pattern',
				),
				'attributes'  => array(
					'id',
					'title',
					'description',
					'item_group_id',
					'link',
					'product_type',
					'',
					'image',
					'condition',
					'availability',
					'price',
					'sku',
					'',
					'quantity',
					'',
					'',
					'',
					'',
					'',
				),
				'default'     => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					self::$brand,
					'',
					'',
					'',
					'',
					'',
					'all',
				),
				'suffix'      => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					' ' . self::$currency,
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'output_type' => array(
					'1',
					'1',
					'11',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'6',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
				),
				'limit'       => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
			),
			'daisycon'               => array(
				'mattributes' => array(
					'sku',
					'description',
					'link',
					'price',
					'title',
					'image_link_1',
					'brand',
					'category',
					'category_path',
					'delivery_time',
					'ean',
					'google_category_id',
					'in_stock',
					'in_stock_amount',
					'price_old',
					'color_primary',
					'condition',
					'gender_target',
					'price_shipping',
					'brand_logo',
					'delivery_description',
					'image_link_2',
					'keywords',
					'size',
					'size_description',
					'terms_conditions',
				),
				'prefix'      => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'type'        => array(
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'pattern',
					'pattern',
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'pattern',
				),
				'attributes'  => array(
					'sku',
					'description',
					'link',
					'price',
					'title',
					'image',
					'',
					'primary_category',
					'product_type',
					'',
					'sku',
					'',
					'availability',
					'wf_cattr__stock',
					'price',
					'wf_attr_pa_color',
					'condition',
					'',
					'',
					'',
					'',
					'image_2',
					'tags',
					'wf_attr_pa_size',
					'',
					'',
				),
				'default'     => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'Pxwp',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'suffix'      => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'output_type' => array(
					'1',
					'11',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
				),
				'limit'       => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
			),
			'daisycon_automotive'    => array(
				'mattributes' => array(
					'sku',
					'title',
					'description',
					'link',
					'price',
					'brand',
					'category',
					'category_path',
					'color_primary',
					'delivery_time',
					'ean',
					'google_category_id',
					'in_stock',
					'in_stock_amount',
					'price_old',
					'image_link_1',
					'condition',
					'price_shipping',
					'image_link_2',
					'brake_system',
					'brand_logo',
					'delivery_description',
					'fuel_type',
					'gear_system',
					'gender_target',
					'has_airco',
					'keywords',
					'model',
					'priority',
					'rental_location_city',
					'rental_location_country',
					'rental_location_region',
					'size',
					'size_description',
					'tire_size',
					'year_built',
					'terms_conditions'
				),
				'prefix'      => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					''
				),
				'type'        => array(
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'pattern',
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'pattern',
					'pattern',
					'pattern',
					'pattern',
					'pattern',
					'pattern',
					'pattern',
					'attribute',
					'pattern',
					'pattern',
					'pattern',
					'pattern',
					'pattern',
					'pattern',
					'pattern',
					'pattern',
					'pattern',
					'pattern'
				),
				'attributes'  => array(
					'sku',
					'title',
					'description',
					'link',
					'price',
					'',
					'primary_category',
					'product_type',
					'wf_attr_pa_color',
					'',
					'',
					'',
					'availability',
					'quantity',
					'price',
					'image',
					'condition',
					'',
					'image_2',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'tags',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					''
				),
				'default'     => array(
					'',
					'',
					'',
					'',
					'',
					'Pxwp',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					''
				),
				'suffix'      => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					''
				),
				'output_type' => array(
					'1',
					'1',
					'11',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1'
				),
				'limit'       => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					''
				),
			),
			'daisycon_books'         => array(
				'mattributes' => array(
					'description',
					'link',
					'price',
					'sku',
					'title',
					'author',
					'category',
					'category_path',
					'delivery_time',
					'ean',
					'google_category_id',
					'in_stock',
					'in_stock_amount',
					'isbn',
					'price_old',
					'image_link_1',
					'book_publisher',
					'book_type',
					'price_shipping',
					'image_link_2',
					'condition',
					'gender_target',
					'number_of_pages',
					'release_date',
					'book_edition',
					'delivery_description',
					'file_size',
					'file_type',
					'keywords',
					'language',
					'priority',
					'size',
					'size_description',
					'size_length',
					'size_width',
					'weight',
					'terms_conditions'
				),
				'prefix'      => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					''
				),
				'type'        => array(
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute'
				),
				'attributes'  => array(
					'description',
					'link',
					'current_price',
					'sku',
					'title',
					'',
					'primary_category',
					'product_type',
					'',
					'',
					'',
					'availability',
					'quantity',
					'',
					'price',
					'image',
					'',
					'',
					'',
					'image_1',
					'condition',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'tags',
					'',
					'',
					'',
					'',
					'length',
					'width',
					'weight',
					''
				),
				'default'     => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					''
				),
				'suffix'      => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					''
				),
				'output_type' => array(
					'11',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1'
				),
				'limit'       => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					''
				),
			),
			'daisycon_cosmetics'     => array(
				'mattributes' => array(
					'description',
					'link',
					'price',
					'sku',
					'title',
					'allergic_info',
					'amount_content',
					'amount_description',
					'category',
					'category_path',
					'delivery_time',
					'ean',
					'google_category_id',
					'in_stock',
					'in_stock_amount',
					'price_old',
					'image_link_1',
					'description_ingredients',
					'gender_target',
					'price_shipping',
					'skin_type',
					'image_link_2',
					'color_primary',
					'brand_logo',
					'condition',
					'delivery_description',
					'keywords',
					'made_in_country',
					'priority',
					'size',
					'size_description',
					'terms_conditions'
				),
				'prefix'      => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					''
				),
				'type'        => array(
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern'
				),
				'attributes'  => array(
					'description',
					'link',
					'current_price',
					'sku',
					'title',
					'',
					'weight',
					'',
					'primary_category',
					'product_type',
					'',
					'',
					'',
					'availability',
					'quantity',
					'price',
					'image',
					'',
					'',
					'',
					'',
					'image_2',
					'wf_attr_pa_color',
					'',
					'condition',
					'',
					'tags',
					'',
					'',
					'',
					'',
					''
				),
				'default'     => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					''
				),
				'suffix'      => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					''
				),
				'output_type' => array(
					'11',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1'
				),
				'limit'       => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					''
				),
			),
			'daisycon_daily_offers'  => array(
				'mattributes' => array(
					'description',
					'link',
					'price',
					'sku',
					'title',
					'brand',
					'category',
					'category_path',
					'delivery_time',
					'ean',
					'in_stock',
					'in_stock_amount',
					'price_old',
					'image_link_1',
					'google_category_id',
					'price_shipping',
					'image_link_2',
					'brand_logo',
					'color_primary',
					'condition',
					'delivery_description',
					'discount_amount',
					'discount_percentage',
					'gender_target',
					'keywords',
					'model',
					'offer_datetime_end',
					'offer_datetime_start',
					'size',
					'size_description',
					'terms_conditions'
				),
				'prefix'      => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					''
				),
				'type'        => array(
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern'
				),
				'attributes'  => array(
					'description',
					'link',
					'current_price',
					'sku',
					'title',
					'',
					'primary_category',
					'product_type',
					'',
					'',
					'availability',
					'quantity',
					'price',
					'image',
					'',
					'',
					'image_2',
					'',
					'wf_attr_pa_color',
					'condition',
					'',
					'',
					'',
					'',
					'tags',
					'',
					'',
					'',
					'',
					'',
					''
				),
				'default'     => array(
					'',
					'',
					'',
					'',
					'',
					self::$brand,
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					''
				),
				'suffix'      => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					''
				),
				'output_type' => array(
					'11',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1'
				),
				'limit'       => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					''
				),
			),
			'daisycon_electronics'   => array(
				'mattributes' => array(
					'sku',
					'description',
					'link',
					'price',
					'title',
					'image_link_1',
					'brand',
					'category',
					'category_path',
					'delivery_time',
					'ean',
					'google_category_id',
					'in_stock',
					'in_stock_amount',
					'price_old',
					'color_primary',
					'condition',
					'gender_target',
					'price_shipping',
					'brand_logo',
					'delivery_description',
					'image_link_2',
					'keywords',
					'size',
					'size_description',
					'terms_conditions',
				),
				'prefix'      => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'type'        => array(
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'pattern',
					'pattern',
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'pattern',
				),
				'attributes'  => array(
					'sku',
					'description',
					'link',
					'price',
					'title',
					'image',
					'',
					'primary_category',
					'product_type',
					'',
					'sku',
					'',
					'availability',
					'wf_cattr__stock',
					'price',
					'wf_attr_pa_color',
					'condition',
					'',
					'',
					'',
					'',
					'image_2',
					'tags',
					'wf_attr_pa_size',
					'',
					'',
				),
				'default'     => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'Pxwp',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'suffix'      => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'output_type' => array(
					'1',
					'11',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
				),
				'limit'       => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
			),
			'daisycon_fashion'       => array(
				'mattributes' => array(
					'sku',
					'description',
					'link',
					'price',
					'title',
					'image_link_1',
					'brand',
					'category',
					'category_path',
					'delivery_time',
					'ean',
					'google_category_id',
					'in_stock',
					'in_stock_amount',
					'price_old',
					'color_primary',
					'condition',
					'gender_target',
					'price_shipping',
					'brand_logo',
					'delivery_description',
					'image_link_2',
					'keywords',
					'size',
					'size_description',
					'terms_conditions',
				),
				'prefix'      => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'type'        => array(
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'pattern',
					'pattern',
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'pattern',
				),
				'attributes'  => array(
					'sku',
					'description',
					'link',
					'price',
					'title',
					'image',
					'',
					'primary_category',
					'product_type',
					'',
					'sku',
					'',
					'availability',
					'wf_cattr__stock',
					'price',
					'wf_attr_pa_color',
					'condition',
					'',
					'',
					'',
					'',
					'image_2',
					'tags',
					'wf_attr_pa_size',
					'',
					'',
				),
				'default'     => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'Pxwp',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'suffix'      => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'output_type' => array(
					'1',
					'11',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
				),
				'limit'       => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
			),
			'daisycon_food_drinks'   => array(
				'mattributes' => array(
					'sku',
					'description',
					'link',
					'price',
					'title',
					'image_link_1',
					'brand',
					'category',
					'category_path',
					'delivery_time',
					'ean',
					'google_category_id',
					'in_stock',
					'in_stock_amount',
					'price_old',
					'color_primary',
					'condition',
					'gender_target',
					'price_shipping',
					'brand_logo',
					'delivery_description',
					'image_link_2',
					'keywords',
					'size',
					'size_description',
					'terms_conditions',
				),
				'prefix'      => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'type'        => array(
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'pattern',
					'pattern',
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'pattern',
				),
				'attributes'  => array(
					'sku',
					'description',
					'link',
					'price',
					'title',
					'image',
					'',
					'primary_category',
					'product_type',
					'',
					'sku',
					'',
					'availability',
					'wf_cattr__stock',
					'price',
					'wf_attr_pa_color',
					'condition',
					'',
					'',
					'',
					'',
					'image_2',
					'tags',
					'wf_attr_pa_size',
					'',
					'',
				),
				'default'     => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'Pxwp',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'suffix'      => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'output_type' => array(
					'1',
					'11',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
				),
				'limit'       => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
			),
			'daisycon_holidays'
			. '_accommodations_and'
			. '_transport'           => array(
				'mattributes' => array(
					'sku',
					'description',
					'link',
					'price',
					'title',
					'image_link_1',
					'brand',
					'category',
					'category_path',
					'delivery_time',
					'ean',
					'google_category_id',
					'in_stock',
					'in_stock_amount',
					'price_old',
					'color_primary',
					'condition',
					'gender_target',
					'price_shipping',
					'brand_logo',
					'delivery_description',
					'image_link_2',
					'keywords',
					'size',
					'size_description',
					'terms_conditions',
				),
				'prefix'      => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'type'        => array(
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'pattern',
					'pattern',
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'pattern',
				),
				'attributes'  => array(
					'sku',
					'description',
					'link',
					'price',
					'title',
					'image',
					'',
					'primary_category',
					'product_type',
					'',
					'sku',
					'',
					'availability',
					'wf_cattr__stock',
					'price',
					'wf_attr_pa_color',
					'condition',
					'',
					'',
					'',
					'',
					'image_2',
					'tags',
					'wf_attr_pa_size',
					'',
					'',
				),
				'default'     => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'Pxwp',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'suffix'      => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'output_type' => array(
					'1',
					'11',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
				),
				'limit'       => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
			),
			'daisycon_holidays'
			. '_accommodations'      => array(
				'mattributes' => array(
					'sku',
					'description',
					'link',
					'price',
					'title',
					'image_link_1',
					'brand',
					'category',
					'category_path',
					'delivery_time',
					'ean',
					'google_category_id',
					'in_stock',
					'in_stock_amount',
					'price_old',
					'color_primary',
					'condition',
					'gender_target',
					'price_shipping',
					'brand_logo',
					'delivery_description',
					'image_link_2',
					'keywords',
					'size',
					'size_description',
					'terms_conditions',
				),
				'prefix'      => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'type'        => array(
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'pattern',
					'pattern',
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'pattern',
				),
				'attributes'  => array(
					'sku',
					'description',
					'link',
					'price',
					'title',
					'image',
					'',
					'primary_category',
					'product_type',
					'',
					'sku',
					'',
					'availability',
					'wf_cattr__stock',
					'price',
					'wf_attr_pa_color',
					'condition',
					'',
					'',
					'',
					'',
					'image_2',
					'tags',
					'wf_attr_pa_size',
					'',
					'',
				),
				'default'     => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'Pxwp',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'suffix'      => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'output_type' => array(
					'1',
					'11',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
				),
				'limit'       => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
			),
			'daisycon_holidays'
			. '_trips'               => array(
				'mattributes' => array(
					'sku',
					'description',
					'link',
					'price',
					'title',
					'image_link_1',
					'brand',
					'category',
					'category_path',
					'delivery_time',
					'ean',
					'google_category_id',
					'in_stock',
					'in_stock_amount',
					'price_old',
					'color_primary',
					'condition',
					'gender_target',
					'price_shipping',
					'brand_logo',
					'delivery_description',
					'image_link_2',
					'keywords',
					'size',
					'size_description',
					'terms_conditions',
				),
				'prefix'      => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'type'        => array(
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'pattern',
					'pattern',
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'pattern',
				),
				'attributes'  => array(
					'sku',
					'description',
					'link',
					'price',
					'title',
					'image',
					'',
					'primary_category',
					'product_type',
					'',
					'sku',
					'',
					'availability',
					'wf_cattr__stock',
					'price',
					'wf_attr_pa_color',
					'condition',
					'',
					'',
					'',
					'',
					'image_2',
					'tags',
					'wf_attr_pa_size',
					'',
					'',
				),
				'default'     => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'Pxwp',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'suffix'      => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'output_type' => array(
					'1',
					'11',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
				),
				'limit'       => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
			),
			'daisycon_home_garden'   => array(
				'mattributes' => array(
					'sku',
					'description',
					'link',
					'price',
					'title',
					'image_link_1',
					'brand',
					'category',
					'category_path',
					'delivery_time',
					'ean',
					'google_category_id',
					'in_stock',
					'in_stock_amount',
					'price_old',
					'color_primary',
					'condition',
					'gender_target',
					'price_shipping',
					'brand_logo',
					'delivery_description',
					'image_link_2',
					'keywords',
					'size',
					'size_description',
					'terms_conditions',
				),
				'prefix'      => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'type'        => array(
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'pattern',
					'pattern',
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'pattern',
				),
				'attributes'  => array(
					'sku',
					'description',
					'link',
					'price',
					'title',
					'image',
					'',
					'primary_category',
					'product_type',
					'',
					'sku',
					'',
					'availability',
					'wf_cattr__stock',
					'price',
					'wf_attr_pa_color',
					'condition',
					'',
					'',
					'',
					'',
					'image_2',
					'tags',
					'wf_attr_pa_size',
					'',
					'',
				),
				'default'     => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'Pxwp',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'suffix'      => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'output_type' => array(
					'1',
					'11',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
				),
				'limit'       => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
			),
			'daisycon_housing'       => array(
				'mattributes' => array(
					'sku',
					'description',
					'link',
					'price',
					'title',
					'image_link_1',
					'brand',
					'category',
					'category_path',
					'delivery_time',
					'ean',
					'google_category_id',
					'in_stock',
					'in_stock_amount',
					'price_old',
					'color_primary',
					'condition',
					'gender_target',
					'price_shipping',
					'brand_logo',
					'delivery_description',
					'image_link_2',
					'keywords',
					'size',
					'size_description',
					'terms_conditions',
				),
				'prefix'      => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'type'        => array(
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'pattern',
					'pattern',
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'pattern',
				),
				'attributes'  => array(
					'sku',
					'description',
					'link',
					'price',
					'title',
					'image',
					'',
					'primary_category',
					'product_type',
					'',
					'sku',
					'',
					'availability',
					'wf_cattr__stock',
					'price',
					'wf_attr_pa_color',
					'condition',
					'',
					'',
					'',
					'',
					'image_2',
					'tags',
					'wf_attr_pa_size',
					'',
					'',
				),
				'default'     => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'Pxwp',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'suffix'      => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'output_type' => array(
					'1',
					'11',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
				),
				'limit'       => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
			),
			'daisycon_magazines'     => array(
				'mattributes' => array(
					'sku',
					'description',
					'link',
					'price',
					'title',
					'image_link_1',
					'brand',
					'category',
					'category_path',
					'delivery_time',
					'ean',
					'google_category_id',
					'in_stock',
					'in_stock_amount',
					'price_old',
					'color_primary',
					'condition',
					'gender_target',
					'price_shipping',
					'brand_logo',
					'delivery_description',
					'image_link_2',
					'keywords',
					'size',
					'size_description',
					'terms_conditions',
				),
				'prefix'      => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'type'        => array(
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'pattern',
					'pattern',
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'pattern',
				),
				'attributes'  => array(
					'sku',
					'description',
					'link',
					'price',
					'title',
					'image',
					'',
					'primary_category',
					'product_type',
					'',
					'sku',
					'',
					'availability',
					'wf_cattr__stock',
					'price',
					'wf_attr_pa_color',
					'condition',
					'',
					'',
					'',
					'',
					'image_2',
					'tags',
					'wf_attr_pa_size',
					'',
					'',
				),
				'default'     => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'Pxwp',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'suffix'      => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'output_type' => array(
					'1',
					'11',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
				),
				'limit'       => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
			),
			'daisycon_studies'
			. '_trainings'           => array(
				'mattributes' => array(
					'sku',
					'description',
					'link',
					'price',
					'title',
					'image_link_1',
					'brand',
					'category',
					'category_path',
					'delivery_time',
					'ean',
					'google_category_id',
					'in_stock',
					'in_stock_amount',
					'price_old',
					'color_primary',
					'condition',
					'gender_target',
					'price_shipping',
					'brand_logo',
					'delivery_description',
					'image_link_2',
					'keywords',
					'size',
					'size_description',
					'terms_conditions',
				),
				'prefix'      => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'type'        => array(
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'pattern',
					'pattern',
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'pattern',
				),
				'attributes'  => array(
					'sku',
					'description',
					'link',
					'price',
					'title',
					'image',
					'',
					'primary_category',
					'product_type',
					'',
					'sku',
					'',
					'availability',
					'wf_cattr__stock',
					'price',
					'wf_attr_pa_color',
					'condition',
					'',
					'',
					'',
					'',
					'image_2',
					'tags',
					'wf_attr_pa_size',
					'',
					'',
				),
				'default'     => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'Pxwp',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'suffix'      => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'output_type' => array(
					'1',
					'11',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
				),
				'limit'       => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
			),
			'daisycon_telecom'
			. '_accessories'         => array(
				'mattributes' => array(
					'sku',
					'description',
					'link',
					'price',
					'title',
					'image_link_1',
					'brand',
					'category',
					'category_path',
					'delivery_time',
					'ean',
					'google_category_id',
					'in_stock',
					'in_stock_amount',
					'price_old',
					'color_primary',
					'condition',
					'gender_target',
					'price_shipping',
					'brand_logo',
					'delivery_description',
					'image_link_2',
					'keywords',
					'size',
					'size_description',
					'terms_conditions',
				),
				'prefix'      => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'type'        => array(
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'pattern',
					'pattern',
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'pattern',
				),
				'attributes'  => array(
					'sku',
					'description',
					'link',
					'price',
					'title',
					'image',
					'',
					'primary_category',
					'product_type',
					'',
					'sku',
					'',
					'availability',
					'wf_cattr__stock',
					'price',
					'wf_attr_pa_color',
					'condition',
					'',
					'',
					'',
					'',
					'image_2',
					'tags',
					'wf_attr_pa_size',
					'',
					'',
				),
				'default'     => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'Pxwp',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'suffix'      => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'output_type' => array(
					'1',
					'11',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
				),
				'limit'       => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
			),
			'daisycon_telecom'
			. '_all_in_one'          => array(
				'mattributes' => array(
					'sku',
					'description',
					'link',
					'price',
					'title',
					'image_link_1',
					'brand',
					'category',
					'category_path',
					'delivery_time',
					'ean',
					'google_category_id',
					'in_stock',
					'in_stock_amount',
					'price_old',
					'color_primary',
					'condition',
					'gender_target',
					'price_shipping',
					'brand_logo',
					'delivery_description',
					'image_link_2',
					'keywords',
					'size',
					'size_description',
					'terms_conditions',
				),
				'prefix'      => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'type'        => array(
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'pattern',
					'pattern',
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'pattern',
				),
				'attributes'  => array(
					'sku',
					'description',
					'link',
					'price',
					'title',
					'image',
					'',
					'primary_category',
					'product_type',
					'',
					'sku',
					'',
					'availability',
					'wf_cattr__stock',
					'price',
					'wf_attr_pa_color',
					'condition',
					'',
					'',
					'',
					'',
					'image_2',
					'tags',
					'wf_attr_pa_size',
					'',
					'',
				),
				'default'     => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'Pxwp',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'suffix'      => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'output_type' => array(
					'1',
					'11',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
				),
				'limit'       => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
			),
			'daisycon_telecom'
			. '_gsm_subscription'    => array(
				'mattributes' => array(
					'sku',
					'description',
					'link',
					'price',
					'title',
					'image_link_1',
					'brand',
					'category',
					'category_path',
					'delivery_time',
					'ean',
					'google_category_id',
					'in_stock',
					'in_stock_amount',
					'price_old',
					'color_primary',
					'condition',
					'gender_target',
					'price_shipping',
					'brand_logo',
					'delivery_description',
					'image_link_2',
					'keywords',
					'size',
					'size_description',
					'terms_conditions',
				),
				'prefix'      => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'type'        => array(
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'pattern',
					'pattern',
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'pattern',
				),
				'attributes'  => array(
					'sku',
					'description',
					'link',
					'price',
					'title',
					'image',
					'',
					'primary_category',
					'product_type',
					'',
					'sku',
					'',
					'availability',
					'wf_cattr__stock',
					'price',
					'wf_attr_pa_color',
					'condition',
					'',
					'',
					'',
					'',
					'image_2',
					'tags',
					'wf_attr_pa_size',
					'',
					'',
				),
				'default'     => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'Pxwp',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'suffix'      => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'output_type' => array(
					'1',
					'11',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
				),
				'limit'       => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
			),
			'daisycon_telecom_gsm'   => array(
				'mattributes' => array(
					'sku',
					'description',
					'link',
					'price',
					'title',
					'image_link_1',
					'brand',
					'category',
					'category_path',
					'delivery_time',
					'ean',
					'google_category_id',
					'in_stock',
					'in_stock_amount',
					'price_old',
					'color_primary',
					'condition',
					'gender_target',
					'price_shipping',
					'brand_logo',
					'delivery_description',
					'image_link_2',
					'keywords',
					'size',
					'size_description',
					'terms_conditions',
				),
				'prefix'      => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'type'        => array(
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'pattern',
					'pattern',
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'pattern',
				),
				'attributes'  => array(
					'sku',
					'description',
					'link',
					'price',
					'title',
					'image',
					'',
					'primary_category',
					'product_type',
					'',
					'sku',
					'',
					'availability',
					'wf_cattr__stock',
					'price',
					'wf_attr_pa_color',
					'condition',
					'',
					'',
					'',
					'',
					'image_2',
					'tags',
					'wf_attr_pa_size',
					'',
					'',
				),
				'default'     => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'Pxwp',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'suffix'      => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'output_type' => array(
					'1',
					'11',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
				),
				'limit'       => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
			),
			'daisycon_telecom_sim'   => array(
				'mattributes' => array(
					'sku',
					'description',
					'link',
					'price',
					'title',
					'image_link_1',
					'brand',
					'category',
					'category_path',
					'delivery_time',
					'ean',
					'google_category_id',
					'in_stock',
					'in_stock_amount',
					'price_old',
					'color_primary',
					'condition',
					'gender_target',
					'price_shipping',
					'brand_logo',
					'delivery_description',
					'image_link_2',
					'keywords',
					'size',
					'size_description',
					'terms_conditions',
				),
				'prefix'      => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'type'        => array(
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'pattern',
					'pattern',
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'pattern',
				),
				'attributes'  => array(
					'sku',
					'description',
					'link',
					'price',
					'title',
					'image',
					'',
					'primary_category',
					'product_type',
					'',
					'sku',
					'',
					'availability',
					'wf_cattr__stock',
					'price',
					'wf_attr_pa_color',
					'condition',
					'',
					'',
					'',
					'',
					'image_2',
					'tags',
					'wf_attr_pa_size',
					'',
					'',
				),
				'default'     => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'Pxwp',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'suffix'      => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'output_type' => array(
					'1',
					'11',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
				),
				'limit'       => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
			),
			'daisycon_work_jobs'     => array(
				'mattributes' => array(
					'sku',
					'description',
					'link',
					'price',
					'title',
					'image_link_1',
					'brand',
					'category',
					'category_path',
					'delivery_time',
					'ean',
					'google_category_id',
					'in_stock',
					'in_stock_amount',
					'price_old',
					'color_primary',
					'condition',
					'gender_target',
					'price_shipping',
					'brand_logo',
					'delivery_description',
					'image_link_2',
					'keywords',
					'size',
					'size_description',
					'terms_conditions',
				),
				'prefix'      => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'type'        => array(
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'pattern',
					'pattern',
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'pattern',
				),
				'attributes'  => array(
					'sku',
					'description',
					'link',
					'price',
					'title',
					'image',
					'',
					'primary_category',
					'product_type',
					'',
					'sku',
					'',
					'availability',
					'wf_cattr__stock',
					'price',
					'wf_attr_pa_color',
					'condition',
					'',
					'',
					'',
					'',
					'image_2',
					'tags',
					'wf_attr_pa_size',
					'',
					'',
				),
				'default'     => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'Pxwp',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'suffix'      => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
				'output_type' => array(
					'1',
					'11',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
				),
				'limit'       => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
				),
			),
			'shopee'                 => array(
				'mattributes' => array(
					'Category',
					'Product Name',
					'Product Description',
					'Price',
					'Stock',
					'SKU',
					'Cover image',
					'Weight'
				),
				'prefix'      => array( '', '', '', '', '', '', '', '' ),
				'type'        => array(
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute'
				),
				'attributes'  => array(
					'',
					'title',
					'description',
					'current_price',
					'quantity',
					'sku',
					'image',
					'weight'
				),
				'default'     => array( '', '', '', '', '', '', '', 'Localhost' ),
				'suffix'      => array( '', '', '', '', '', '', '', '' ),
				'output_type' => array( '1', '1', '11', '1', '1', '1', '1', '1' ),
				'limit'       => array( '', '', '', '', '', '', '', '' ),
			),
			'zalando'                => array(
				'mattributes' => array(
					'store',
					'ean',
					'price',
					'retail_price',
					'quantity',
					'article_number',
					'product_number',
					'product_name',
					'store_article_location'
				),
				'prefix'      => array( '', '', '', '', '', '', '', '', '' ),
				'type'        => array(
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern'
				),
				'attributes'  => array( '', '', 'price', 'sale_price', 'quantity', 'sku', 'id', 'title', '' ),
				'default'     => array( '', '', '', '', '', '', '', 'Localhost', 'type address here' ),
				'suffix'      => array( '', '', '', '', '', '', '', '', '' ),
				'output_type' => array( '1', '1', '6', '6', '1', '1', '1', '1', '1' ),
				'limit'       => array( '', '', '', '', '', '', '', '', '' ),
			),
			'etsy'                   => array(
				'mattributes' => array(
					'SKU',
					'TITLE',
					'DESCRIPTION',
					'PRICE',
					'CURRENCY_CODE',
					'QUANTITY',
					'TAGS',
					'MATERIALS',
					'IMAGE1',
					'IMAGE2',
					'IMAGE3',
					'IMAGE4'
				),
				'prefix'      => array( '', '', '', '', '', '', '', '', '', '', '', '' ),
				'type'        => array(
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute'
				),
				'attributes'  => array(
					'sku',
					'title',
					'description',
					'price',
					'',
					'quantity',
					'tags',
					'',
					'image',
					'image_1',
					'image_2',
					'image_3'
				),
				'default'     => array( '', '', '', '', 'USD', '', '', '', 'Localhost', '', '', '' ),
				'suffix'      => array( '', '', '', '', '', '', '', '', '', '', '', '' ),
				'output_type' => array( '1', '1', '11', '1', '1', '1', '1', '1', '1', '1', '1', '1' ),
				'limit'       => array( '', '', '', '', '', '', '', '', '', '', '', '' ),
			),
			'tweaker_csv'            => array(
				'mattributes' => array(
					'EAN code',
					'SKU Code',
					'Naam',
					'Deeplink',
					'Prijs',
					'Verzendkosten',
					'Levertijd',
					'Promotiezin'
				),
				'prefix'      => array( '', '', '', '', '', '', '', '' ),
				'type'        => array(
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'pattern',
					'pattern'
				),
				'attributes'  => array( '', 'sku', 'title', 'link', 'price', '', '', '' ),
				'default'     => array( '', '', '', '', '', '', '', '' ),
				'suffix'      => array( '', '', '', '', '', '', '', '' ),
				'output_type' => array( '1', '1', '1', '1', '6', '1', '1', '1' ),
				'limit'       => array( '', '', '', '', '', '', '', '' ),
			),
			'tweaker_xml'            => array(
				'mattributes' => array(
					'Product_in_stock',
					'Product_Brand',
					'SKU_Code',
					'Product_Name',
					'Product_Price',
					'Delivery_Period',
					'Product_Ean',
					'Deeplink',
					'Delivery_Costs',
					'Promotiezin'
				),
				'prefix'      => array( '', '', '', '', '', '', '', '', '', '' ),
				'type'        => array(
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'pattern',
					'pattern'
				),
				'attributes'  => array( 'quantity', '', 'sku', 'title', 'price', '', '', 'link', '', '' ),
				'default'     => array( '', '', '', '', '', '3 dagen', '', 'Localhost', '', '' ),
				'suffix'      => array( '', '', '', '', '', '', '', '', '', '' ),
				'output_type' => array( '1', '1', '1', '1', '6', '1', '1', '1', '1', '1' ),
				'limit'       => array( '', '', '', '', '', '', '', '', '', 'test' ),
			),
			'profit_share'           => array(
				'mattributes' => array(
					'Cod categorie',
					'Categorie',
					'Categorie parinte',
					'Producator',
					'Cod producator',
					'Model',
					'Cod produs',
					'Nume ',
					'Descriere',
					'Link produs',
					'Imagine produs',
					'Pret fara TVA',
					'Pret cu TVA',
					'Pret cu discount fara TVA',
					'Moneda',
					'Disponibilitate',
					'Livrare gratuita',
					'Cadou inclus',
					'Status',
					'ID categorie parinte'
				),
				'prefix'      => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					''
				),
				'type'        => array(
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'pattern',
					'pattern',
					'attribute'
				),
				'attributes'  => array(
					'child_category',
					'child_category_id',
					'primary_category',
					'',
					'',
					'sku',
					'id',
					'title',
					'description',
					'link',
					'image',
					'current_price',
					'current_price_with_tax',
					'sale_price',
					'store_currency',
					'availability',
					'',
					'',
					'',
					'primary_category_id'
				),
				'default'     => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'Develop-pro',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'1',
					'0',
					'1',
					''
				),
				'suffix'      => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					''
				),
				'output_type' => array(
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'11',
					'1',
					'1',
					'6',
					'6',
					'6',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1'
				),
				'limit'       => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					''
				),
			),
			'trendyol'               => array(
				'mattributes' => array(
					'Barkod',
					'Model Kodu',
					'Marka',
					'Kategori',
					'Para Birimi',
					'Ürün Adı',
					'Ürün Açıklaması',
					'Piyasa Satış Fiyatı (KDV Dahil)',
					'Trendyol\'da Satılacak Fiyat (KDV Dahil)',
					'Ürün Stok Adedi',
					'Stok Kodu',
					'KDV Oranı',
					'Desi',
					'Görsel Linki',
					'Sevkiyat Süresi',
					'Beden',
					'Kol Tipi',
					'Desen',
					'Boy / Ölçü',
					'Materyal',
					'Yaş Grubu',
					'Cinsiyet',
					'Yaka',
					'Renk'
				),
				'prefix'      => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					''
				),
				'type'        => array(
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute'
				),
				'attributes'  => array(
					'id',
					'sku',
					'',
					'product_type',
					'store_currency',
					'title',
					'description',
					'current_price_with_tax',
					'current_price_with_tax',
					'quantity',
					'',
					'',
					'',
					'link',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					''
				),
				'default'     => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'Localhost',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					''
				),
				'suffix'      => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					''
				),
				'output_type' => array(
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'11',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1'
				),
				'limit'       => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'test',
					'test',
					'test',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					''
				),
			),
			'gittigidiyor'           => array(
				'mattributes' => array(
					'Kategori No',
					'Dükkan No',
					'Stok No',
					'Başlık',
					'Alt Başlık',
					'Açıklama',
					'1. Fotoğraf',
					'2. Fotoğraf',
					'3. Fotoğraf',
					'4. Fotoğraf',
					'5. Fotoğraf',
					'6. Fotoğraf',
					'7. Fotoğraf',
					'8. Fotoğraf',
					'Sayfa Düzeni No',
					'Katalog No',
					'Katalog Detay',
					'Ürün Formatı',
					'Hemen Al Fiyatı',
					'Süre (Gün)',
					'Ürün Adeti',
					'Şehir No',
					'Kargo Ölçüleri',
					'Kargo Desi',
					'Kargo Şirketleri',
					'Kargo Ücreti',
					'Gönderi Yapılacak Alanlar',
					'Gönderi Yapacağınız Zaman',
					'İş Ortaklığı',
					'Kalın Yazı',
					'Katalog',
					'Vitrin',
					'Ürün Seçeneği',
					'Ürün Özelliği',
					'Üretici Parça Numarası (MPN)',
					'Global Ticari Öğe Numarası (GTIN)',
					'Yeni Katalog No'
				),
				'prefix'      => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					''
				),
				'type'        => array(
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'pattern',
					'pattern',
					'pattern',
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern'
				),
				'attributes'  => array(
					'primary_category_id',
					'',
					'',
					'title',
					'short_description',
					'description',
					'image_1',
					'image_2',
					'image_3',
					'image_4',
					'image_5',
					'image_6',
					'image_7',
					'image_8',
					'id',
					'id',
					'id',
					'id',
					'current_price',
					'',
					'quantity',
					'',
					'id',
					'id',
					'id',
					'id',
					'id',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					''
				),
				'default'     => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'3',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'2-3days',
					'false',
					'false',
					'false',
					'false',
					'',
					'',
					'',
					'',
					''
				),
				'suffix'      => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					''
				),
				'output_type' => array(
					'1',
					'1',
					'1',
					'1',
					'1',
					'11',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1',
					'1'
				),
				'limit'       => array(
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					''
				),
			),
			'heureka.sk'             => array(
				'mattributes' => array(
					'ITEM_ID',
					'PRODUCTNAME',
					'PRODUCT',
					'DESCRIPTION',
					'URL',
					'IMGURL',
					'PRICE_VAT',
					'CATEGORYTEXT',
					'EAN'
				),
				'prefix'      => array( '', '', '', '', '', '', '', '', '' ),
				'type'        => array(
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute'
				),
				'attributes'  => array(
					'id',
					'title',
					'title',
					'description',
					'link',
					'image',
					'current_price_with_tax',
					'product_type',
					'woo_feed_ean'
				),
				'default'     => array( '', '', '', '', '', '', '', '', 'Develop-pro' ),
				'suffix'      => array( '', '', '', '', '', '', '', '', '' ),
				'output_type' => array( '1', '1', '1', '11', '1', '1', '6', '1', '1' ),
				'limit'       => array( '', '', '', '', '', '', '', '', '' ),
			),
			'moebel.de'              => array(
				'mattributes' => array(
					'art_nr',
					'art_name',
					'art_beschreibung',
					'art_url',
					'art_img_url',
					'art_price',
					'art_kategorie',
					'art_verfuegbarkeit'
				),
				'prefix'      => array( '', '', '', '', '', '', '', '' ),
				'type'        => array(
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute'
				),
				'attributes'  => array(
					'id',
					'title',
					'description',
					'link',
					'image',
					'price',
					'product_type',
					'availability'
				),
				'default'     => array( '', '', '', '', '', '', '', '' ),
				'suffix'      => array( '', '', '', '', '', '', '', '' ),
				'output_type' => array( '1', '1', '11', '1', '1', '1', '1', '1' ),
				'limit'       => array( '', '', '', '', '', '', '', '' ),
			),
			'zbozi.cz'               => array(
				'mattributes' => array(
					'ITEM_ID',
					'PRODUCTNAME',
					'DESCRIPTION',
					'URL',
					'IMGURL',
					'CATEGORYTEXT',
					'VISIBILITY',
					'PRICE_VAT',
					'DELIVERY_DATE'
				),
				'prefix'      => array( '', '', '', '', '', '', '', '', '' ),
				'type'        => array(
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern'
				),
				'attributes'  => array(
					'id',
					'title',
					'description',
					'link',
					'image',
					'product_type',
					'visibility',
					'current_price_with_tax',
					''
				),
				'default'     => array( '', '', '', '', '', '', 'Develop-free', '', '0' ),
				'suffix'      => array( '', '', '', '', '', '', '', '', '' ),
				'output_type' => array( '1', '1', '11', '1', '1', '1', '1', '6', '1' ),
				'limit'       => array( '', '', '', '', '', '', '', '', '' ),
			),
			'catch.com.au'           => array(
				'mattributes' => array( 'product-id', 'title', 'product-description', 'image-1', 'price', 'state' ),
				'prefix'      => array( '', '', '', '', '', '' ),
				'type'        => array( 'attribute', 'attribute', 'attribute', 'attribute', 'attribute', 'pattern' ),
				'attributes'  => array( 'id', 'title', 'description', 'image', 'price', '' ),
				'default'     => array( '', '', '', '', '', 'new' ),
				'suffix'      => array( '', '', '', '', '', '' ),
				'output_type' => array( '1', '1', '11', '1', '6', '1' ),
				'limit'       => array( '', '', '', '', '', '' ),
			),
			'fashionchick'           => array(
				'mattributes' => array(
					'Product ID',
					'Titel',
					'Omschrijving',
					'Url',
					'Image',
					'Prijs',
					'Category',
					'Geslacht',
					'Merk'
				),
				'prefix'      => array( '', '', '', '', '', '', '', '', '' ),
				'type'        => array(
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'pattern'
				),
				'attributes'  => array(
					'id',
					'title',
					'description',
					'link',
					'image',
					'price',
					'product_type',
					'',
					''
				),
				'default'     => array( '', '', '', '', '', '', '', 'male', '' ),
				'suffix'      => array( '', '', '', '', '', '', '', '', '' ),
				'output_type' => array( '1', '1', '2, 11', '1', '1', '6', '1', '1', '1' ),
				'limit'       => array( '', '', '', '', '', '', '', '', '' ),
			),
			'wine_searcher'          => array(
				'mattributes' => array(
					'name',
					'description',
					'vintage',
					'unit-size',
					'price',
					'url',
					'min-order',
					'tax',
					'offer-type',
					'delivery-time',
					'stock-level'
				),
				'prefix'      => array( '', '', '', '', '', '', '', '', '', '', '' ),
				'type'        => array(
					'attribute',
					'attribute',
					'pattern',
					'pattern',
					'attribute',
					'attribute',
					'pattern',
					'pattern',
					'pattern',
					'pattern',
					'attribute'
				),
				'attributes'  => array( 'title', 'description', '', '', 'price', 'link', '', '', '', '', 'quantity' ),
				'default'     => array( '', '', '', '', '', 'Develop-free', '', '', '', '', '' ),
				'suffix'      => array( '', '', '', '', '', '', '', '', '', '', '' ),
				'output_type' => array( '1', '11', '1', '1', '6', '1', '1', '1', '1', '1', '1' ),
				'limit'       => array( '', '', '', '', '', '', '', '', '', '', '' ),
			),
			'modalova'               => array(
				'mattributes' => array(
					'id',
					'title',
					'description',
					'link',
					'sku',
					'main_image',
					'images',
					'price',
					'sale_price',
					'availability',
					'category',
					'condition',
					'child_category'
				),
				'prefix'      => array( '', '', '', '', '', '', '', '', '', '', '', '', '' ),
				'type'        => array(
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute'
				),
				'attributes'  => array(
					'id',
					'title',
					'description',
					'link',
					'sku',
					'image',
					'images',
					'price',
					'current_price',
					'availability',
					'primary_category',
					'condition',
					'child_category'
				),
				'default'     => array( '', '', '', '', '', '', '', '', self::$brand, '', '', '', '' ),
				'suffix'      => array( '', '', '', '', '', '', '', '', '', '', '', '', '' ),
				'output_type' => array( '1', '1', '11', '1', '1', '1', '1', '6', '6', '1', '1', '1', '1' ),
				'limit'       => array( '', '', '', '', '', '', '', '', '', '', '', '', '' ),
			),
			'ecommerceit'            => array(
				'mattributes' => array(
					'sku',
					'qty',
					'name',
					'brand',
					'category',
					'picture_url',
					'price',
					'product_url',
					'mpn',
					'shipping_cost',
					'max_delivery_days',
					'delivery_label'
				),
				'prefix'      => array( '', '', '', '', '', '', '', '', '', '', '', '' ),
				'type'        => array(
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'pattern',
					'pattern'
				),
				'attributes'  => array(
					'sku',
					'quantity',
					'title',
					'',
					'primary_category',
					'image',
					'price',
					'link',
					'',
					'shipping_cost',
					'',
					''
				),
				'default'     => array( '', '', '', self::$brand, '', '', '', '', '', '', '3', '1-5 days' ),
				'suffix'      => array( '', '', '', '', '', '', '', '', '', '', '', '' ),
				'output_type' => array( '1', '1', '1', '1', '1', '1', '6', '1', '1', '6', '1', '1' ),
				'limit'       => array( '', '', '', '', '', '', '', '', '', '', '', '' ),
			),
			'tiktok'                 => array(
				'mattributes' => array(
					'sku_id',
					'title',
					'description',
					'availability',
					'link',
					'image_link',
					'price',
					'brand',
					'condition',
					'google_product_category',
					'item_group_id',
					'product_type',
				),
				'prefix'      => array( '', '', '', '', '', '', '', '', '', '', '', '', ),
				'type'        => array(
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'pattern',
					'pattern',
					'attribute',
					'attribute',
				),
				'attributes'  => array(
					'sku_id',
					'title',
					'description',
					'availability',
					'link',
					'image',
					'price',
					'',
					'',
					'',
					'item_group_id',
					'product_type',
				),
				'default'     => array( '', '', '', '', '', '', '', self::$brand, 'new', '', '', '', ),
				'suffix'      => array( '', '', '', '', '', '', self::$currency, '', '', '', '', '', ),
				'output_type' => array( '1', '1', '1', '1', '1', '1', '6', '1', '1', '1', '1', '1', ),
				'limit'       => array( '', '', '', '', '', '', '', '', '', '', '', '', ),
			),
			'shopflix'               => array(
				'mattributes' => array(
					'sku',
					'name',
					'description',
					'ean',
					'manufacturer',
					'weight',
					'color',
					'price',
					'quantity',
					'shipping_lead_time',
				),
				'prefix'      => array( '', '', '', '', '', '', '', '', '', '', ),
				'type'        => array(
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
					'attribute',
					'attribute',
					'attribute',
					'attribute',
					'pattern',
				),
				'attributes'  => array( 'sku', 'title', 'description', '', '', '', '', 'price', 'quantity', '', ),
				'default'     => array( '', '', '', '', self::$brand, '', '', '', '', '1', ),
				'suffix'      => array( '', '', '', '', '', '', '', '', '', '', ),
				'output_type' => array( '1', '1', '1', '1', '1', '1', '1', '6', '1', '1', ),
				'limit'       => array( '', '', '', '', '', '', '', '', '', '', ),
			),
            'chatgpt'               => array(
                'mattributes' => array(
                    'enable_search',
                    'enable_checkout',
                    'id',
                    'title',
                    'description',
                    'item_group_id',
                    'link',
                    'product_category',
                    'image_link',
                    'condition',
                    'availability',
                    'price',
                    'brand',
                    'material',
                    'weight',
                    'inventory_quantity',
                    'seller_name',
                    'seller_url',
                    'return_policy',
                    'return_window'
                ),
                'prefix'      => array(
                    '',
                    '',
                    '', 
                    '', 
                    '', 
                    '', 
                    '', 
                    '', 
                    '', 
                    '', 
                    '', 
                    '', 
                    '', 
                    '', 
                    '', 
                    '', 
                    '', 
                    '',
                    '',
                    ''
                ),
                'type'        => array(
                    'pattern',
                    'pattern',
                    'attribute',
                    'attribute',
                    'attribute',
                    'attribute',
                    'attribute',
                    'attribute',
                    'attribute',
                    'pattern',
                    'attribute',
                    'attribute',
                    'pattern',
                    'pattern',
                    'attribute',
                    'attribute',
                    'pattern',
                    'pattern',
                    'pattern',
                    'pattern'
                ),
                'attributes'  => array(
                    '',
                    '',
                    'id',
                    'title',
                    'description',
                    'item_group_id',
                    'link',
                    'product_type',
                    'image',
                    '',
                    'availability',
                    'price',
                    '',
                    '',
                    'weight',
                    'quantity',
                    '',
                    '',
                    '',
                    ''
                ),
                'default'     => array(
                    'true',
                    'false',
                    '',
                    '',
                    '',
                    '',
                    '',
                    '',
                    '',
                    'new',
                    '',
                    '',
                    self::$brand,
                    '',
                    '',
                    '',
                    '',
                    '',
                    '',
                    ''
                ),
                'suffix'      => array(
                    '',
                    '',
                    '',
                    '',
                    '',
                    '',
                    '',
                    '',
                    '',
                    '',
                    '',
                    ' ' . self::$currency,
                    '',
                    '',
                    '',
                    '',
                    '',
                    '',
                    '',
                    ''
                ),
                'output_type' => array(
                    '1',
                    '1',
                    '1',
                    '1',
                    '11',
                    '1',
                    '1',
                    '1',
                    '1',
                    '1',
                    '1',
                    '6',
                    '1',
                    '1',
                    '1',
                    '1',
                    '1',
                    '1',
                    '1',
                    '1'
                ),
                'limit'       => array(
                    '',
                    '',
                    '',
                    '',
                    '',
                    '',
                    '',
                    '',
                    '',
                    '',
                    '',
                    '',
                    '',
                    '',
                    '',
                    '',
                    '',
                    '',
                    '',
                    ''
                ),

            ),
		);

        $config = array_merge(
            $config,
            array(
                'custom2'    => array(
                    'feed_config_custom2' => file_get_contents( WOO_FEED_FREE_ADMIN_PATH . '/partials/templates/custom2/custom2.txt' ),
                ),
                'admarkt'    => array(
                    'feed_config_custom2' => file_get_contents( WOO_FEED_FREE_ADMIN_PATH . '/partials/templates/custom2/admarkt.txt' ),
                ),
                'glami'      => array(
                    'feed_config_custom2' => file_get_contents( WOO_FEED_FREE_ADMIN_PATH . '/partials/templates/custom2/glami.txt' ),
                ),
                'yandex_xml' => array(
                    'feed_config_custom2' => file_get_contents( WOO_FEED_FREE_ADMIN_PATH . '/partials/templates/custom2/yandex_xml.txt' ),
                ),
            )
        );


        if ( array_key_exists( $merchant, $config ) ) {
			return $config[ $merchant ];
		}


		$merchant_name = 'default';
		switch ( $merchant ) {
			case 'pinterest':
				$merchant_name = 'google';
				break;
			case 'adroll':
				$merchant_name = 'google';
				break;
			case 'smartly.io':
				$merchant_name = 'google';
				break;
			case 'connexity':
				$merchant_name = 'become';
				break;
			case 'shopzilla':
				$merchant_name = 'become';
				break;
			case 'fruugo.au':
				$merchant_name = 'fruugo';
				break;
			case 'shopalike.fr':
				$merchant_name = 'kijiji.ca';
				break;
			default:
				$merchant_name = 'default';
				break;
		}


		return isset( $config[ $merchant_name ] ) ? $config[ $merchant_name ] : $config['default'];

	}

	/**
	 * @param $merchants
	 *
	 * @return array
	 */
	public static function getMultiple( $merchants = [] ) {
		if ( empty( $merchants ) ) {
			return [];
		}

		$merchants_data = [];
		foreach ( $merchants as $merchant ) {
            $merchants_data[ $merchant ] = self::get( $merchant );
		}

		return $merchants_data;
	}
}
