<?php
/**
 * Plugin Name: WooCommerce Product Title Fixer
 * Description: Κάνει κεφαλαίο το πρώτο γράμμα κάθε λέξης στους τίτλους προϊόντων σε παρτίδες με χρήση AJAX.
 * Version: 2.0
 * Author: OpenAI (τροποποίηση από χρήστη)
 */

if (!defined('ABSPATH')) {
    exit;
}

add_action('admin_menu', 'wcptf_create_menu');
function wcptf_create_menu() {
    add_submenu_page(
        'woocommerce',
        'Product Title Fixer',
        'Product Title Fixer',
        'manage_woocommerce',
        'wcptf-title-fixer',
        'wcptf_settings_page'
    );
}

add_action('admin_enqueue_scripts', 'wcptf_enqueue_scripts');
function wcptf_enqueue_scripts($hook) {
    if (strpos($hook, 'wcptf-title-fixer') !== false) {
        wp_enqueue_script('wcptf-js', plugin_dir_url(__FILE__) . 'title-fixer.js', array('jquery'), null, true);
        wp_localize_script('wcptf-js', 'wcptf_ajax', array(
            'ajax_url' => admin_url('admin-ajax.php'),
            'nonce' => wp_create_nonce('wcptf_nonce'),
        ));
    }
}

function wcptf_settings_page() {
    ?>
    <div class="wrap">
        <h1>WooCommerce Product Title Fixer (v2)</h1>
        <p><strong>Τι κάνει:</strong> Διορθώνει τους τίτλους προϊόντων σε παρτίδες των 50 μέσω AJAX.</p>
        <button id="wcptf-start" class="button button-primary">Ξεκίνα Διόρθωση Τίτλων</button>
        <div id="wcptf-progress" style="margin-top:20px; display:none;">
            <div id="wcptf-status">Ξεκινά επεξεργασία...</div>
            <progress id="wcptf-bar" value="0" max="100" style="width: 100%;"></progress>
        </div>
    </div>
    <?php
}

add_action('wp_ajax_wcptf_process_batch', 'wcptf_process_batch');
function wcptf_process_batch() {
    check_ajax_referer('wcptf_nonce', 'nonce');

    $paged = isset($_POST['paged']) ? intval($_POST['paged']) : 1;
    $batch_size = 50;

    $args = array(
        'post_type'      => 'product',
        'posts_per_page' => $batch_size,
        'paged'          => $paged,
        'post_status'    => 'publish',
        'fields'         => 'ids',
    );

    $query = new WP_Query($args);
    $total = $query->found_posts;
    $processed = 0;

    foreach ($query->posts as $product_id) {
        $old_title = get_the_title($product_id);
        $new_title = mb_convert_case($old_title, MB_CASE_TITLE, 'UTF-8');

        if ($old_title !== $new_title) {
            wp_update_post(array(
                'ID'         => $product_id,
                'post_title' => $new_title,
            ));
        }

        $processed++;
    }

    wp_send_json(array(
        'success' => true,
        'processed' => $processed,
        'total' => $total,
        'next_page' => ($processed > 0 && $query->max_num_pages > $paged) ? $paged + 1 : null,
    ));
}
