jQuery(document).ready(function($) {
    $('#wcptf-start').click(function() {
        $('#wcptf-progress').show();
        processBatch(1);
    });

    function processBatch(page) {
        $.post(wcptf_ajax.ajax_url, {
            action: 'wcptf_process_batch',
            paged: page,
            nonce: wcptf_ajax.nonce
        }, function(response) {
            if (response.success) {
                let percent = (page - 1) * 50;
                $('#wcptf-status').text('Επεξεργασία σελίδας: ' + page);
                $('#wcptf-bar').val(percent);

                if (response.next_page) {
                    processBatch(response.next_page);
                } else {
                    $('#wcptf-status').text('✅ Ολοκληρώθηκε η διόρθωση τίτλων.');
                    $('#wcptf-bar').val(100);
                }
            } else {
                $('#wcptf-status').text('❌ Παρουσιάστηκε σφάλμα.');
            }
        });
    }
});
