<?php
/*
  Plugin Name: Product Category Tree Pro
  Plugin URI: https://awesometogi.com/product-category-tree-plugin-for-wordpress/
  Description: See your product categories in a tree structure and change their order via drag 'n' drop.
  Version: 3.7
  Author: AWESOME TOGI
  Author URI: https://awesometogi.com/
  Text Domain: wc-disable-categories
  Domain Path: /languages/
 */

  define('WCDC_PLUGIN_PREMIUM', 'version 3.7');
  add_action('plugins_loaded', 'wcdc_plugin_install', 11);

  if (!function_exists('wcdc_plugin_constructor')) {

    function wcdc_plugin_constructor() {
      include 'wc-disable-categories.php';

      if (class_exists('WC_Disable_Categories')) {
            // Let's start the game
        new WC_Disable_Categories();
      }
    }

  }

  add_action('wcdc_plugin_init', 'wcdc_plugin_constructor');

  if (!function_exists('wcdc_plugin_install')) {

    function wcdc_plugin_install() {

      if (!function_exists('WC')) {
        add_action('admin_notices', 'wcdc_plugin_install_woocommerce_admin_notice');
      } else {
        do_action('wcdc_plugin_init');
      }
    }

  }

  if (!function_exists('wcdc_plugin_install_woocommerce_admin_notice')) {

    function wcdc_plugin_install_woocommerce_admin_notice() {
      ?>
      <div class="error">
        <p><?php _e('Product Category Tree is enabled but not effective. It requires WooCommerce in order to work.', 'wc-disable-categories'); ?></p>
      </div>
      <?php
    }

  }


  //if ( is_woocommerce_active() ) {
  define( 'WCDC_VERSION', '3.7' );
  define( 'WCDC_MINIMUM_WP_VERSION', '3.7' );
  define('WCDC_RELATIVE_PATH', plugin_dir_url( __FILE__ ));
  define('WCDC_ABS_PATH', plugin_dir_path(__FILE__));
  define( 'WCDC_PLUGIN_PATH', plugin_dir_path( __FILE__ ));
  define('WCDC_SPECIAL_SECRET_KEY', '591c4669bbfe84.08596709');
  define('WCDC_LICENSE_SERVER_URL', 'https://awesometogi.com/');
  define('WCDC_ITEM_REFERENCE', 'WCDCPlugin');
  require_once( 'plugin-authentication.php' );
  //echo get_option('WCDC_license_key');
  $api_params = array(
    'slm_action' => 'slm_check',
    'secret_key' => WCDC_SPECIAL_SECRET_KEY,
    'license_key' => get_option('WCDC_license_key'),
    'registered_domain' => $_SERVER['SERVER_NAME'],
    'item_reference' => urlencode(WCDC_ITEM_REFERENCE),
    'time' => time(),
  );


  $last_update_check = get_option('last_wcdc_update_check');
  $start_date = new DateTime(date('Y-m-d H:i:s',$last_update_check));
  $since_start = $start_date->diff(new DateTime(date('Y-m-d H:i:s')));
  global $pagenow;
  
  if(($since_start->days >=5 || $last_update_check=='') && $pagenow =='plugins.php') {
    update_option('last_wcdc_update_check',time());  

    $response = wp_remote_get(add_query_arg($api_params, WCDC_LICENSE_SERVER_URL), array('timeout' => 20, 'sslverify' => false)); 
    update_option('last_wcdc_update_check_data',$response);  
  } else {
    $response = get_option('last_wcdc_update_check_data');
  }
  

  if (is_wp_error($response)){
    add_action( 'admin_notices', 'WCDC_activation_notice' );
    function WCDC_activation_notice() {
      $class = 'notice notice-error is-dismissible';
      $message = __('Unexpected Error! The query returned with an error.', 'wc-disable-categories');
      printf( '<div class="%1$s"><p>%2$s</p></div>', $class, $message ); 
    }
  } else {
    $data = json_decode($response['body'],true);
    $license_key = get_option('WCDC_license_key');
    
    if (isset($data['status']) && $data['status'] == 'active') {
      require 'plugin-update-checker/plugin-update-checker.php';
      $MyUpdateChecker = Puc_v4_Factory::buildUpdateChecker(
        WCDC_LICENSE_SERVER_URL."/wp-content/uploads/wp-update-server/?action=get_metadata&license_key=$license_key&slug=product-category-tree-pro",
          //&license_key=$license_key
          //Metadata URL.
          __FILE__, //Full path to the main plugin file.
          'product-category-tree-pro' //Plugin slug. Usually it's the same as the name of the directory.
        );

    } else {

      if (isset($data['status']) && $data['status'] == 'expired') {

        if (isset($data['subscr_expired']) && $data['subscr_expired'] == '1') {
            add_action('admin_notices', 'WCDC_subscription_expired_notice');
        } else {
            add_action('admin_notices', 'WCDC_licence_expired_notice');
        }

      } else {
          add_action('admin_notices', 'WCDC_activation_notice');
      }

      function WCDC_activation_notice() {
        $class = 'notice notice-error is-dismissible';
        $message = __( 'Product Category Tree is enabled but not effective.', 'wc-disable-categories' );
        $url = esc_url(home_url().'/wp-admin/options-general.php?page=product-category-tree-pro/plugin-authentication.php');
        printf( '<div class="%1$s wcdc_license_error_link"><p>%2$s <a href="'.$url.'">You need to enter a license key.</a></p></div>', $class, $message ); 
      }

      function WCDC_subscription_expired_notice()
      {
          $class   = 'notice notice-error is-dismissible WCDC_license_error_link';
          $message = __('Your subscription for Product Category Tree plugin has expired. Renew it to get future updates.', 'wc-disable-categories');
          printf('<div class="%1$s"><p>%2$s </p></div>', $class, $message);
      }

      function WCDC_licence_expired_notice()
      {
          $license_key = get_option('WCDC_license_key');
          $class   = 'notice notice-error is-dismissible WCDC_license_error_link';
          $message = __('Your licence key "'.$license_key.'" for Product Category Tree plugin has expired.  Renew it to get future updates.', 'wc-disable-categories');
          printf('<div class="%1$s"><p>%2$s </p></div>', $class, $message);
      }

      function filter_WCDC_plugin_updates( $value ) {
        $license_key = get_option('WCDC_license_key');
        if(!empty($license_key)) {
          if(isset($value->response['product-category-tree-pro/product-category-tree-pro.php']))
            unset( $value->response['product-category-tree-pro/product-category-tree-pro.php'] );
        }   

        return $value;
      }
      add_filter( 'site_transient_update_plugins', 'filter_WCDC_plugin_updates' );

      $path = plugin_basename( __FILE__ );
      add_action("after_plugin_row_{$path}", function( $plugin_file, $plugin_data, $status ) {
        $license_key = get_option('WCDC_license_key');

        if (!empty($license_key)) {
          $response = get_option('last_wcdc_update_check_data');
          $data = json_decode($response['body'], true);

          if (isset($data['status']) && $data['status'] == 'expired') {
              if (isset($data['subscr_expired']) && $data['subscr_expired'] == '1') {
                  $message = __('Your subscription for Product Category Tree plugin has expired. Renew it to get future updates.', 'wc-disable-categories');
                  echo '<tr class="active"><td>&nbsp;</td><td colspan="2"><div class="notice inline notice-warning notice-alt"><p> ' . $message . ' </p></div></td></tr>';
              } else {
                  $license_key = get_option('WCDC_license_key');
                  $message = __('Your licence key "'.$license_key.'" for  Product Category Tree plugin has expired.  Renew it to get future updates.', 'wc-disable-categories');
                  echo '<tr class="active"><td>&nbsp;</td><td colspan="2"><div class="notice inline notice-warning notice-alt"><p> ' . $message . ' </p></div></td></tr>';
              }
          }
        } else { 
            $class = 'notice notice-error';
            $message = __( 'Product Category Tree is enabled but not effective.', 'wc-disable-categories' );
            $url = esc_url(home_url().'/wp-admin/options-general.php?page=product-category-tree-pro/plugin-authentication.php');
            echo '<tr class="active"><td>&nbsp;</td><td colspan="2">
            <div class="notice inline notice-warning notice-alt"><p> '.$message .' <a href="'.$url.'">You need to enter a license key.</a></p></div></td></tr>';
        }


      }, 10, 3 ); 

      function WCDC_plugin_action_links( $links ) {

        $links = array_merge(
          array(
            '<a href="' . esc_url( admin_url( '/options-general.php?page=product-category-tree-pro%2Fplugin-authentication.php' ) ) . '">' . __( 'Settings', 'wc-disable-categories' ) . '</a>'
          ), $links ); 
        update_option('plugin_option',$links);

        foreach($links as $index=>$option) {
          $link_slug = strtolower(strip_tags($option));
          if( $link_slug !='deactivate' && $link_slug !='activate' && $link_slug != 'translate' ) {
            $license_key = get_option('WCDC_license_keyWCDC_license_key');

            unset($links[$index]);
          }   
        }
        return $links;
      }
      add_action( 'plugin_action_links_' . plugin_basename( __FILE__ ), 'WCDC_plugin_action_links' );

    }
  }

function wpse_pre_get_posts( $query ) {

    if (     ! is_admin()     &&   $query->is_search() ) {
       $query->set( 'post_type', array( 'product' ) );
       $tax_query = array(
           array(
               'taxonomy' => 'product_cat',
               'field'   => 'term_id',
               'terms'   => get_option('woo_disabled_categories'),
               'operator' => 'NOT IN',
           ),
       ); 
       $query->set( 'tax_query', $tax_query );
   }
}

add_action( 'pre_get_posts', 'wpse_pre_get_posts',100 );