<?php

// Exit if accessed directly
if (!defined('ABSPATH'))
    exit;

if (!function_exists('wcdc_productCatDisableColumn')) {

    function wcdc_productCatDisableColumn($columns, $column, $id) {

        if ('disable-cat' == $column) {
            $disabledCats = get_option('woo_disabled_categories');
            $returnUrl = $_SERVER['REQUEST_URI'];
            $columns .='<input type="hidden" name=""  value="' . $id . '" />';
            $paged = isset($_GET['paged']) ? $_GET['paged'] : 1;

            if (!empty($disabledCats) && is_array($disabledCats) && in_array($id, $disabledCats)) {
                $queryArgs = add_query_arg(array(
                    'woo-action' => 'activate-cat',
                    'wooCatId' => $id,
                    'goTo' => $paged,
                ));
                $columns .='<a href="' . $queryArgs . '" alt="' . __("Is deactive", "wc-disable-categories") . '" title="' . __("Is deactive", "wc-disable-categories") . '" >';
                $columns .='<img data-tip="' . __("Click in order to deactivate/activate all products in a category.", "wc-disable-categories") . '" class="help_tip" src="' . WCDC_PLUGIN_URL . '/assets/images/disable.png" alt="' . __("Is deactive", "wc-disable-categories") . '" title="' . __("Is deactive", "wc-disable-categories") . '" />';
                $columns .='</a>';
            } else {
                $queryArgs = add_query_arg(array(
                    'woo-action' => 'deactivate-cat',
                    'wooCatId' => $id,
                    'goTo' => $paged,
                ));
                $columns .='<a href="' . $queryArgs . '" alt="' . __("Is active", "wc-disable-categories") . '" title="' . __("Is active", "wc-disable-categories") . '" >';
                $columns .='<img data-tip="' . __("Click in order to deactivate/activate all products in a category.", "wc-disable-categories") . '" class="help_tip" src="' . WCDC_PLUGIN_URL . '/assets/images/enable.png" alt="' . __("Is active", "wc-disable-categories") . '" title="' . __("Is active", "wc-disable-categories") . '" />';
                $columns .='</a>';
            }
        }

        return $columns;
    }

}

if (!function_exists('wcdc_productCatDisableColumns')) {

    function wcdc_productCatDisableColumns($columns) {
        $new_columns = array();
        $new_columns['disable-cat'] = __('Status', 'woocommerce');
        return array_merge($new_columns, $columns);
    }

}
add_action('admin_init', 'wcdc_changeCategoryStatus', 1);

if (!function_exists('wcdc_changeCategoryStatus')) {

    function wcdc_changeCategoryStatus() {

        if (isset($_GET['woo-action'])) {

            if (!empty($_GET['woo-action']) && $_GET['woo-action'] == "activate-cat") {
                $catId = $_GET['wooCatId'];
                $disabledCats = get_option('woo_disabled_categories');
                $updateDisabledCats = wcdc_removeArrayValue($disabledCats, array($catId));
                update_option('woo_disabled_categories', $updateDisabledCats);
            } else if (!empty($_GET['woo-action']) && $_GET['woo-action'] == "deactivate-cat") {
                $catId = $_GET['wooCatId'];
                $disabledCats = array();
                $disabledCats = get_option('woo_disabled_categories');
                $updateDisabledCats = (!empty($disabledCats) && is_array($disabledCats)) ? array_push($disabledCats, $catId) : ($disabledCats[] = $catId);

                update_option('woo_disabled_categories', $disabledCats);
            }
        }
    }

}

if (!function_exists('wcdc_removeArrayValue')) {

    function wcdc_removeArrayValue($array, $element) {
        return array_diff($array, $element);
    }

}

if (!is_admin()) {
    add_filter('get_terms_args', 'wcdc_wooFilterGetTermArgs', 150, 2);
}

if (!function_exists('wcdc_wooFilterGetTermArgs')) {

    function wcdc_wooFilterGetTermArgs($args, $taxonomies) {
        if (!empty($args)) {
            // check whether we're currently filtering selected taxonomy
            if (in_array("product_cat", $taxonomies)) {
                $disabledCats = get_option('woo_disabled_categories');
                if (!empty($disabledCats) && is_array($disabledCats))
                    $args['exclude'] = $disabledCats; //It will hidew the category that mentioned in above array
            }
        }

        return $args;
    }

}

add_action('pre_get_posts', 'wcdc_wooModifyQueryExcludeCategory', 150);

if (!function_exists('wcdc_wooModifyQueryExcludeCategory')) {

// Create a function to excplude some categories from the main query
    function wcdc_wooModifyQueryExcludeCategory($query) {
        if(!is_admin())
            return;

        if (!$query->is_main_query())
            return;

        if (!is_admin()) {

            $disabledCats = get_option('woo_disabled_categories');
            $productCats = wcdc_getProductCatIds();
            $disabledProducts = wcdc_getDisabledProducts($disabledCats);

            if (!empty($productCats) && is_array($productCats)) {

                $query->set('tax_query', array(
                    array(
                        'taxonomy' => 'product_cat',
                        'field' => 'id',
                        'terms' => $productCats, // Display products in the category.
                        'operator' => 'IN'
                    )
                ));

                $query->set('post__not_in', $disabledProducts);
            }
        }
    }

}


if (!function_exists('wcdc_getProductCatIds')) {

    function wcdc_getProductCatIds() {
        $productCats = get_terms('product_cat');
        $catIds = array();
        if (!empty($productCats)) {
            foreach ($productCats as $productCat) {
                $catIds[] = $productCat->term_id;
            }
        }

        return $catIds;
    }

}


if (!function_exists('wcdc_getDisabledProducts')) {

    function wcdc_getDisabledProducts($disabledCats) {
        $disabledProductIds = array();
        $disabledProducts = get_posts(array(
            'post_type' => 'product',
            'numberposts' => -1,
            'tax_query' => array(
                array(
                    'taxonomy' => 'product_cat',
                    'field' => 'id',
                    'terms' => $disabledCats
                )
            )
        ));

        if ($disabledProducts) {
            foreach ($disabledProducts as $disabledProduct) {
                $productTerms = wp_get_object_terms($disabledProduct->ID, 'product_cat');
                if (count($productTerms) > 1) {
                    foreach ($productTerms as $productTerm) {
                        if (in_array($productTerm->term_id, $disabledCats)) {
                            $disabledProductIds[$disabledProduct->ID] = $disabledProduct->ID;
                        } else {
                            unset($disabledProductIds[$disabledProduct->ID]);
                            break;
                        }
                    }
                } else {
                    $disabledProductIds[$disabledProduct->ID] = $disabledProduct->ID;
                }
            }
        }

        return (array_unique($disabledProductIds));
    }

}
