<?php

// Exit if accessed directly
if (!defined('ABSPATH'))
    exit;

class HatsWooCategoryChecklist {

    public function __construct() {
        add_filter('wp_terms_checklist_args', array($this, 'checklistArgs'));
        add_action('admin_init', array($this, 'adminCategoryStuff'));
    }

    public function checklistArgs($args) {
        $args['checked_ontop'] = false;
        return $args;
    }

    public function adminCategoryStuff() {
        wp_register_script('admin_category_tree', WCDC_PLUGIN_URL . '/assets/js/admin-category-tree.js');
        wp_enqueue_script('admin_category_tree');
    }

}

new HatsWooCategoryChecklist();

