<?php
/**
 * Plugin Name: Oxygen MyData
 * Plugin URI: https://wordpress.org/plugins/oxygen-mydata/
 * Description: WooCommerce integration with MyData invoices for Greece.
 * Version: 2.0.36
 * Author: oxygensuite
 * Author URI: https://www.pelatologio.gr/
 * Requires at least: 5.5
 * Tested up to: 6.8.2
 * Requires PHP: 7.4
 * WC requires at least: 4.7
 * WC tested up to: 10.0.4
 * License: GPLv2
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 *
 * Oxygen MyData for WooCommerce is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Oxygen MyData for WooCommerce. If not, see https://www.gnu.org/licenses/gpl-2.0.html
 *
 * @package Oxygen
 * @version 2.0.36
 * @since   1.0.0
 */

defined( 'ABSPATH' ) || exit;

// Define constants.
define( 'OXYGEN_PLUGIN_VERSION', '2.0.36' );
define( 'OXYGEN_PLUGIN_FILE', __FILE__ );
define( 'OXYGEN_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'OXYGEN_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
define( 'OXYGEN_PLUGIN_BASENAME', plugin_basename( __FILE__ ) );

// Activation check.
require_once OXYGEN_PLUGIN_DIR . '/checks/class-checkbeforeactivation.php';

register_activation_hook(
	__FILE__,
	function () {
		CheckBeforeActivation::oxygen_woo_plugin_check_activation( plugin_basename( __FILE__ ) );
	}
);

add_action(
	'admin_init',
	function () {
		if ( get_option( 'oxygen_woo_plugin_activation_error' ) ) {
			add_action( 'admin_notices', array( 'CheckBeforeActivation', 'oxygen_woo_plugin_activation_admin_notice' ) );
			deactivate_plugins( plugin_basename( __FILE__ ), true );
		}
	}
);

// Include the main plugin class and initialize it.
require_once OXYGEN_PLUGIN_DIR . '/inc/class-oxygen.php';
add_action( 'woocommerce_loaded', array( 'Oxygen', 'init' ) );

/**
 * Declare WooCommerce HPOS compatibility.
 */
function oxygen_hpos_compatibility() {
	if ( class_exists( \Automattic\WooCommerce\Utilities\FeaturesUtil::class ) ) {
		\Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', __FILE__, true );
	}
}
add_action( 'before_woocommerce_init', 'oxygen_hpos_compatibility' );

/**
 * Register a custom WooCommerce email class.
 *
 * @param array $email_classes Email classes.
 * @return array
 */
function oxygen_register_custom_woocommerce_email_class( $email_classes ) {
	require_once OXYGEN_PLUGIN_DIR . 'inc/class-wc-email-invoice-email.php';
	$email_classes['WC_Email_Invoice_Email'] = new WC_Email_Invoice_Email();
	return $email_classes;
}
add_filter( 'woocommerce_email_classes', 'oxygen_register_custom_woocommerce_email_class' );

/**
 * Increase the timeout for external HTTP requests.
 *
 * @return int
 */
add_filter( 'http_request_timeout', 'oxygen_custom_timeout', 10, 2 );

function oxygen_custom_timeout( $timeout, $url ) {
	if ( strpos( $url, 'https://api.oxygen.gr/v1' ) !== false ||
	     strpos( $url, 'https://sandbox-api.oxygen.gr/v1' ) !== false ) {
		return 15;
	}
	return $timeout;
}