/**
 * Plugin Name: Oxygen MyData
 * Plugin URI: https://wordpress.org/plugins/oxygen-mydata/
 * Description: A WordPress plugin to connect WooCommerce with Oxygen Pelatologio and MyData
 * Author: Oxygen
 * Author URI: https://pelatologio.gr/
 * Text Domain: oxygen
 * Domain Path: /languages/
 * Version: 2.0.36
 * Requires at least: 5.5
 * Tested up to: 6.8.2
 * WC requires at least: 4.7
 * WC tested up to: 10.0.4
 * License: GPL2
 *
 * Oxygen MyData for WooCommerce is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Oxygen myData for WooCommerce. If not, see  https://www.gnu.org/licenses/gpl-2.0.html
 *
 * @package Oxygen
 * @version 2.0.36
 * @since  1.0.0
 */


var jsonData = {
    p: {
        1.1: { /* Ελλάδα */
            category1_1: [
                "E3_561_001",
                "E3_561_002",
                "E3_561_007"
            ],
            category1_2: [
                "E3_561_001",
                "E3_561_002",
                "E3_561_007"
            ],
            category1_3: [
                "E3_561_001",
                "E3_561_002",
                "E3_561_007"
            ]
        },
        1.2: { /* ενδοκοινοτικό */
            category1_1: [
                "E3_561_005",
                "E3_561_007"
            ],
            category1_2: [
                "E3_561_005",
                "E3_561_007"
            ],
            category1_3: [
                "E3_561_005",
                "E3_561_007"
            ]
        }
    },
    s: {
        2.1: { /* Ελλάδα */
            category1_3: [
                "E3_561_001",
                "E3_561_007"
            ]
        },
        2.2: { /* ενδοκοινοτικό */
            category1_3: [
                "E3_561_005",
                "E3_561_007"
            ]
        }
    },
    rp: {
        11.1: {
            category1_1: [
                "E3_561_003",
                "E3_561_004",
                "E3_561_005",
                "E3_561_006",
                "E3_561_007"
            ],
            category1_2: [
                "E3_561_003",
                "E3_561_004",
                "E3_561_005",
                "E3_561_006",
                "E3_561_007"
            ],
            category1_3: [
                "E3_561_003",
                "E3_561_004",
                "E3_561_005",
                "E3_561_006",
                "E3_561_007"
            ]
        }
    },
    rs: {
        11.2: {
            category1_3: [
                "E3_561_003",
                "E3_561_005",
                "E3_561_006",
                "E3_561_007"
            ]
        }
    }
};

var categories_names = {
    category1_1 : 'category1_1 - Έσοδα από Πώληση Εμπορευμάτων',
    category1_2 : 'category1_2 - Έσοδα από Πώληση Προϊόντων',
    category1_3 : 'category1_3 - Έσοδα από Παροχή Υπηρεσιών',
};

var types_names = {
    0 : 'Select type',
    E3_561_001 : 'E3_561_001 - Πωλήσεις αγαθών και υπηρεσιών Χονδρικές - Επιτηδευματιών',
    E3_561_002 : 'E3_561_002 - Πωλήσεις αγαθών και υπηρεσιών Χονδρικές βάσει άρθρου 39α παρ 5 του Κώδικα Φ.Π.Α. (Ν.2859/2000)',
    E3_561_003 : 'E3_561_003 - Πωλήσεις αγαθών και υπηρεσιών Λιανικές - Ιδιωτική Πελατεία',
    E3_561_004 : 'E3_561_004 - Πωλήσεις αγαθών και υπηρεσιών Λιανικές βάσει άρθρου 39α παρ 5 του Κώδικα Φ.Π.Α. (Ν.2859/2000)',
    E3_561_005 : 'E3_561_005 - Πωλήσεις αγαθών και υπηρεσιών Εξωτερικού Ενδοκοινοτικές',
    E3_561_006 : 'E3_561_006 - Πωλήσεις αγαθών και υπηρεσιών Εξωτερικού Τρίτες Χώρες',
    E3_561_007 : 'E3_561_007 - Πωλήσεις αγαθών και υπηρεσιών Λοιπά',
    E3_562     : 'E3_562 - Λοιπά συνήθη έσοδα',

};

var receipt_types_names ={
    0: 'Επιλέξτε τύπο εγγράφου για αποδείξεις',
    rp  : 'Απόδειξη πώλησης αγαθών (Απόδειξη Λιανικής πώλησης) - ΑΛΠ',
    rs   : 'Απόδειξη παροχής υπηρεσιών - ΑΠΥ',
}

var invoice_types_names ={
    0   : 'Επιλέξτε τύπο εγγράφου για τιμολόγια',
    s  : 'Τιμολόγιο Παροχής Υπηρεσιών - ΤΠΥ',
    p  : 'Τιμολόγιο Πώλησης - Δελτίο αποστολής - ΤΠΔΑ',
}

jQuery( document ).ready(

    function ( $ ) {


        var options = jsonData.s["2.2"]["category1_3"];
        $('#oxygen_endokoinotiko_classification_type_paroxis').empty();

        $.each(options, function (key, value) {
            $('#oxygen_endokoinotiko_classification_type_paroxis').append($("<option></option>").attr("value", value).text(types_names[value]));

        });

        $('#oxygen_endokoinotiko_invoice_category_paroxis').on('change', function () {

            var options = jsonData.s["2.2"]["category1_3"];
            $('#oxygen_endokoinotiko_classification_type_paroxis').empty();

            $.each(options, function (key, value) {
                $('#oxygen_endokoinotiko_classification_type_paroxis').append($("<option></option>").attr("value", value).text(types_names[value]));

            });

        });


        $('.mydata_category').on('change', function () {

            /*#oxygen_mydata_cat_rs_alp_product_panel,#oxygen_mydata_cat_rs_apy_product_panel,
            #oxygen_mydata_cat_rs_alp_product_panel_cat_taxonomy,#oxygen_mydata_cat_rs_apy_product_panel_cat_taxonomy*/
            let type_prefix = '_product_panel';
            let general_settings_cat = '';
            let general_settings_type = '';
            if($(this).hasClass('cat_taxonomy')){
                type_prefix = '_product_panel_cat_taxonomy';
            }else if($(this).hasClass('main')){
                type_prefix = '';
                general_settings_cat = 'oxygen_mydata_category_';
                general_settings_type = 'oxygen_mydata_classification_type_';

            }

            let value = $(this).val();
            let id = $(this).attr("id");
            console.log("id on change is " + id + value);

            /* these are the selecvtors that have to change */

            var selected_receipt_type = 'rp';

            let classification_type = '';

            if (id.includes('tpda') && !id.includes('tpda_intra')) {

                classification_type = general_settings_cat ? general_settings_type+'tpda' : 'oxygen_mydata_clas_type_tpda'+type_prefix;

                console.log(classification_type);

                switch ($(this).val()) {

                    case "category1_1" :

                        var options = jsonData.p["1.1"]["category1_1"];
                        $('#'+classification_type).empty();

                        $.each(options, function (key, value) {
                            $('#'+classification_type).append($("<option></option>").attr("value", value).text(types_names[value]));

                        });

                        break;

                    case "category1_2" :

                        var options = jsonData.p["1.1"]["category1_2"];
                        $('#'+classification_type).empty();

                        $.each(options, function (key, value) {
                            $('#'+classification_type).append($("<option></option>").attr("value", value).text(types_names[value]));

                        });
                        break;

                    case "category1_3" :

                        var options = jsonData.p["1.1"]["category1_3"];
                        $('#'+classification_type).empty();

                        $.each(options, function (key, value) {
                            $('#'+classification_type).append($("<option></option>").attr("value", value).text(types_names[value]));

                        });
                        break;

                    default:

                        var options = jsonData.p["1.1"]["category1_1"];
                        $('#'+classification_type).empty();

                        $.each(options, function (key, value) {
                            $('#'+classification_type).append($("<option></option>").attr("value", value).text(types_names[value]));

                        });
                        break;

                }
            }else if(id.includes('tpy') && !id.includes('tpy_intra')){
                classification_type = general_settings_cat ? general_settings_type+'tpy' : 'oxygen_mydata_clas_type_tpy'+type_prefix;

                switch ($(this).val()) {

                    case "category1_3" :

                        var options = jsonData.s["2.1"]["category1_3"];
                        $('#'+classification_type).empty();

                        $.each(options, function (key, value) {
                            $('#'+classification_type).append($("<option></option>").attr("value", value).text(types_names[value]));
                        });
                        break;
                    default: /* to idio me panw */

                        var options = jsonData.s["2.1"]["category1_3"];
                        $('#'+classification_type).empty();

                        $.each(options, function (key, value) {
                            $('#'+classification_type).append($("<option></option>").attr("value", value).text(types_names[value]));
                        });
                        break;

                }
            }else if(id.includes('alp') || id.includes('apy')){
                classification_type = general_settings_cat ? general_settings_type+'alp' : 'oxygen_mydata_clas_type_alp'+type_prefix;

                if(id.includes('apy')){
                    selected_receipt_type = 'rs';
                    classification_type = general_settings_cat ? general_settings_type+'apy' : 'oxygen_mydata_clas_type_apy'+type_prefix;
                }
                switch ($(this).val()) {

                    case "category1_1" :
                        console.log("category1_1 " + selected_receipt_type);

                        if (selected_receipt_type === 'rp') { /* ΑΛΠ */
                            var options = jsonData.rp["11.1"]["category1_1"];
                            $('#'+classification_type).empty();

                            console.log(options);
                            $.each(options, function (key, value) {
                                $('#'+classification_type).append($("<option></option>").attr("value", value).text(types_names[value]));

                            });
                        }

                        break;

                    case "category1_2" :
                        console.log("category1_2 " + selected_receipt_type);

                        if (selected_receipt_type === 'rp') { /* ΑΛΠ */
                            var options = jsonData.rp["11.1"]["category1_2"];
                            $('#'+classification_type).empty();
                            $.each(options, function (key, value) {
                                $('#'+classification_type).append($("<option></option>").attr("value", value).text(types_names[value]));
                            });
                        }

                        break;

                    case "category1_3" :
                        console.log("category1_3 " + selected_receipt_type);

                        if (selected_receipt_type === 'rp') { /* ΑΛΠ */
                            var options = jsonData.rp["11.1"]["category1_3"];
                            $('#'+classification_type).empty();
                            $.each(options, function (key, value) {
                                $('#'+classification_type).append($("<option></option>").attr("value", value).text(types_names[value]));
                            });
                        } else {
                            var options = jsonData.rs["11.2"]["category1_3"];
                            $('#'+classification_type).empty();
                            $.each(options, function (key, value) {
                                $('#'+classification_type).append($("<option></option>").attr("value", value).text(types_names[value]));
                            });
                        }


                        break;


                    default:

                        if(id.includes('alp')) {
                            var options = jsonData.rp["11.1"]["category1_1"];
                            $('#'+classification_type).empty();
                            $.each(options, function (key, value) {
                                $('#'+classification_type).append($("<option></option>").attr("value", value).text(types_names[value]));

                            });
                        }else{

                            var options = jsonData.rp["11.2"]["category1_3"];
                            $('#'+classification_type).empty();
                            $.each(options, function (key, value) {
                                $('#'+classification_type).append($("<option></option>").attr("value", value).text(types_names[value]));

                            });
                        }
                        break;

                }
            }else if(id.includes('tpda_intra')){

                classification_type = general_settings_cat ? general_settings_type+'tpda_intra' : 'oxygen_mydata_clas_type_tpda_intra'+type_prefix;

                console.log(classification_type+ " here ---");

                switch ($(this).val()) {

                    case "category1_1" :

                        var options = jsonData.p["1.2"]["category1_1"];
                        $('#'+classification_type).empty();

                        $.each(options, function (key, value) {
                            $('#'+classification_type).append($("<option></option>").attr("value", value).text(types_names[value]));

                        });

                        break;

                    case "category1_2" :

                        var options = jsonData.p["1.2"]["category1_2"];
                        $('#'+classification_type).empty();

                        $.each(options, function (key, value) {
                            $('#'+classification_type).append($("<option></option>").attr("value", value).text(types_names[value]));

                        });
                        break;

                    case "category1_3" :

                        var options = jsonData.p["1.2"]["category1_3"];
                        $('#'+classification_type).empty();

                        $.each(options, function (key, value) {
                            $('#'+classification_type).append($("<option></option>").attr("value", value).text(types_names[value]));

                        });
                        break;

                    default:

                        $.each(types_names, function (key, value) {
                            $('#'+classification_type).append($("<option></option>").attr("value", value).text(types_names[key]));

                        });
                        break;

                }

            }else{
                classification_type = general_settings_cat ? general_settings_type+'tpy_intra' :  'oxygen_mydata_clas_type_tpy_intra'+type_prefix;

                console.log(classification_type + " here");

                switch ($(this).val()) {

                    case "category1_3" :

                        var options = jsonData.s["2.1"]["category1_3"];
                        $('#'+classification_type).empty();

                        $.each(options, function (key, value) {
                            $('#'+classification_type).append($("<option></option>").attr("value", value).text(types_names[value]));
                        });
                        break;
                    default:

                        $.each(types_names, function (key, value) {
                            $('#'+classification_type).append($("<option></option>").attr("value", value).text(types_names[key]));
                        });
                        break;

                }
            }
        });


        if($('input#oxygen_self_fields').val() === 'yes'){

            $('select#oxygen_vat_metakey ,select#oxygen_working_field_metakey ,select#oxygen_tax_office , select#oxygen_issue_invoice_metakey').closest('tr').hide();
            console.log($( 'input#oxygen_self_fields' ).val());

        }else{
            $('select#oxygen_vat_metakey ,select#oxygen_working_field_metakey ,select#oxygen_tax_office , select#oxygen_issue_invoice_metakey').closest('tr').show();

        }



        $('.oxygen-toggle').on('click', function() {


            if($(this).val() === 'yes'){
                $(this).val('no');
                $(this).parent().removeClass('checked_toggle');
            }else{
                $(this).val('yes');
                $(this).parent().addClass('checked_toggle');
            }

            if ($(this).attr('id') === 'oxygen_self_fields') {
                const isSelfFieldYes = $('input#oxygen_self_fields').val() === 'yes';
                const $metaFields = $('select#oxygen_vat_metakey, select#oxygen_working_field_metakey, select#oxygen_tax_office, select#oxygen_issue_invoice_metakey').closest('tr');

                isSelfFieldYes ? $metaFields.hide() : $metaFields.show();
            }


        });


        $('#oxygen_default_document_type').on('change', function() {

            let value = $(this).val();

            let toggledGroups = {
                invoice: ["oxygen_default_invoice_type","oxygen_default_receipt_type","oxygen_default_intra_type"],
            };

            // Hide all elements first
            Object.values(toggledGroups).flat().forEach(id => {
                $('#' + id).closest('tr').hide();
            });

            // Show only the selected category
            if (toggledGroups[value]) {
                toggledGroups[value].forEach(id => {
                    $('#' + id).closest('tr').show();
                });
            }
        });

        let toggledGroups = {
            // receipt: ["oxygen_default_receipt_type"],
            // invoice: ["oxygen_default_invoice_type"],
            // intra: ["oxygen_default_intra_type"]
            invoice: ["oxygen_default_invoice_type","oxygen_default_receipt_type","oxygen_default_intra_type"],

        };
        // Hide all elements first
        let value = $('#oxygen_default_document_type').val();
        Object.values(toggledGroups).flat().forEach(id => {
            $('#' + id).closest('tr').hide();
        });

        if (toggledGroups[value]) {
            toggledGroups[value].forEach(id => {
                $('#' + id).closest('tr').show();
            });
        }

        /* SHIPPING DATA SETTINGS */

        $('#oxygen_other_move_purpose_title').closest('tr').hide();
        $('.oxygen-form-row input#_oxygen_other_move_purpose_title').parent().parent().hide();

        $('#oxygen_move_purpose').on('change', function() {

            if($(this).val() === "19"){
                $('#oxygen_other_move_purpose_title').closest('tr').show();
            }else{
                $('#oxygen_other_move_purpose_title').closest('tr').hide();
            }

        });

        $('#_oxygen_move_purpose').on('change', function() {

            if ($(this).val() === "19") {
                $('.oxygen-form-row input#_oxygen_other_move_purpose_title').parent().parent().show();
            } else {
                $('.oxygen-form-row input#_oxygen_other_move_purpose_title').parent().parent().hide();
            }
        });


        $( '#edit_shipping_data').on('click', function() {

            $('#shipping_box_data').toggle();
        });
    }

);

