<?php
/**
 * Email Header: Outputs the email heading and basic order information
 * (order number and date) for WooCommerce transactional emails.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/emails/email-order-header.php
 *
 * @package Oxygen
 * @version 2.0.36
 *
 * @param string   $email_heading Heading for the email.
 * @param WC_Order $order         WooCommerce order object.
 */

defined( 'ABSPATH' ) || exit;

?>

<?php echo esc_html( $email_heading ); ?>

<p><?php esc_html_e( 'Thank you for your order!', 'oxygen' ); ?></p>

<p>
	<?php esc_html_e( 'Order Number:', 'oxygen' ); ?>
	<?php echo esc_html( $order->get_order_number() ); ?>
</p>

<p>
	<?php esc_html_e( 'Order Date:', 'oxygen' ); ?>
	<?php echo esc_html( wc_format_datetime( $order->get_date_created() ) ); ?>
</p>
