<?php
/**
 * Summary Main Oxygen class to include more files, load translations and add settings link in plugin list.
 *
 * @package Oxygen
 * Oxygen MyData Class File
 *
 * @version 2.0.36
 * @since  1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Oxygen MyData Class
 */
class Oxygen {



	/**
	 * Singleton Instance of Oxygen
	 *
	 * @var Oxygen
	 **/
	private static $instance = null;


	/**
	 * Singleton init Function
	 *
	 * @static
	 */
	public static function init() {

		if ( ! self::$instance ) {
			self::$instance = new self();

		}
		return self::$instance;
	}

	/**
	 * Oxygen Constructor
	 */
	private function __construct() {

		$this->init_hooks();
	}

	/**
	 *  Requires files and hooks translations and settings link
	 *
	 *  @return void
	 */
	private function init_hooks() {

		require_once OXYGEN_PLUGIN_DIR . '/inc/class-oxygenhelperfunctions.php';
		OxygenHelperFunctions::init();

		require_once OXYGEN_PLUGIN_DIR . '/inc/class-oxygenapi.php';
		OxygenApi::init();

		require_once OXYGEN_PLUGIN_DIR . '/inc/class-oxygenwoosettings.php';
		OxygenWooSettings::init();

		require_once OXYGEN_PLUGIN_DIR . '/inc/class-oxygenorder.php';
		OxygenOrder::init();

		require_once OXYGEN_PLUGIN_DIR . '/inc/class-wc-oxygenpayment-gateway.php';

		add_action( 'init', array( $this, 'load_text_domain' ), 100 );
		add_filter( 'plugin_action_links_' . OXYGEN_PLUGIN_BASENAME, array( $this, 'add_plugin_page_settings_link' ) );

		add_action( 'wp_enqueue_scripts', array( $this, 'oxygen_load_scripts' ) );

		/* this is about checkout and oxygen settings oxygen payments - order status change */
		add_action( 'admin_enqueue_scripts', array( $this, 'oxygen_load_settings' ) );
	}

	/**
	 * Enqueue Oxygen JS
	 */
	public function oxygen_load_scripts() {

		wp_enqueue_script( 'oxygen_js', OXYGEN_PLUGIN_URL . 'js/oxygen.js', array(), null, true );

		wp_localize_script(
			'oxygen_js',
			'change_price_per_vat_action',
			array(
				'ajax_url' => admin_url( 'admin-ajax.php' ),
				'nonce'    => wp_create_nonce( 'change_price_per_vat_nonce' ),
			)
		);

		wp_localize_script(
			'oxygen_js',
			'restore_price_with_tax_action',
			array(
				'ajax_url' => admin_url( 'admin-ajax.php' ),
				'nonce'    => wp_create_nonce( 'restore_price_with_tax_nonce' ),
			)
		);

		wp_enqueue_style( 'oxygen_styles_css', OXYGEN_PLUGIN_URL . 'assets/css/oxygen_styles.css', array(), null );
		wp_enqueue_style( 'my_style_css', OXYGEN_PLUGIN_URL . 'assets/css/my_styles.css', array(), null );
	}

	/**
	 * Enqueue Oxygen Settings JS
	 */
	public function oxygen_load_settings() {
		wp_enqueue_script( 'oxygen_settings_js', OXYGEN_PLUGIN_URL . 'js/oxygen_settings.js', array(), null, true );
		wp_enqueue_script( 'create_document_meta_box_js', OXYGEN_PLUGIN_URL . 'js/create_document_meta_box.js', array(), null, true );
		wp_enqueue_style( 'oxygen_styles_css', OXYGEN_PLUGIN_URL . 'assets/css/oxygen_styles.css', array(), null );
		wp_enqueue_style( 'oxygen_css', OXYGEN_PLUGIN_URL . 'assets/css/oxygen.css', array(), null );

		/* Texts (translations) that changes with jquery */
		wp_localize_script(
			'create_document_meta_box_js',
			'MyLocalizedText',
			array(
				'createInvoiceText'   => __( 'Create Invoice', 'oxygen' ),
				'createReceiptText'   => __( 'Create Receipt', 'oxygen' ),
				'error_option'        => __( 'An error occurred while changing option.', 'oxygen' ),
				'gateway_disabled'    => __( 'The gateway has been disabled successfully.', 'oxygen' ),
				'success_send'        => __( 'Document sent successfully to customer\'s email address.', 'oxygen' ),
				'error_send'          => __( 'An error occurred while sending document via email.', 'oxygen' ),
				'success_download'    => __( 'PDF document downloaded successfully.', 'oxygen' ),
				'error_downloading'   => __( 'An error occurred while downloading the file.', 'oxygen' ),
				'empty_document_name' => __( 'Document has no name', 'oxygen' ),
			)
		);
	}


	/**
	 * Loads Translations
	 */
	public static function load_text_domain() {
		load_plugin_textdomain( 'oxygen', false, dirname( plugin_basename( OXYGEN_PLUGIN_FILE ) ) . '/languages' );
	}

	/**
	 *  Adds plugins list settings link
	 *
	 *  @param array $links array of existing plugins links.
	 *
	 *  @return array
	 */
	public static function add_plugin_page_settings_link( $links ) {
		$newlinks[] = '<a href="' .
			admin_url( 'admin.php?page=wc-settings&tab=oxygen' ) .
			'">' . __( 'Settings' ) . '</a>';
		return array_merge( $newlinks, $links );
	}
}
