<?php

declare(strict_types=1);

namespace TracingStruct;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for web_status TracingStruct
 * @package Iben_tracing
 * @subpackage Structs
 */
#[\AllowDynamicProperties]
class Iben_tracingWeb_status extends AbstractStructBase
{
    /**
     * The web_date
     * @var string|null
     */
    protected ?string $web_date = null;
    /**
     * The web_time
     * @var string|null
     */
    protected ?string $web_time = null;
    /**
     * The web_station
     * @var string|null
     */
    protected ?string $web_station = null;
    /**
     * The web_status_title
     * @var string|null
     */
    protected ?string $web_status_title = null;
    /**
     * Constructor method for web_status
     * @uses Iben_tracingWeb_status::setWeb_date()
     * @uses Iben_tracingWeb_status::setWeb_time()
     * @uses Iben_tracingWeb_status::setWeb_station()
     * @uses Iben_tracingWeb_status::setWeb_status_title()
     * @param string $web_date
     * @param string $web_time
     * @param string $web_station
     * @param string $web_status_title
     */
    public function __construct(?string $web_date = null, ?string $web_time = null, ?string $web_station = null, ?string $web_status_title = null)
    {
        $this
            ->setWeb_date($web_date)
            ->setWeb_time($web_time)
            ->setWeb_station($web_station)
            ->setWeb_status_title($web_status_title);
    }
    /**
     * Get web_date value
     * @return string|null
     */
    public function getWeb_date(): ?string
    {
        return $this->web_date;
    }
    /**
     * Set web_date value
     * @param string $web_date
     * @return \TracingStruct\Iben_tracingWeb_status
     */
    public function setWeb_date(?string $web_date = null): self
    {
        // validation for constraint: string
        if (!is_null($web_date) && !is_string($web_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($web_date, true), gettype($web_date)), __LINE__);
        }
        $this->web_date = $web_date;
        
        return $this;
    }
    /**
     * Get web_time value
     * @return string|null
     */
    public function getWeb_time(): ?string
    {
        return $this->web_time;
    }
    /**
     * Set web_time value
     * @param string $web_time
     * @return \TracingStruct\Iben_tracingWeb_status
     */
    public function setWeb_time(?string $web_time = null): self
    {
        // validation for constraint: string
        if (!is_null($web_time) && !is_string($web_time)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($web_time, true), gettype($web_time)), __LINE__);
        }
        $this->web_time = $web_time;
        
        return $this;
    }
    /**
     * Get web_station value
     * @return string|null
     */
    public function getWeb_station(): ?string
    {
        return $this->web_station;
    }
    /**
     * Set web_station value
     * @param string $web_station
     * @return \TracingStruct\Iben_tracingWeb_status
     */
    public function setWeb_station(?string $web_station = null): self
    {
        // validation for constraint: string
        if (!is_null($web_station) && !is_string($web_station)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($web_station, true), gettype($web_station)), __LINE__);
        }
        $this->web_station = $web_station;
        
        return $this;
    }
    /**
     * Get web_status_title value
     * @return string|null
     */
    public function getWeb_status_title(): ?string
    {
        return $this->web_status_title;
    }
    /**
     * Set web_status_title value
     * @param string $web_status_title
     * @return \TracingStruct\Iben_tracingWeb_status
     */
    public function setWeb_status_title(?string $web_status_title = null): self
    {
        // validation for constraint: string
        if (!is_null($web_status_title) && !is_string($web_status_title)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($web_status_title, true), gettype($web_status_title)), __LINE__);
        }
        $this->web_status_title = $web_status_title;
        
        return $this;
    }
}
