<?php

declare(strict_types=1);

namespace TracingStruct;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for READResponse TracingStruct
 * @package Iben_tracing
 * @subpackage Structs
 */
#[\AllowDynamicProperties]
class Iben_tracingREADResponse extends AbstractStructBase
{
    /**
     * The st_flag
     * @var int|null
     */
    protected ?int $st_flag = null;
    /**
     * The st_title
     * @var string|null
     */
    protected ?string $st_title = null;
    /**
     * The pod_date
     * @var string|null
     */
    protected ?string $pod_date = null;
    /**
     * The pod_time
     * @var string|null
     */
    protected ?string $pod_time = null;
    /**
     * The pod_name
     * @var string|null
     */
    protected ?string $pod_name = null;
    /**
     * The web_status
     * Meta information extracted from the WSDL
     * - maxOccurs: 100
     * - minOccurs: 0
     * @var \TracingStruct\Iben_tracingWeb_status[]
     */
    protected ?array $web_status = null;
    /**
     * The web_status_counter
     * @var int|null
     */
    protected ?int $web_status_counter = null;
    /**
     * Constructor method for READResponse
     * @uses Iben_tracingREADResponse::setSt_flag()
     * @uses Iben_tracingREADResponse::setSt_title()
     * @uses Iben_tracingREADResponse::setPod_date()
     * @uses Iben_tracingREADResponse::setPod_time()
     * @uses Iben_tracingREADResponse::setPod_name()
     * @uses Iben_tracingREADResponse::setWeb_status()
     * @uses Iben_tracingREADResponse::setWeb_status_counter()
     * @param int $st_flag
     * @param string $st_title
     * @param string $pod_date
     * @param string $pod_time
     * @param string $pod_name
     * @param \TracingStruct\Iben_tracingWeb_status[] $web_status
     * @param int $web_status_counter
     */
    public function __construct(?int $st_flag = null, ?string $st_title = null, ?string $pod_date = null, ?string $pod_time = null, ?string $pod_name = null, ?array $web_status = null, ?int $web_status_counter = null)
    {
        $this
            ->setSt_flag($st_flag)
            ->setSt_title($st_title)
            ->setPod_date($pod_date)
            ->setPod_time($pod_time)
            ->setPod_name($pod_name)
            ->setWeb_status($web_status)
            ->setWeb_status_counter($web_status_counter);
    }
    /**
     * Get st_flag value
     * @return int|null
     */
    public function getSt_flag(): ?int
    {
        return $this->st_flag;
    }
    /**
     * Set st_flag value
     * @param int $st_flag
     * @return \TracingStruct\Iben_tracingREADResponse
     */
    public function setSt_flag(?int $st_flag = null): self
    {
        // validation for constraint: int
        if (!is_null($st_flag) && !(is_int($st_flag) || ctype_digit($st_flag))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($st_flag, true), gettype($st_flag)), __LINE__);
        }
        $this->st_flag = $st_flag;
        
        return $this;
    }
    /**
     * Get st_title value
     * @return string|null
     */
    public function getSt_title(): ?string
    {
        return $this->st_title;
    }
    /**
     * Set st_title value
     * @param string $st_title
     * @return \TracingStruct\Iben_tracingREADResponse
     */
    public function setSt_title(?string $st_title = null): self
    {
        // validation for constraint: string
        if (!is_null($st_title) && !is_string($st_title)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($st_title, true), gettype($st_title)), __LINE__);
        }
        $this->st_title = $st_title;
        
        return $this;
    }
    /**
     * Get pod_date value
     * @return string|null
     */
    public function getPod_date(): ?string
    {
        return $this->pod_date;
    }
    /**
     * Set pod_date value
     * @param string $pod_date
     * @return \TracingStruct\Iben_tracingREADResponse
     */
    public function setPod_date(?string $pod_date = null): self
    {
        // validation for constraint: string
        if (!is_null($pod_date) && !is_string($pod_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pod_date, true), gettype($pod_date)), __LINE__);
        }
        $this->pod_date = $pod_date;
        
        return $this;
    }
    /**
     * Get pod_time value
     * @return string|null
     */
    public function getPod_time(): ?string
    {
        return $this->pod_time;
    }
    /**
     * Set pod_time value
     * @param string $pod_time
     * @return \TracingStruct\Iben_tracingREADResponse
     */
    public function setPod_time(?string $pod_time = null): self
    {
        // validation for constraint: string
        if (!is_null($pod_time) && !is_string($pod_time)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pod_time, true), gettype($pod_time)), __LINE__);
        }
        $this->pod_time = $pod_time;
        
        return $this;
    }
    /**
     * Get pod_name value
     * @return string|null
     */
    public function getPod_name(): ?string
    {
        return $this->pod_name;
    }
    /**
     * Set pod_name value
     * @param string $pod_name
     * @return \TracingStruct\Iben_tracingREADResponse
     */
    public function setPod_name(?string $pod_name = null): self
    {
        // validation for constraint: string
        if (!is_null($pod_name) && !is_string($pod_name)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pod_name, true), gettype($pod_name)), __LINE__);
        }
        $this->pod_name = $pod_name;
        
        return $this;
    }
    /**
     * Get web_status value
     * @return \TracingStruct\Iben_tracingWeb_status[]
     */
    public function getWeb_status(): ?array
    {
        return $this->web_status;
    }
    /**
     * This method is responsible for validating the value(s) passed to the setWeb_status method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWeb_status method
     * This has to validate that each item contained by the array match the itemType constraint
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWeb_statusForArrayConstraintFromSetWeb_status(?array $values = []): string
    {
        if (!is_array($values)) {
            return '';
        }
        $message = '';
        $invalidValues = [];
        foreach ($values as $rEADResponseWeb_statusItem) {
            // validation for constraint: itemType
            if (!$rEADResponseWeb_statusItem instanceof \TracingStruct\Iben_tracingWeb_status) {
                $invalidValues[] = is_object($rEADResponseWeb_statusItem) ? get_class($rEADResponseWeb_statusItem) : sprintf('%s(%s)', gettype($rEADResponseWeb_statusItem), var_export($rEADResponseWeb_statusItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The web_status property can only contain items of type \TracingStruct\Iben_tracingWeb_status, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        
        return $message;
    }
    /**
     * Set web_status value
     * @throws InvalidArgumentException
     * @param \TracingStruct\Iben_tracingWeb_status[] $web_status
     * @return \TracingStruct\Iben_tracingREADResponse
     */
    public function setWeb_status(?array $web_status = null): self
    {
        // validation for constraint: array
        if ('' !== ($web_statusArrayErrorMessage = self::validateWeb_statusForArrayConstraintFromSetWeb_status($web_status))) {
            throw new InvalidArgumentException($web_statusArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(100)
        if (is_array($web_status) && count($web_status) > 100) {
            throw new InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 100', count($web_status)), __LINE__);
        }
        $this->web_status = $web_status;
        
        return $this;
    }
    /**
     * Add item to web_status value
     * @throws InvalidArgumentException
     * @param \TracingStruct\Iben_tracingWeb_status $item
     * @return \TracingStruct\Iben_tracingREADResponse
     */
    public function addToWeb_status(\TracingStruct\Iben_tracingWeb_status $item): self
    {
        // validation for constraint: itemType
        if (!$item instanceof \TracingStruct\Iben_tracingWeb_status) {
            throw new InvalidArgumentException(sprintf('The web_status property can only contain items of type \TracingStruct\Iben_tracingWeb_status, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(100)
        if (is_array($this->web_status) && count($this->web_status) >= 100) {
            throw new InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 100', count($this->web_status)), __LINE__);
        }
        $this->web_status[] = $item;
        
        return $this;
    }
    /**
     * Get web_status_counter value
     * @return int|null
     */
    public function getWeb_status_counter(): ?int
    {
        return $this->web_status_counter;
    }
    /**
     * Set web_status_counter value
     * @param int $web_status_counter
     * @return \TracingStruct\Iben_tracingREADResponse
     */
    public function setWeb_status_counter(?int $web_status_counter = null): self
    {
        // validation for constraint: int
        if (!is_null($web_status_counter) && !(is_int($web_status_counter) || ctype_digit($web_status_counter))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($web_status_counter, true), gettype($web_status_counter)), __LINE__);
        }
        $this->web_status_counter = $web_status_counter;
        
        return $this;
    }
}
