<?php

declare(strict_types=1);

namespace TracingStruct;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for READ TracingStruct
 * @package Iben_tracing
 * @subpackage Structs
 */
#[\AllowDynamicProperties]
class Iben_tracingREAD extends AbstractStructBase
{
    /**
     * The wpel_code
     * @var string|null
     */
    protected ?string $wpel_code = null;
    /**
     * The wpel_user
     * @var int|null
     */
    protected ?int $wpel_user = null;
    /**
     * The wpel_pass
     * @var string|null
     */
    protected ?string $wpel_pass = null;
    /**
     * The wpel_vg
     * @var string|null
     */
    protected ?string $wpel_vg = null;
    /**
     * The wpel_ref
     * @var string|null
     */
    protected ?string $wpel_ref = null;
    /**
     * The wpel_flag
     * @var string|null
     */
    protected ?string $wpel_flag = null;
    /**
     * Constructor method for READ
     * @uses Iben_tracingREAD::setWpel_code()
     * @uses Iben_tracingREAD::setWpel_user()
     * @uses Iben_tracingREAD::setWpel_pass()
     * @uses Iben_tracingREAD::setWpel_vg()
     * @uses Iben_tracingREAD::setWpel_ref()
     * @uses Iben_tracingREAD::setWpel_flag()
     * @param string $wpel_code
     * @param int $wpel_user
     * @param string $wpel_pass
     * @param string $wpel_vg
     * @param string $wpel_ref
     * @param string $wpel_flag
     */
    public function __construct(?string $wpel_code = null, ?int $wpel_user = null, ?string $wpel_pass = null, ?string $wpel_vg = null, ?string $wpel_ref = null, ?string $wpel_flag = null)
    {
        $this
            ->setWpel_code($wpel_code)
            ->setWpel_user($wpel_user)
            ->setWpel_pass($wpel_pass)
            ->setWpel_vg($wpel_vg)
            ->setWpel_ref($wpel_ref)
            ->setWpel_flag($wpel_flag);
    }
    /**
     * Get wpel_code value
     * @return string|null
     */
    public function getWpel_code(): ?string
    {
        return $this->wpel_code;
    }
    /**
     * Set wpel_code value
     * @param string $wpel_code
     * @return \TracingStruct\Iben_tracingREAD
     */
    public function setWpel_code(?string $wpel_code = null): self
    {
        // validation for constraint: string
        if (!is_null($wpel_code) && !is_string($wpel_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wpel_code, true), gettype($wpel_code)), __LINE__);
        }
        $this->wpel_code = $wpel_code;
        
        return $this;
    }
    /**
     * Get wpel_user value
     * @return int|null
     */
    public function getWpel_user(): ?int
    {
        return $this->wpel_user;
    }
    /**
     * Set wpel_user value
     * @param int $wpel_user
     * @return \TracingStruct\Iben_tracingREAD
     */
    public function setWpel_user(?int $wpel_user = null): self
    {
        // validation for constraint: int
        if (!is_null($wpel_user) && !(is_int($wpel_user) || ctype_digit($wpel_user))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($wpel_user, true), gettype($wpel_user)), __LINE__);
        }
        $this->wpel_user = $wpel_user;
        
        return $this;
    }
    /**
     * Get wpel_pass value
     * @return string|null
     */
    public function getWpel_pass(): ?string
    {
        return $this->wpel_pass;
    }
    /**
     * Set wpel_pass value
     * @param string $wpel_pass
     * @return \TracingStruct\Iben_tracingREAD
     */
    public function setWpel_pass(?string $wpel_pass = null): self
    {
        // validation for constraint: string
        if (!is_null($wpel_pass) && !is_string($wpel_pass)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wpel_pass, true), gettype($wpel_pass)), __LINE__);
        }
        $this->wpel_pass = $wpel_pass;
        
        return $this;
    }
    /**
     * Get wpel_vg value
     * @return string|null
     */
    public function getWpel_vg(): ?string
    {
        return $this->wpel_vg;
    }
    /**
     * Set wpel_vg value
     * @param string $wpel_vg
     * @return \TracingStruct\Iben_tracingREAD
     */
    public function setWpel_vg(?string $wpel_vg = null): self
    {
        // validation for constraint: string
        if (!is_null($wpel_vg) && !is_string($wpel_vg)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wpel_vg, true), gettype($wpel_vg)), __LINE__);
        }
        $this->wpel_vg = $wpel_vg;
        
        return $this;
    }
    /**
     * Get wpel_ref value
     * @return string|null
     */
    public function getWpel_ref(): ?string
    {
        return $this->wpel_ref;
    }
    /**
     * Set wpel_ref value
     * @param string $wpel_ref
     * @return \TracingStruct\Iben_tracingREAD
     */
    public function setWpel_ref(?string $wpel_ref = null): self
    {
        // validation for constraint: string
        if (!is_null($wpel_ref) && !is_string($wpel_ref)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wpel_ref, true), gettype($wpel_ref)), __LINE__);
        }
        $this->wpel_ref = $wpel_ref;
        
        return $this;
    }
    /**
     * Get wpel_flag value
     * @return string|null
     */
    public function getWpel_flag(): ?string
    {
        return $this->wpel_flag;
    }
    /**
     * Set wpel_flag value
     * @param string $wpel_flag
     * @return \TracingStruct\Iben_tracingREAD
     */
    public function setWpel_flag(?string $wpel_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($wpel_flag) && !is_string($wpel_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wpel_flag, true), gettype($wpel_flag)), __LINE__);
        }
        $this->wpel_flag = $wpel_flag;
        
        return $this;
    }
}
