<?php

declare(strict_types=1);

namespace TracingService;

use SoapFault;
use WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for READ TracingService
 * @package Iben_tracing
 * @subpackage Services
 */
class Iben_tracingREAD extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named READ
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TracingStruct\Iben_tracingREAD $parameters
     * @return \TracingStruct\Iben_tracingREADResponse|bool
     */
    public function READ(\TracingStruct\Iben_tracingREAD $parameters)
    {
        try {
            $this->setResult($resultREAD = $this->getSoapClient()->__soapCall('READ', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultREAD;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \TracingStruct\Iben_tracingREADResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
