<?php

declare(strict_types=1);

namespace StationStruct;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for READResponse StationStruct
 * @package Iben_station
 * @subpackage Structs
 */
#[\AllowDynamicProperties]
class Iben_stationREADResponse extends AbstractStructBase
{
    /**
     * The web_code
     * @var string|null
     */
    protected ?string $web_code = null;
    /**
     * The web_company
     * @var string|null
     */
    protected ?string $web_company = null;
    /**
     * The web_title
     * @var string|null
     */
    protected ?string $web_title = null;
    /**
     * The web_address
     * @var string|null
     */
    protected ?string $web_address = null;
    /**
     * The web_area
     * @var string|null
     */
    protected ?string $web_area = null;
    /**
     * The web_wrario
     * @var string|null
     */
    protected ?string $web_wrario = null;
    /**
     * The web_tel1
     * @var string|null
     */
    protected ?string $web_tel1 = null;
    /**
     * The web_fax
     * @var string|null
     */
    protected ?string $web_fax = null;
    /**
     * The web_x
     * @var string|null
     */
    protected ?string $web_x = null;
    /**
     * The web_y
     * @var string|null
     */
    protected ?string $web_y = null;
    /**
     * The st_flag
     * @var int|null
     */
    protected ?int $st_flag = null;
    /**
     * The st_title
     * @var string|null
     */
    protected ?string $st_title = null;
    /**
     * Constructor method for READResponse
     * @uses Iben_stationREADResponse::setWeb_code()
     * @uses Iben_stationREADResponse::setWeb_company()
     * @uses Iben_stationREADResponse::setWeb_title()
     * @uses Iben_stationREADResponse::setWeb_address()
     * @uses Iben_stationREADResponse::setWeb_area()
     * @uses Iben_stationREADResponse::setWeb_wrario()
     * @uses Iben_stationREADResponse::setWeb_tel1()
     * @uses Iben_stationREADResponse::setWeb_fax()
     * @uses Iben_stationREADResponse::setWeb_x()
     * @uses Iben_stationREADResponse::setWeb_y()
     * @uses Iben_stationREADResponse::setSt_flag()
     * @uses Iben_stationREADResponse::setSt_title()
     * @param string $web_code
     * @param string $web_company
     * @param string $web_title
     * @param string $web_address
     * @param string $web_area
     * @param string $web_wrario
     * @param string $web_tel1
     * @param string $web_fax
     * @param string $web_x
     * @param string $web_y
     * @param int $st_flag
     * @param string $st_title
     */
    public function __construct(?string $web_code = null, ?string $web_company = null, ?string $web_title = null, ?string $web_address = null, ?string $web_area = null, ?string $web_wrario = null, ?string $web_tel1 = null, ?string $web_fax = null, ?string $web_x = null, ?string $web_y = null, ?int $st_flag = null, ?string $st_title = null)
    {
        $this
            ->setWeb_code($web_code)
            ->setWeb_company($web_company)
            ->setWeb_title($web_title)
            ->setWeb_address($web_address)
            ->setWeb_area($web_area)
            ->setWeb_wrario($web_wrario)
            ->setWeb_tel1($web_tel1)
            ->setWeb_fax($web_fax)
            ->setWeb_x($web_x)
            ->setWeb_y($web_y)
            ->setSt_flag($st_flag)
            ->setSt_title($st_title);
    }
    /**
     * Get web_code value
     * @return string|null
     */
    public function getWeb_code(): ?string
    {
        return $this->web_code;
    }
    /**
     * Set web_code value
     * @param string $web_code
     * @return \StationStruct\Iben_stationREADResponse
     */
    public function setWeb_code(?string $web_code = null): self
    {
        // validation for constraint: string
        if (!is_null($web_code) && !is_string($web_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($web_code, true), gettype($web_code)), __LINE__);
        }
        $this->web_code = $web_code;
        
        return $this;
    }
    /**
     * Get web_company value
     * @return string|null
     */
    public function getWeb_company(): ?string
    {
        return $this->web_company;
    }
    /**
     * Set web_company value
     * @param string $web_company
     * @return \StationStruct\Iben_stationREADResponse
     */
    public function setWeb_company(?string $web_company = null): self
    {
        // validation for constraint: string
        if (!is_null($web_company) && !is_string($web_company)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($web_company, true), gettype($web_company)), __LINE__);
        }
        $this->web_company = $web_company;
        
        return $this;
    }
    /**
     * Get web_title value
     * @return string|null
     */
    public function getWeb_title(): ?string
    {
        return $this->web_title;
    }
    /**
     * Set web_title value
     * @param string $web_title
     * @return \StationStruct\Iben_stationREADResponse
     */
    public function setWeb_title(?string $web_title = null): self
    {
        // validation for constraint: string
        if (!is_null($web_title) && !is_string($web_title)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($web_title, true), gettype($web_title)), __LINE__);
        }
        $this->web_title = $web_title;
        
        return $this;
    }
    /**
     * Get web_address value
     * @return string|null
     */
    public function getWeb_address(): ?string
    {
        return $this->web_address;
    }
    /**
     * Set web_address value
     * @param string $web_address
     * @return \StationStruct\Iben_stationREADResponse
     */
    public function setWeb_address(?string $web_address = null): self
    {
        // validation for constraint: string
        if (!is_null($web_address) && !is_string($web_address)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($web_address, true), gettype($web_address)), __LINE__);
        }
        $this->web_address = $web_address;
        
        return $this;
    }
    /**
     * Get web_area value
     * @return string|null
     */
    public function getWeb_area(): ?string
    {
        return $this->web_area;
    }
    /**
     * Set web_area value
     * @param string $web_area
     * @return \StationStruct\Iben_stationREADResponse
     */
    public function setWeb_area(?string $web_area = null): self
    {
        // validation for constraint: string
        if (!is_null($web_area) && !is_string($web_area)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($web_area, true), gettype($web_area)), __LINE__);
        }
        $this->web_area = $web_area;
        
        return $this;
    }
    /**
     * Get web_wrario value
     * @return string|null
     */
    public function getWeb_wrario(): ?string
    {
        return $this->web_wrario;
    }
    /**
     * Set web_wrario value
     * @param string $web_wrario
     * @return \StationStruct\Iben_stationREADResponse
     */
    public function setWeb_wrario(?string $web_wrario = null): self
    {
        // validation for constraint: string
        if (!is_null($web_wrario) && !is_string($web_wrario)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($web_wrario, true), gettype($web_wrario)), __LINE__);
        }
        $this->web_wrario = $web_wrario;
        
        return $this;
    }
    /**
     * Get web_tel1 value
     * @return string|null
     */
    public function getWeb_tel1(): ?string
    {
        return $this->web_tel1;
    }
    /**
     * Set web_tel1 value
     * @param string $web_tel1
     * @return \StationStruct\Iben_stationREADResponse
     */
    public function setWeb_tel1(?string $web_tel1 = null): self
    {
        // validation for constraint: string
        if (!is_null($web_tel1) && !is_string($web_tel1)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($web_tel1, true), gettype($web_tel1)), __LINE__);
        }
        $this->web_tel1 = $web_tel1;
        
        return $this;
    }
    /**
     * Get web_fax value
     * @return string|null
     */
    public function getWeb_fax(): ?string
    {
        return $this->web_fax;
    }
    /**
     * Set web_fax value
     * @param string $web_fax
     * @return \StationStruct\Iben_stationREADResponse
     */
    public function setWeb_fax(?string $web_fax = null): self
    {
        // validation for constraint: string
        if (!is_null($web_fax) && !is_string($web_fax)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($web_fax, true), gettype($web_fax)), __LINE__);
        }
        $this->web_fax = $web_fax;
        
        return $this;
    }
    /**
     * Get web_x value
     * @return string|null
     */
    public function getWeb_x(): ?string
    {
        return $this->web_x;
    }
    /**
     * Set web_x value
     * @param string $web_x
     * @return \StationStruct\Iben_stationREADResponse
     */
    public function setWeb_x(?string $web_x = null): self
    {
        // validation for constraint: string
        if (!is_null($web_x) && !is_string($web_x)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($web_x, true), gettype($web_x)), __LINE__);
        }
        $this->web_x = $web_x;
        
        return $this;
    }
    /**
     * Get web_y value
     * @return string|null
     */
    public function getWeb_y(): ?string
    {
        return $this->web_y;
    }
    /**
     * Set web_y value
     * @param string $web_y
     * @return \StationStruct\Iben_stationREADResponse
     */
    public function setWeb_y(?string $web_y = null): self
    {
        // validation for constraint: string
        if (!is_null($web_y) && !is_string($web_y)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($web_y, true), gettype($web_y)), __LINE__);
        }
        $this->web_y = $web_y;
        
        return $this;
    }
    /**
     * Get st_flag value
     * @return int|null
     */
    public function getSt_flag(): ?int
    {
        return $this->st_flag;
    }
    /**
     * Set st_flag value
     * @param int $st_flag
     * @return \StationStruct\Iben_stationREADResponse
     */
    public function setSt_flag(?int $st_flag = null): self
    {
        // validation for constraint: int
        if (!is_null($st_flag) && !(is_int($st_flag) || ctype_digit($st_flag))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($st_flag, true), gettype($st_flag)), __LINE__);
        }
        $this->st_flag = $st_flag;
        
        return $this;
    }
    /**
     * Get st_title value
     * @return string|null
     */
    public function getSt_title(): ?string
    {
        return $this->st_title;
    }
    /**
     * Set st_title value
     * @param string $st_title
     * @return \StationStruct\Iben_stationREADResponse
     */
    public function setSt_title(?string $st_title = null): self
    {
        // validation for constraint: string
        if (!is_null($st_title) && !is_string($st_title)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($st_title, true), gettype($st_title)), __LINE__);
        }
        $this->st_title = $st_title;
        
        return $this;
    }
}
