<?php

declare(strict_types=1);

namespace StationStruct;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for READ StationStruct
 * @package Iben_station
 * @subpackage Structs
 */
#[\AllowDynamicProperties]
class Iben_stationREAD extends AbstractStructBase
{
    /**
     * The web_tk
     * @var string|null
     */
    protected ?string $web_tk = null;
    /**
     * Constructor method for READ
     * @uses Iben_stationREAD::setWeb_tk()
     * @param string $web_tk
     */
    public function __construct(?string $web_tk = null)
    {
        $this
            ->setWeb_tk($web_tk);
    }
    /**
     * Get web_tk value
     * @return string|null
     */
    public function getWeb_tk(): ?string
    {
        return $this->web_tk;
    }
    /**
     * Set web_tk value
     * @param string $web_tk
     * @return \StationStruct\Iben_stationREAD
     */
    public function setWeb_tk(?string $web_tk = null): self
    {
        // validation for constraint: string
        if (!is_null($web_tk) && !is_string($web_tk)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($web_tk, true), gettype($web_tk)), __LINE__);
        }
        $this->web_tk = $web_tk;
        
        return $this;
    }
}
