<?php

declare(strict_types=1);

namespace StationService;

use SoapFault;
use WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for READ StationService
 * @package Iben_station
 * @subpackage Services
 */
class Iben_stationREAD extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named READ
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StationStruct\Iben_stationREAD $parameters
     * @return \StationStruct\Iben_stationREADResponse|bool
     */
    public function READ(\StationStruct\Iben_stationREAD $parameters)
    {
        try {
            $this->setResult($resultREAD = $this->getSoapClient()->__soapCall('READ', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultREAD;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StationStruct\Iben_stationREADResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
