<?php

declare(strict_types=1);

namespace PrintStruct;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for READResponse PrintStruct
 * @package Iben_print
 * @subpackage Structs
 */
#[\AllowDynamicProperties]
class Iben_printREADResponse extends AbstractStructBase
{
    /**
     * The st_flag
     * @var int|null
     */
    protected ?int $st_flag = null;
    /**
     * The st_title
     * @var string|null
     */
    protected ?string $st_title = null;
    /**
     * The b64_string
     * @var string|null
     */
    protected ?string $b64_string = null;
    /**
     * Constructor method for READResponse
     * @uses Iben_printREADResponse::setSt_flag()
     * @uses Iben_printREADResponse::setSt_title()
     * @uses Iben_printREADResponse::setB64_string()
     * @param int $st_flag
     * @param string $st_title
     * @param string $b64_string
     */
    public function __construct(?int $st_flag = null, ?string $st_title = null, ?string $b64_string = null)
    {
        $this
            ->setSt_flag($st_flag)
            ->setSt_title($st_title)
            ->setB64_string($b64_string);
    }
    /**
     * Get st_flag value
     * @return int|null
     */
    public function getSt_flag(): ?int
    {
        return $this->st_flag;
    }
    /**
     * Set st_flag value
     * @param int $st_flag
     * @return \PrintStruct\Iben_printREADResponse
     */
    public function setSt_flag(?int $st_flag = null): self
    {
        // validation for constraint: int
        if (!is_null($st_flag) && !(is_int($st_flag) || ctype_digit($st_flag))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($st_flag, true), gettype($st_flag)), __LINE__);
        }
        $this->st_flag = $st_flag;
        
        return $this;
    }
    /**
     * Get st_title value
     * @return string|null
     */
    public function getSt_title(): ?string
    {
        return $this->st_title;
    }
    /**
     * Set st_title value
     * @param string $st_title
     * @return \PrintStruct\Iben_printREADResponse
     */
    public function setSt_title(?string $st_title = null): self
    {
        // validation for constraint: string
        if (!is_null($st_title) && !is_string($st_title)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($st_title, true), gettype($st_title)), __LINE__);
        }
        $this->st_title = $st_title;
        
        return $this;
    }
    /**
     * Get b64_string value
     * @return string|null
     */
    public function getB64_string(): ?string
    {
        return $this->b64_string;
    }
    /**
     * Set b64_string value
     * @param string $b64_string
     * @return \PrintStruct\Iben_printREADResponse
     */
    public function setB64_string(?string $b64_string = null): self
    {
        // validation for constraint: string
        if (!is_null($b64_string) && !is_string($b64_string)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($b64_string, true), gettype($b64_string)), __LINE__);
        }
        $this->b64_string = $b64_string;
        
        return $this;
    }
}
