<?php

declare(strict_types=1);

namespace CreateStruct;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for READResponse CreateStruct
 * @package Iben_create
 * @subpackage Structs
 */
#[\AllowDynamicProperties]
class Iben_createREADResponse extends AbstractStructBase
{
    /**
     * The st_flag
     * @var int|null
     */
    protected ?int $st_flag = null;
    /**
     * The st_title
     * @var string|null
     */
    protected ?string $st_title = null;
    /**
     * The vg_code
     * @var string|null
     */
    protected ?string $vg_code = null;
    /**
     * The return_vg
     * @var string|null
     */
    protected ?string $return_vg = null;
    /**
     * The epitagh_vg
     * @var string|null
     */
    protected ?string $epitagh_vg = null;
    /**
     * The vg_child
     * Meta information extracted from the WSDL
     * - maxOccurs: 35
     * - minOccurs: 0
     * @var string[]
     */
    protected ?array $vg_child = null;
    /**
     * Constructor method for READResponse
     * @uses Iben_createREADResponse::setSt_flag()
     * @uses Iben_createREADResponse::setSt_title()
     * @uses Iben_createREADResponse::setVg_code()
     * @uses Iben_createREADResponse::setReturn_vg()
     * @uses Iben_createREADResponse::setEpitagh_vg()
     * @uses Iben_createREADResponse::setVg_child()
     * @param int $st_flag
     * @param string $st_title
     * @param string $vg_code
     * @param string $return_vg
     * @param string $epitagh_vg
     * @param string[] $vg_child
     */
    public function __construct(?int $st_flag = null, ?string $st_title = null, ?string $vg_code = null, ?string $return_vg = null, ?string $epitagh_vg = null, ?array $vg_child = null)
    {
        $this
            ->setSt_flag($st_flag)
            ->setSt_title($st_title)
            ->setVg_code($vg_code)
            ->setReturn_vg($return_vg)
            ->setEpitagh_vg($epitagh_vg)
            ->setVg_child($vg_child);
    }
    /**
     * Get st_flag value
     * @return int|null
     */
    public function getSt_flag(): ?int
    {
        return $this->st_flag;
    }
    /**
     * Set st_flag value
     * @param int $st_flag
     * @return \CreateStruct\Iben_createREADResponse
     */
    public function setSt_flag(?int $st_flag = null): self
    {
        // validation for constraint: int
        if (!is_null($st_flag) && !(is_int($st_flag) || ctype_digit($st_flag))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($st_flag, true), gettype($st_flag)), __LINE__);
        }
        $this->st_flag = $st_flag;
        
        return $this;
    }
    /**
     * Get st_title value
     * @return string|null
     */
    public function getSt_title(): ?string
    {
        return $this->st_title;
    }
    /**
     * Set st_title value
     * @param string $st_title
     * @return \CreateStruct\Iben_createREADResponse
     */
    public function setSt_title(?string $st_title = null): self
    {
        // validation for constraint: string
        if (!is_null($st_title) && !is_string($st_title)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($st_title, true), gettype($st_title)), __LINE__);
        }
        $this->st_title = $st_title;
        
        return $this;
    }
    /**
     * Get vg_code value
     * @return string|null
     */
    public function getVg_code(): ?string
    {
        return $this->vg_code;
    }
    /**
     * Set vg_code value
     * @param string $vg_code
     * @return \CreateStruct\Iben_createREADResponse
     */
    public function setVg_code(?string $vg_code = null): self
    {
        // validation for constraint: string
        if (!is_null($vg_code) && !is_string($vg_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vg_code, true), gettype($vg_code)), __LINE__);
        }
        $this->vg_code = $vg_code;
        
        return $this;
    }
    /**
     * Get return_vg value
     * @return string|null
     */
    public function getReturn_vg(): ?string
    {
        return $this->return_vg;
    }
    /**
     * Set return_vg value
     * @param string $return_vg
     * @return \CreateStruct\Iben_createREADResponse
     */
    public function setReturn_vg(?string $return_vg = null): self
    {
        // validation for constraint: string
        if (!is_null($return_vg) && !is_string($return_vg)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($return_vg, true), gettype($return_vg)), __LINE__);
        }
        $this->return_vg = $return_vg;
        
        return $this;
    }
    /**
     * Get epitagh_vg value
     * @return string|null
     */
    public function getEpitagh_vg(): ?string
    {
        return $this->epitagh_vg;
    }
    /**
     * Set epitagh_vg value
     * @param string $epitagh_vg
     * @return \CreateStruct\Iben_createREADResponse
     */
    public function setEpitagh_vg(?string $epitagh_vg = null): self
    {
        // validation for constraint: string
        if (!is_null($epitagh_vg) && !is_string($epitagh_vg)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($epitagh_vg, true), gettype($epitagh_vg)), __LINE__);
        }
        $this->epitagh_vg = $epitagh_vg;
        
        return $this;
    }
    /**
     * Get vg_child value
     * @return string[]
     */
    public function getVg_child(): ?array
    {
        return $this->vg_child;
    }
    /**
     * This method is responsible for validating the value(s) passed to the setVg_child method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVg_child method
     * This has to validate that each item contained by the array match the itemType constraint
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVg_childForArrayConstraintFromSetVg_child(?array $values = []): string
    {
        if (!is_array($values)) {
            return '';
        }
        $message = '';
        $invalidValues = [];
        foreach ($values as $rEADResponseVg_childItem) {
            // validation for constraint: itemType
            if (!is_string($rEADResponseVg_childItem)) {
                $invalidValues[] = is_object($rEADResponseVg_childItem) ? get_class($rEADResponseVg_childItem) : sprintf('%s(%s)', gettype($rEADResponseVg_childItem), var_export($rEADResponseVg_childItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The vg_child property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        
        return $message;
    }
    /**
     * Set vg_child value
     * @throws InvalidArgumentException
     * @param string[] $vg_child
     * @return \CreateStruct\Iben_createREADResponse
     */
    public function setVg_child(?array $vg_child = null): self
    {
        // validation for constraint: array
        if ('' !== ($vg_childArrayErrorMessage = self::validateVg_childForArrayConstraintFromSetVg_child($vg_child))) {
            throw new InvalidArgumentException($vg_childArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(35)
        if (is_array($vg_child) && count($vg_child) > 35) {
            throw new InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 35', count($vg_child)), __LINE__);
        }
        $this->vg_child = $vg_child;
        
        return $this;
    }
    /**
     * Add item to vg_child value
     * @throws InvalidArgumentException
     * @param string $item
     * @return \CreateStruct\Iben_createREADResponse
     */
    public function addToVg_child(string $item): self
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new InvalidArgumentException(sprintf('The vg_child property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(35)
        if (is_array($this->vg_child) && count($this->vg_child) >= 35) {
            throw new InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 35', count($this->vg_child)), __LINE__);
        }
        $this->vg_child[] = $item;
        
        return $this;
    }
}
