<?php
if ( ! defined( 'WPINC' ) ) {
	wp_die();
}
/**
 *
 * @since     2.7.0
 */
if ( ! function_exists( 'iben_elta_log_report' ) ) {
    function iben_elta_log_report( $logdata, $log_file = 'general', $type = 'debug', $error_log = false ) {
        
        if( function_exists("wc_get_logger") ) {
            $logger = wc_get_logger();

            
            $context = array( 'source' => 'iben_elta_'.$log_file.'_' );

            if ( is_array( $logdata ) || is_object( $logdata ) ) {
                
                $logger->log( $type, print_r( $logdata, true ), $context );
            }else{
                $logger->log( $type, $logdata, $context );
            }
                
        }
        
        if( $error_log ){
            if ( is_array( $logdata ) || is_object( $logdata ) ) {
                error_log( print_r( $logdata, true ) );
            } else {
                error_log( $logdata );
            }
        }
    }
}


if ( ! function_exists( 'iben_elta_get_order_status_text' ) ) {
    function iben_elta_get_order_status_text($status) {
        if (!$status) return -1;

        $statuses = wc_get_order_statuses();

        foreach($statuses as $key=>$stat){
            if ($key == $status){
                return $stat;
            }
        }
        if (!$stat) return -1;

    }
}

if ( ! function_exists( 'iben_elta_Voucher_Link' ) ) {
    function iben_elta_Voucher_Link($name){
        $img_pdf = '<img class="iben_elta_order_voucher_link_img" src="' . esc_url( plugins_url( 'admin/assets/file_pdf.png', dirname(__FILE__) ) ) . '" >';
        return '<span class="iben_elta_order_voucher_link">'.$name.'<a href="'.IBEN_WOO_ELTA_UPLOAD_VOUCHER_URL.$name.'.pdf" target="_blank">'.$img_pdf.' </a></span>';
    }
}


if ( ! function_exists( 'iben_elta_Compined_Voucher_Link' ) ) {
    function iben_elta_Compined_Voucher_Link($name){
        $img_pdf = '<img class="iben_elta_order_voucher_compined_link_img" src="' . esc_url( plugins_url( 'admin/assets/file_pdf.png', dirname(__FILE__) ) ) . '" >';
        return '<span class="iben_elta_order_voucher_compined_link"><a href="'.IBEN_WOO_ELTA_UPLOAD_VOUCHER_URL.$name.'.pdf" target="_blank">'.$name.$img_pdf.' </a></span>';
    }
}


if ( ! function_exists( 'iben_elta_get_order_status_value' ) ) {
    function iben_elta_get_order_status_value($status) {
        if (!$status) return -1;

        return $status = str_replace( 'wc-', '', $status );

    }
}

if ( ! function_exists( 'iben_elta_get_Vouchers_from_id_order' ) ) {
    function iben_elta_get_Vouchers_from_id_order($id_order){

        global $wpdb;
        $table_name = $wpdb->prefix . 'iben_elta_vouchers';

        $qry = $wpdb->prepare("SELECT * from $table_name WHERE id_order = %d AND id_elta_reason = 1 AND deleted = 0", $id_order);
        
        return $wpdb->get_results( $qry );
        
    }
}

if ( ! function_exists( 'iben_elta_get_Array_Vouchers_from_id_order' ) ) {
    function iben_elta_get_Array_Vouchers_from_id_order($id_order){

        global $wpdb;
        $table_name = $wpdb->prefix . 'iben_elta_vouchers';
        
        
        $qry = $wpdb->prepare("SELECT elta_delivery_vouchers, time from $table_name WHERE id_order = %d AND id_elta_reason = 1 AND deleted = 0", $id_order);
        
        $get_results = $wpdb->get_results( $qry );

        $vouchers = array();
        $times = array();

        foreach ( $get_results as $qry1){
            $voucher = json_decode($qry1->elta_delivery_vouchers);
            if ( is_array( $voucher ) ) {
                foreach ( $voucher as $qry2){
                    $vouchers[] = $qry2;
                    $times[] = $qry1->time;
                }
            }
        }

        $result = array(
            'elta_delivery_vouchers' => $vouchers,
            'time'                   => $times,
        );

        if ( ! empty( $vouchers ) ){
            return $result;
        }else{
            return 0;
        }
        
    }
}

if ( ! function_exists( 'iben_elta_get_ReturnedVouchers_from_id_order' ) ) {
    function iben_elta_get_ReturnedVouchers_from_id_order($id_order){

        global $wpdb;
        $table_name = $wpdb->prefix . 'iben_elta_vouchers';

        $qry = $wpdb->prepare("SELECT * from $table_name WHERE id_order = %d AND id_elta_reason = 2 AND deleted = 0", $id_order);

        return $wpdb->get_results( $qry );
    }
}

if ( ! function_exists( 'iben_elta_get_account_from_delivery_voucher' ) ) {
    function iben_elta_get_account_from_delivery_voucher($voucher){

        global $wpdb;
        $table_name = $wpdb->prefix . 'iben_elta_vouchers';

        $result = $wpdb->get_row($wpdb->prepare("SELECT id_elta_account FROM $table_name WHERE elta_delivery_vouchers LIKE %s", '%' . $wpdb->esc_like($voucher) . '%'));  

        if ($result){
            return $elta_account = $result->id_elta_account;

        }else{
            return 0;
        }
        
    }
}


if ( ! function_exists( 'iben_elta_get_account_from_returned_voucher' ) ) {
    function iben_elta_get_account_from_returned_voucher($voucher){

        global $wpdb;
        $table_name = $wpdb->prefix . 'iben_elta_vouchers';

        $result = $wpdb->get_row($wpdb->prepare("SELECT id_elta_account FROM $table_name WHERE elta_returned_vouchers LIKE %s", '%' . $wpdb->esc_like($voucher) . '%'));  

        if ($result){
            return $elta_account = $result->id_elta_account;

        }else{
            return 0;
        }
        
    }
}

if ( ! function_exists( 'iben_elta_get_Array_Returned_Vouchers_from_id_order' ) ) {
    function iben_elta_get_Array_Returned_Vouchers_from_id_order($id_order){

        global $wpdb;
        $table_name = $wpdb->prefix . 'iben_elta_vouchers';

        $get_results = $wpdb->get_results(
            $wpdb->prepare(
                "SELECT elta_returned_vouchers, time FROM $table_name WHERE id_order = %d AND id_elta_reason = 2 AND deleted = 0",
                $id_order
            )
        );

        $vouchers = array();
        $times = array();

        foreach ( $get_results as $qry1){
            $voucher = json_decode($qry1->elta_returned_vouchers);
            if ( is_array( $voucher ) ) {
                foreach ( $voucher as $qry2){
                    $vouchers[] = $qry2;
                    $times[] = $qry1->time;
                }
            }
        }

        $result = array(
            'elta_returned_vouchers' => $vouchers,
            'time'                    => $times,
        );

        if ( ! empty( $vouchers ) ){
            return $result;
        }else{
            return 0;
        }
    }
}

if ( ! function_exists( 'iben_elta_get_Array_Vouchers_from_id' ) ) {
    function iben_elta_get_Array_Vouchers_from_id($id){

        global $wpdb;
        $table_name = $wpdb->prefix . 'iben_elta_vouchers';

        $result = $wpdb->get_row($wpdb->prepare("SELECT elta_delivery_vouchers FROM $table_name WHERE id = %d", $id));  

        if ($result){

            $result = json_decode($result->elta_delivery_vouchers);
            return $result;

        }else{
            return 0;
        }
    }
}

if ( ! function_exists( 'iben_elta_get_Array_Returned_Vouchers_from_id' ) ) {
    function iben_elta_get_Array_Returned_Vouchers_from_id($id){

        global $wpdb;
        $table_name = $wpdb->prefix . 'iben_elta_vouchers';

        $result = $wpdb->get_row($wpdb->prepare("SELECT elta_returned_vouchers FROM $table_name WHERE id = %d", $id));  

        if ($result){

            $result = json_decode($result->elta_returned_vouchers);
            return $result;
            
        }else{
            return 0;
        }
    }
}

if ( ! function_exists( 'iben_elta_get_Compined_Voucher_from_id_order' ) ) {
    function iben_elta_get_Compined_Voucher_from_id_order($id_order){

        global $wpdb;
        $table_name = $wpdb->prefix . 'iben_elta_vouchers';

        $result = $wpdb->get_row($wpdb->prepare("SELECT elta_delivery_compined_vouchers FROM $table_name WHERE id_order = %d AND id_elta_reason = 1 AND deleted = 0", $id_order));  

        if ($result){
            $result = $result->elta_delivery_compined_vouchers;

            return $result;
        }else{
            return 0;
        }
    }
}

if ( ! function_exists( 'iben_elta_get_Compined_Voucher_from_id' ) ) {
    function iben_elta_get_Compined_Voucher_from_id($id){

        global $wpdb;
        $table_name = $wpdb->prefix . 'iben_elta_vouchers';

        $result = $wpdb->get_row($wpdb->prepare("SELECT elta_delivery_compined_vouchers FROM $table_name WHERE id = %d AND id_elta_reason = 1 AND deleted = 0", $id));  

        if ($result){
            $result = $result->elta_delivery_compined_vouchers;

            return $result;
        }else{
            return 0;
        }
    }
}

if ( ! function_exists( 'iben_elta_get_Compined_Returned_Voucher_from_id_order' ) ) {
    function iben_elta_get_Compined_Returned_Voucher_from_id_order($id_order){

        global $wpdb;
        $table_name = $wpdb->prefix . 'iben_elta_vouchers';

        $result = $wpdb->get_row($wpdb->prepare("SELECT elta_returned_compined_vouchers FROM $table_name WHERE id_order = %d AND id_elta_reason = 2 AND deleted = 0", $id_order));  

        if ($result){
            $result = $result->elta_returned_compined_vouchers;
            
            return $result;
        }else{
            return 0;
        }
    }
}

if ( ! function_exists( 'iben_elta_get_Compined_Returned_Voucher_from_id' ) ) {
    function iben_elta_get_Compined_Returned_Voucher_from_id($id){

        global $wpdb;
        $table_name = $wpdb->prefix . 'iben_elta_vouchers';

        $result = $wpdb->get_row($wpdb->prepare("SELECT elta_returned_compined_vouchers FROM $table_name WHERE id = %d AND id_elta_reason = 2 AND deleted = 0", $id));  

        if ($result){
            $result = $result->elta_returned_compined_vouchers;
            
            return $result;
        }else{
            return 0;
        }
    }
}

if ( ! function_exists( 'iben_elta_get_BulktoDelete' ) ) {
    function iben_elta_get_BulktoDelete(){

        global $wpdb;
        $table_name = $wpdb->prefix . 'iben_elta_bulk_vouchers';

        // 1 hour = 3600
        $add_time =  current_time('timestamp') - 30; 

        return $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE time < %d", $add_time));
    }
}

// thanks
// https://gist.github.com/gecon/3dfe1ff6baa1e646b170
if ( ! function_exists( 'iben_elta_upper_no_accents' ) ) {
    function iben_elta_upper_no_accents($string, $enc = "utf-8") {
        return strtr(mb_strtoupper($string, $enc),
        array('Ά' => 'Α', 'Έ' => 'Ε', 'Ί' => 'Ι', 'Ή' => 'Η', 'Ύ' => 'Υ',
            'Ό' => 'Ο', 'Ώ' => 'Ω', 'A' => 'A', 'A' => 'A', 'A' => 'A', 'A' => 'A',
            'Y' => 'Y','ΐ' => 'Ϊ'
        ));
    }
}

if ( ! function_exists( 'iben_elta_get_cod_all' ) ) {
    function iben_elta_get_cod_all(){
        global $wpdb;
        $table_name = $wpdb->prefix . 'iben_elta_vouchers';

        $query = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE deleted = 0"));
        $total_cod = 0;
        foreach ($query as $info){
            $_info = maybe_unserialize($info->elta_voucher_info);
            if ( isset($_info['cash_delivery']) && $_info['cash_delivery'] > 0){
                $total_cod = $total_cod + $_info['cash_delivery'];
            }
        }
        return $total_cod;
    }
}

if ( ! function_exists( 'iben_elta_get_cod_delivered' ) ) {
    function iben_elta_get_cod_delivered(){
        global $wpdb;
        $table_name = $wpdb->prefix . 'iben_elta_vouchers';

        $query = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE delivered = 1 AND deleted = 0"));
        $total_cod = 0;
        foreach ($query as $info){
            $_info = maybe_unserialize($info->elta_voucher_info);
            if ( isset($_info['cash_delivery']) && $_info['cash_delivery'] > 0){
                $total_cod = $total_cod + $_info['cash_delivery'];
            }
        }
        return $total_cod;
    }
}

if ( ! function_exists( 'iben_elta_get_cod_undelivered' ) ) {
    function iben_elta_get_cod_undelivered(){
        global $wpdb;
        $table_name = $wpdb->prefix . 'iben_elta_vouchers';

        $query = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE delivered < 1 AND deleted = 0"));
        $total_cod = 0;
        foreach ($query as $info){
            $_info = maybe_unserialize($info->elta_voucher_info);
            if ( isset($_info['cash_delivery']) && $_info['cash_delivery'] > 0){
                $total_cod = $total_cod + $_info['cash_delivery'];
            }
        }
        return $total_cod;
    }
}

if ( ! function_exists( 'iben_elta_get_cod_returned' ) ) {
    function iben_elta_get_cod_returned(){
        global $wpdb;
        $table_name = $wpdb->prefix . 'iben_elta_vouchers';

        $query = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE delivered = 2 AND deleted = 0"));
        $total_cod = 0;
        foreach ($query as $info){
            $_info = maybe_unserialize($info->elta_voucher_info);
            if ( isset($_info['cash_delivery']) && $_info['cash_delivery'] > 0){
                $total_cod = $total_cod + $_info['cash_delivery'];
            }
        }
        return $total_cod;
    }
}

if ( ! function_exists( 'iben_elta_get_cod_riskreturning' ) ) {
    function iben_elta_get_cod_riskreturning(){
        global $wpdb;
        $table_name = $wpdb->prefix . 'iben_elta_vouchers';

        $query = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE delivered = 3 AND deleted = 0"));
        $total_cod = 0;
        foreach ($query as $info){
            $_info = maybe_unserialize($info->elta_voucher_info);
            if ( isset($_info['cash_delivery']) && $_info['cash_delivery'] > 0){
                $total_cod = $total_cod + $_info['cash_delivery'];
            }
        }
        return $total_cod;
    }
}

// SINCE 2.8.0
function iben_elta_is_greek_mobile($number) {
    // Clean the number from non-digit characters
    $number = preg_replace('/\D/', '', $number);

    // Check if the number has 10 digits
    if (strlen($number) === 10) {
        // Check if it starts with a valid Greek mobile prefix
        $prefix = substr($number, 0, 2);
        if (in_array($prefix, ['69'])) {
            return true;
        }
    } elseif (strlen($number) > 10) {
        // Check if there is a prefix and try to remove it
        $prefix = substr($number, 0, 2);
        if ($prefix === '30' || $prefix === '69') {
            // Remove the prefix
            $number = substr($number, 2);

            // Cleaned number should be 10 digits, check if it is valid
            return iben_elta_is_greek_mobile($number);
        }
    }

    return false;
}

/**
 * Validate file path for secure file operations (unlink, etc.)
 * 
 * @param string $file_path The file path to validate
 * @param string $allowed_directory The allowed directory (default: IBEN_WOO_ELTA_UPLOAD_FOLDER)
 * @return string|false Returns validated file path or false if invalid
 * @since 4.0.2
 */
if ( ! function_exists( 'iben_elta_validate_file_path' ) ) {
    function iben_elta_validate_file_path( $file_path, $allowed_directory = '' ) {
        // Remove any null bytes
        $file_path = str_replace( "\0", '', $file_path );
        
        // Get real path to resolve any ../ or ./ sequences
        $real_path = realpath( dirname( $file_path ) );
        $file_name = basename( $file_path );
        
        // If no allowed directory specified, use upload directory
        if ( empty( $allowed_directory ) ) {
            $allowed_directory = IBEN_WOO_ELTA_UPLOAD_FOLDER;
        }
        
        // Ensure the resolved path is within the allowed directory
        if ( $real_path === false || strpos( $real_path, realpath( $allowed_directory ) ) !== 0 ) {
            error_log('ELTA Security: File path outside allowed directory: ' . $file_path);
            return false;
        }
        
        // Validate file name doesn't contain dangerous characters
        if ( preg_match( '/[^a-zA-Z0-9._-]/', $file_name ) ) {
            error_log('ELTA Security: Invalid characters in filename: ' . $file_name);
            return false;
        }
        
        // Additional security: Check file extension for PDF files
        $allowed_extensions = array('.pdf');
        $file_extension = strtolower(substr($file_name, strrpos($file_name, '.')));
        if (!in_array($file_extension, $allowed_extensions)) {
            error_log('ELTA Security: Invalid file extension: ' . $file_extension);
            return false;
        }
        
        return $real_path . DIRECTORY_SEPARATOR . $file_name;
    }
}

/**
 * Secure file deletion with path validation
 * 
 * @param string $file_path The file path to delete
 * @param string $allowed_directory The allowed directory (optional)
 * @return bool Returns true on success, false on failure
 * @since 4.0.2
 */
if ( ! function_exists( 'iben_elta_secure_unlink' ) ) {
    function iben_elta_secure_unlink( $file_path, $allowed_directory = '' ) {
        // Validate the file path first
        $validated_path = iben_elta_validate_file_path( $file_path, $allowed_directory );
        
        if ( $validated_path === false ) {
            iben_elta_log_report('ELTA Security: File deletion blocked - invalid path: ' . $file_path, 'security', 'warning', true);
            return false;
        }
        
        // Check if file exists before attempting to delete
        if ( ! file_exists( $validated_path ) ) {
            iben_elta_log_report('ELTA Security: Attempted to delete non-existent file: ' . $file_path, 'security', 'warning');
            return false;
        }
        
        // Attempt to delete the file
        if ( unlink( $validated_path ) ) {
            
            return true;
        } else {
            iben_elta_log_report('ELTA Security: Failed to delete file: ' . $file_path, 'security', 'error', true);
            return false;
        }
    }
}

// Added default phone format filter as of version 1.7.2
if ( ! function_exists( 'iben_elta_change_phone_format' ) ) {
    /**
     * Normalize phone numbers used by ELTA Courier
     *
     * Removes spaces and optional +30 prefix.
     *
     * @since 4.1.0
     *
     * @param string $phone Raw phone number.
     * @return string Sanitized phone number.
     */
    function iben_elta_change_phone_format( $phone ) {
        $phone = str_replace( ' ', '', $phone );
        $phone = preg_replace( '/^\+?3(0)?/', '', $phone );

        return $phone;
    }
}

// Apply the phone format filter automatically
if ( ! has_filter( 'iben_elta_phone_format', 'iben_elta_change_phone_format' ) ) {
    add_filter( 'iben_elta_phone_format', 'iben_elta_change_phone_format', 10 );
}

?>