<?php
if ( ! defined( 'WPINC' ) ) {
	wp_die();
}

/**
 * The file that defines the core plugin class
 *
 * A class definition that includes attributes and functions used across both the
 * public-facing side of the site and the admin area.
 *
 * @link       https://iben.pro
 * @since      1.0.0
 *
 * @package    Iben_Woo_Elta_Courier
 * @subpackage Iben_Woo_Elta_Courier/includes
 */

/**
 * The core plugin class.
 *
 * This is used to define internationalization, admin-specific hooks, and
 * public-facing site hooks.
 *
 * Also maintains the unique identifier of this plugin as well as the current
 * version of the plugin.
 *
 * @since      1.0.0
 * @package    Iben_Woo_Elta_Courier
 * @subpackage Iben_Woo_Elta_Courier/includes
 * @author     iBen <info@ibenetos.com>
 */
class Iben_Woo_Elta_Courier {
	/**
	 * The loader that's responsible for maintaining and registering all hooks that power
	 * the plugin.
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      Iben_Woo_Elta_Courier_Loader    $loader    Maintains and registers all hooks for the plugin.
	 */
	protected $loader;


	/**
	 * The current version of the plugin.
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      string    $version    The current version of the plugin.
	 */
	protected $version;

	static $instance = false;

	public function __construct() {

		$this->load_dependencies();
		$this->set_locale();
	
	}

	/**
	 * If an instance exists, this returns it.  If not, it creates one and retuns it.
	 *
	 * @return Iben_Woo_Elta_Courier
	 */

	public static function getInstance() {
		if ( !self::$instance )
			self::$instance = new self;

		return self::$instance;
	}
	
	
	/**
	 * Load the required dependencies for this plugin.
	 *
	 * Include the following files that make up the plugin:
	 *
	 * - Iben_Woo_Elta_Courier_Loader. Orchestrates the hooks of the plugin.
	 * - Iben_Woo_Elta_Courier_i18n. Defines internationalization functionality.
	 *
	 * Create an instance of the loader which will be used to register the hooks
	 * with WordPress.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function load_dependencies() {

		// The class responsible for orchestrating the actions and filters of the core plugin.
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-iben-woo-elta-courier-loader.php';
		
		// The class responsible for defining internationalization
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-iben-woo-elta-courier-i18n.php';
		
		$this->loader = new Iben_Woo_Elta_Courier_Loader();

	}

	/**
	 * Define the locale for this plugin for internationalization.
	 *
	 * Uses the Iben_Woo_Elta_Courier_i18n class in order to set the domain and to register the hook
	 * with WordPress.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function set_locale() {

		$plugin_i18n = new Iben_Woo_Elta_Courier_i18n();

		$this->loader->add_action( 'plugins_loaded', $plugin_i18n, 'iben_load_plugin_textdomain' );

	}


	/**
	 * Run the loader to execute all of the hooks with WordPress.
	 *
	 * @since    1.0.0
	 */
	public function run() {
		$this->loader->run();
	}

	/**
	 * The reference to the class that orchestrates the hooks with the plugin.
	 *
	 * @since     1.0.0
	 * @return    Iben_Woo_Elta_Courier_Loader    Orchestrates the hooks of the plugin.
	 */
	public function get_loader() {
		return $this->loader;
	}

	

	public function iben_elta_Voucher_Link($name){
		_deprecated_function( __FUNCTION__, '1.10.0', 'the simple function iben_elta_Voucher_Link() without calling class first' );		
		return iben_elta_Voucher_Link($name);
	}

	/**
	 *
	 * @since 1.0.0
	 * @deprecated 1.10.0
	 *
	 */		
	public function iben_elta_Compined_Voucher_Link($name){
		_deprecated_function( __FUNCTION__, '1.10.0', 'the simple function iben_elta_Compined_Voucher_Link() without calling class first' );		
		return iben_elta_Compined_Voucher_Link($name);
	}


	/**
	 *
	 * @since 1.0.0
	 * @deprecated 1.10.0
	 *
	 */		
	public function iben_elta_get_Vouchers_from_id_order($id_order){
		_deprecated_function( __FUNCTION__, '1.10.0', 'the simple function iben_elta_get_Vouchers_from_id_order() without calling class first' );		
		return iben_elta_get_Vouchers_from_id_order($id_order);
		
	}

	/**
	 *
	 * @since 1.0.0
	 * @deprecated 1.10.0
	 *
	 */	
	public function iben_elta_get_ReturnedVouchers_from_id_order($id_order){
		_deprecated_function( __FUNCTION__, '1.10.0', 'the simple function iben_elta_get_ReturnedVouchers_from_id_order() without calling class first' );
		return iben_elta_get_ReturnedVouchers_from_id_order($id_order);
	}	

	/**
	 *
	 * @since 1.0.0
	 * @deprecated 1.10.0
	 *
	 */
	public function iben_elta_get_Array_Vouchers_from_id_order($id_order){
		_deprecated_function( __FUNCTION__, '1.10.0', 'the simple function iben_elta_get_Array_Vouchers_from_id_order() without calling class first' );
		return iben_elta_get_Array_Vouchers_from_id_order($id_order);
	}

	/**
	 *
	 * @since     1.4.1
	 * @deprecated 1.10.0
	 */	
	public function iben_elta_get_account_from_delivery_voucher($voucher){
		_deprecated_function( __FUNCTION__, '1.10.0', 'the simple function iben_elta_get_account_from_delivery_voucher() without calling class first' );
		return iben_elta_get_account_from_delivery_voucher($voucher);
	}

	/**
	 *
	 * @since     1.4.1
	 * @deprecated 1.10.0
	 */	
	public function iben_elta_get_account_from_returned_voucher($voucher){

		_deprecated_function( __FUNCTION__, '1.10.0', 'the simple function iben_elta_get_account_from_returned_voucher() without calling class first' );
		return iben_elta_get_account_from_returned_voucher($voucher);
		
	}

	/**
	 *
	 * @since     1.0.0
	 * @deprecated 1.10.0
	 */	
	public function iben_elta_get_Array_Returned_Vouchers_from_id_order($id_order){
		_deprecated_function( __FUNCTION__, '1.10.0', 'the simple function iben_elta_get_Array_Returned_Vouchers_from_id_order() without calling class first' );
		return iben_elta_get_Array_Returned_Vouchers_from_id_order($id_order);
	}
	
	/**
	 *
	 * @since     1.0.0
	 * @deprecated 1.10.0
	 */		
	public function iben_elta_get_Array_Vouchers_from_id($id){

		_deprecated_function( __FUNCTION__, '1.10.0', 'the simple function iben_elta_get_Array_Vouchers_from_id() without calling class first' );
		return iben_elta_get_Array_Vouchers_from_id($id);
	}

	/**
	 *
	 * @since     1.0.0
	 * @deprecated 1.10.0
	 */	
	public function iben_elta_get_Array_Returned_Vouchers_from_id($id){

		_deprecated_function( __FUNCTION__, '1.10.0', 'the simple function iben_elta_get_Array_Returned_Vouchers_from_id() without calling class first' );
		return iben_elta_get_Array_Returned_Vouchers_from_id($id);
	}

	/**
	 *
	 * @since     1.0.0
	 * @deprecated 1.10.0
	 */	
	public function iben_elta_get_Compined_Voucher_from_id_order($id_order){

		_deprecated_function( __FUNCTION__, '1.10.0', 'the simple function iben_elta_get_Compined_Voucher_from_id_order() without calling class first' );
		return iben_elta_get_Compined_Voucher_from_id_order($id_order);
	}

	/**
	 *
	 * @since     1.3.0
	 * @deprecated 1.10.0
	 */		
	public function iben_elta_get_Compined_Voucher_from_id($id){

		_deprecated_function( __FUNCTION__, '1.10.0', 'the simple function iben_elta_get_Compined_Voucher_from_id() without calling class first' );
		return iben_elta_get_Compined_Voucher_from_id($id);
	}	

	/**
	 *
	 * @since     1.0.0
	 * @deprecated 1.10.0
	 */	
	public function iben_elta_get_Compined_Returned_Voucher_from_id_order($id_order){

		_deprecated_function( __FUNCTION__, '1.10.0', 'the simple function iben_elta_get_Compined_Returned_Voucher_from_id_order() without calling class first' );
		return iben_elta_get_Compined_Returned_Voucher_from_id_order($id_order);
	}	

	/**
	 *
	 * @since     1.3.0
	 * @deprecated 1.10.0
	 */		
	public function iben_elta_get_Compined_Returned_Voucher_from_id($id){

		_deprecated_function( __FUNCTION__, '1.10.0', 'the simple function iben_elta_get_Compined_Returned_Voucher_from_id() without calling class first' );
		return iben_elta_get_Compined_Returned_Voucher_from_id($id);
	}		

	/**
	 *
	 * @since     1.0.0
	 * @deprecated 1.10.0
	 */	
	public function iben_elta_get_BulktoDelete(){
		_deprecated_function( __FUNCTION__, '1.10.0', 'the simple function iben_elta_get_BulktoDelete() without calling class first' );
		return iben_elta_get_BulktoDelete();

	}








}
