<?php
if ( ! defined( 'WPINC' ) ) {
	wp_die();
}

use Automattic\WooCommerce\Utilities\OrderUtil;
use Automattic\WooCommerce\Internal\DataStores\Orders\CustomOrdersTableController;

class Iben_Woo_Elta_Courier_Woo extends Iben_Woo_Elta_Courier{
	
	static $instance = false;

    public function __construct() {
        parent::__construct();
	}

	public static function getInstance() {
		if ( !self::$instance )
			self::$instance = new self;

		return self::$instance;
	}

    public function run() {
		require_once IBEN_WOO_ELTA_ROOT_DIR . 'includes/functions.php';
		require_once IBEN_WOO_ELTA_ROOT_DIR . 'admin/partials/iben-woo-elta-courier-admin-display.php';	
		$this->define_admin_woo_hooks();
		$this->loader->run();
	}


	private function define_admin_woo_hooks() {
		
		$this->iben_elta_update_db_check();

		
		if ( is_admin() ) :
			require_once IBEN_WOO_ELTA_ROOT_DIR . 'admin/partials/class-iben-elta-license.php';
			require_once IBEN_WOO_ELTA_ROOT_DIR . 'admin/partials/class-iben-elta-license-init.php';
			new IbenELTALicenceInit();
		endif;		

	    require_once IBEN_WOO_ELTA_ROOT_DIR . 'admin/class-iben-woo-elta-courier-admin-woo.php';

		$plugin_admin = new Iben_Woo_Elta_Courier_Admin_Woo();

		// INSTANCE OF SETTINGS VALUES
		$main_settings = get_option('iben_elta_main_settings_fields'); 


		$this->loader->add_action( 'admin_enqueue_scripts', $plugin_admin, 'iben_enqueue_styles' );
		$this->loader->add_action( 'admin_enqueue_scripts', $plugin_admin, 'iben_enqueue_scripts' );

		$this->loader->add_action('add_meta_boxes', $plugin_admin, 'iben_elta_add_order_metabox', 20);

		$this->loader->add_action( 'wp_ajax_iben_elta_create_voucher_ajax_hook', $plugin_admin, 'iben_elta_create_voucher_handler' );
		
		//SINGLE VOUCHER
		$this->loader->add_action( 'wp_ajax_iben_elta_create_single_voucher_ajax_hook', $plugin_admin, 'iben_elta_create_single_voucher_handler' );
		
		
		//UPDATE POST META for order when checkbox is clicked		
		$this->loader->add_action( 'wp_ajax_iben_elta_change_postmeta_attach_tracking_info_email_ajax_hook', $plugin_admin, 'iben_elta_change_postmeta_attach_tracking_info_email_ajax_handler' );
		
		//UPDATE POST META for order when SMS checkbox is clicked
		$this->loader->add_action( 'wp_ajax_iben_elta_change_postmeta_send_sms_completed_ajax_hook', $plugin_admin, 'iben_elta_change_postmeta_send_sms_completed_ajax_handler' ); 
		
		$this->loader->add_action( 'wp_ajax_iben_elta_returned_vouchers_ajax_hook', $plugin_admin, 'iben_elta_create_returned_voucher_ajax_handler' );
	
		// compine delivery vouchers
		$this->loader->add_action( 'wp_ajax_iben_elta_compine_vouchers_ajax_hook', $plugin_admin, 'iben_elta_compine_vouchers_ajax_handler' );
	
		// compine SIGNLE delivery vouchers
		$this->loader->add_action( 'wp_ajax_iben_elta_compine_single_vouchers_ajax_hook', $plugin_admin, 'iben_elta_compine_single_vouchers_ajax_handler' );


		// SAVE CONTACT SINGLE TO LIST
		$this->loader->add_action( 'wp_ajax_iben_elta_save_single_contact_ajax_hook', $plugin_admin, 'iben_elta_save_single_contact_handler' );
		// LOAD CONTACT SINGLE TO LIST
		$this->loader->add_action( 'wp_ajax_iben_elta_load_single_contact_ajax_hook', $plugin_admin, 'iben_elta_load_single_contact_handler' );

		
		// Reprint multi vouchers
		$this->loader->add_action( 'wp_ajax_iben_elta_bulk_reprint_vouchers_ajax_hook', $plugin_admin, 'iben_elta_bulk_reprint_vouchers_ajax_handler' );

		/**
		 * Create multi vouchers and print
		 *
		 * @since     1.7.5
		 */		
		
		$this->loader->add_action( 'wp_ajax_iben_elta_bulk_create_vouchers_ajax_hook', $plugin_admin, 'iben_elta_bulk_create_vouchers_ajax_handler' );



		// compine delivery vouchers
		$this->loader->add_action( 'wp_ajax_iben_elta_compine_returned_vouchers_ajax_hook', $plugin_admin, 'iben_elta_compine_returned_vouchers_ajax_handler' );
		
		// tracing on order page
		$this->loader->add_action( 'wp_ajax_iben_elta_tracing_ajax_hook', $plugin_admin, 'iben_elta_tracing_ajax_handler' );
		
		// check delivery of voucher
		$this->loader->add_action( 'wp_ajax_iben_elta_check_delivery_voucher_list_ajax_hook', $plugin_admin, 'iben_elta_check_delivery_list_ajax_handler' );


		// modal voucher info
		$this->loader->add_action( 'wp_ajax_iben_elta_voucher_info_modal_ajax_handler_hook', $plugin_admin, 'iben_elta_voucher_info_modal_ajax_handler' );		
		//modal tracing
		$this->loader->add_action( 'wp_ajax_iben_elta_voucher_tracing_modal_ajax_handler_hook', $plugin_admin, 'iben_elta_voucher_tracing_modal_ajax_handler' );		
		
		$this->loader->add_action( 'wp_ajax_iben_elta_voucher_create_modal_ajax_handler_hook', $plugin_admin, 'iben_elta_voucher_create_modal_ajax_handler' );		
		
		// modal for EMPTY VOUCHER
		$this->loader->add_action( 'wp_ajax_iben_elta_voucher_create_single_modal_ajax_handler_hook', $plugin_admin, 'iben_elta_voucher_create_single_modal_ajax_handler' );		


		// station
		$this->loader->add_action( 'wp_ajax_iben_elta_station_ajax_hook', $plugin_admin, 'iben_elta_station_ajax_handler' );
		//Station Display via ajax on load
		$this->loader->add_action( 'wp_ajax_iben_elta_station_onload_ajax_hook', $plugin_admin, 'iben_elta_station_onload_ajax_handler' );

		$this->loader->add_action( 'wp_ajax_iben_elta_settings_remove_bulk_ajax_hook', $plugin_admin, 'iben_elta_settings_remove_bulk_ajax_handler' );

		// order list columns
		
		if (class_exists('Automattic\WooCommerce\Utilities\OrderUtil') && Automattic\WooCommerce\Utilities\OrderUtil::custom_orders_table_usage_is_enabled()) {
			$this->loader->add_filter( 'manage_woocommerce_page_wc-orders_columns', $plugin_admin, 'iben_elta_add_order_vouchers_column_header', 20 );
			$this->loader->add_action( 'manage_woocommerce_page_wc-orders_custom_column', $plugin_admin, 'iben_elta_add_order_vouchers_column_content', 10, 2 );
		}else{
			$this->loader->add_filter( 'manage_edit-shop_order_columns', $plugin_admin, 'iben_elta_add_order_vouchers_column_header', 20 );
			$this->loader->add_action( 'manage_shop_order_posts_custom_column', $plugin_admin, 'iben_elta_add_order_vouchers_column_content', 10, 2 );
		}
		
		$this->loader->add_action( 'admin_print_styles', $plugin_admin, 'iben_elta_voucher_columns_style' );	
	


		if( isset( $main_settings['iben_elta_main_settings_frontend_view_order_tracking_tracing_enable'] ) ) {		
			$this->loader->add_action( 'woocommerce_view_order', $plugin_admin, 'iben_elta_frontend_myaccount_addtracing', 5 );
		}

		if( isset( $main_settings['iben_elta_main_settings_frontend_tracking_action_link_enable'] ) ) {
			$this->loader->add_filter( 'woocommerce_my_account_my_orders_actions', $plugin_admin, 'iben_elta_frontend_myaccount_orders_actions', 10, 2 );
			$this->loader->add_action( 'woocommerce_after_account_orders', $plugin_admin, 'iben_elta_frontend_myaccount_orders_js', 5 );
		}


		if( isset( $main_settings['iben_elta_main_settings_single_order_sms_enable'] ) ) {
			if (class_exists('Iben_Sms_Lexicon_Admin_Woo')) {
				$this->loader->add_action('iben_elta_order_right_single', $plugin_admin, 'iben_elta_sms_v2');
			}
		}


		/**
		 * Enable if settings is enabled
		 *
		 * @since     1.1.0
		 */

		if( isset( $main_settings['iben_elta_main_settings_email_completed'] ) ) {
			// display checkbox on edit order
			$this->loader->add_action( 'woocommerce_admin_order_data_after_order_details', $plugin_admin, 'iben_elta_display_checkbox_send_tracking_info' );
			
			// add info in email orders
			$this->loader->add_action( apply_filters( 'iben_elta_email_send_tracking_email_hook_filter', 'woocommerce_email_order_details'), $plugin_admin, 'iben_elta_email_send_tracking_info_handler', 10, 4 );

			// Save checkbox on edit order
			$this->loader->add_action( 'woocommerce_process_shop_order_meta', $plugin_admin, 'iben_elta_save_checkbox_send_tracking_info', 40, 2 );		
		}
		

		/**
		 * Enable if settings WP cron check delivery is enabled
		 *
		 * @since     1.2.0
		 */
		if( isset( $main_settings['iben_elta_main_settings_enable_cron_check_delivery'] ) && function_exists('wp_get_scheduled_event') ) {

			$check_time = sanitize_text_field($main_settings['iben_elta_main_settings_cron_check_time']);
			if ( isset($check_time) ){
				$time_cron = $check_time;
			}else{
				$time_cron = 'hourly';
			}
			$time_cron = apply_filters('iben_elta_filter_cron_check_time', $time_cron);
			
			$scheduled = wp_get_scheduled_event('iben_elta_cron_check_delivery');
			if ($scheduled){
				$schedule =  $scheduled->schedule;
			}else{
				$schedule =  '';
			}
			

			if ($schedule != $time_cron){
				
				wp_unschedule_hook('iben_elta_cron_check_delivery');
				//wp_clear_scheduled_hook('iben_elta_cron_check_delivery');

			}
			
			
			if (! wp_next_scheduled ( 'iben_elta_cron_check_delivery' )) {
				wp_schedule_event(time(), $time_cron, 'iben_elta_cron_check_delivery');
			}
		
			$this->loader->add_action( 'iben_elta_cron_check_delivery', $plugin_admin, 'iben_elta_cron_check_delivery_hook' );		

		}else{

			wp_clear_scheduled_hook('iben_elta_cron_check_delivery');
		}
		
		/**
		 * Enable if settings WP cron delete PDFs is enabled
		 *
		 * @since     1.4.0
		 */
		if( isset( $main_settings['iben_elta_main_settings_delete_pdf_cron_enable'] ) && function_exists('wp_get_scheduled_event') ) {

			$check_time = sanitize_text_field($main_settings['iben_elta_main_settings_delete_pdf_cron_check_time']);
			if ( isset($check_time) ){
				$time_cron = $check_time;
			}else{
				$time_cron = 'daily';
			}
			$time_cron = apply_filters('iben_elta_filter_cron_delete_pdf_check_time', $time_cron);
			
			$scheduled = wp_get_scheduled_event('iben_elta_cron_delete_pdfs');
			if ($scheduled){
				$schedule =  $scheduled->schedule;
			}else{
				$schedule =  '';
			}
			

			if ($schedule != $time_cron){
				
				wp_unschedule_hook('iben_elta_cron_delete_pdfs');

			}
			
			
			if (! wp_next_scheduled ( 'iben_elta_cron_delete_pdfs' )) {
				wp_schedule_event(time(), $time_cron, 'iben_elta_cron_delete_pdfs');
			}
		
			$this->loader->add_action( 'iben_elta_cron_delete_pdfs', $plugin_admin, 'iben_elta_cron_delete_pdfs_hook' );		

		}else{

			wp_clear_scheduled_hook('iben_elta_cron_delete_pdfs');
		}

		
		/**
		 * AUTOMATICALLY create voucher hook
		 *
		 * @since     1.6.0
		 */
		$state = apply_filters('iben_filter_auto_create_voucher_enable_filter', true);

		if( isset( $main_settings['iben_elta_main_settings_auto_createv_enable'] ) && $state ) {
				
			$this->loader->add_action( 'woocommerce_thankyou', $plugin_admin, 'iben_elta_add_order_queue',  1, 1  );
			
		 }


		/**
		 * Disable default completed email
		 *
		 * @since     1.6.0
		 */

		$filter_disable_completed = apply_filters('iben_elta_filter_disable_order_status_completed_notification', false);
		
		if($filter_disable_completed){
			$this->loader->add_action( 'woocommerce_email', $plugin_admin, 'iben_elta_disable_order_status_completed_notification');
		}


		/**
		 * Attach text in admin email if is enabled
		 *
		 * @since     1.6.0
		 */
		if( isset( $main_settings['iben_elta_main_settings_auto_createv_include_message'] ) ) {
			
			// add info in admin email
			$this->loader->add_action( 'woocommerce_email_order_details', $plugin_admin, 'iben_elta_email_send_admin_tracking_info_handler', 10, 4 );
			
			// DOKAN Comaptibility
			// attach info in vendor new order email
			if ( class_exists('WeDevs_Dokan') ){
				$this->loader->add_action( 'woocommerce_email_after_order_table', $plugin_admin, 'iben_elta_email_send_vendor_admin_dokan_tracking_info_handler', 10, 4 );
			}
		}

		/**
		 * Attach text in admin email if is enabled
		 *
		 * @since     1.6.0
		 */
		
		$display_subcode_user = apply_filters('iben_elta_filter_display_subcode_user_profile', false);
		
		if ( class_exists('WeDevs_Dokan') || $display_subcode_user ){
			
			// save on admin WP profile
			$this->loader->add_action( 'personal_options_update', $plugin_admin, 'iben_elta_save_subcode_wp_user' );
			$this->loader->add_action( 'edit_user_profile_update', $plugin_admin, 'iben_elta_save_subcode_wp_user' );
			
			// display checkbox on user WP account
			$this->loader->add_action( 'show_user_profile', $plugin_admin, 'iben_elta_display_subcode_wp_user' );
			$this->loader->add_action( 'edit_user_profile', $plugin_admin, 'iben_elta_display_subcode_wp_user' );
		}


		/**
		 *
		 * @since     1.6.0
		 */
		if( isset( $main_settings['iben_elta_main_settings_auto_createv_enable'] ) && function_exists('wp_get_scheduled_event') ) {

			if ( isset($main_settings['iben_elta_main_settings_auto_createv_cron_time']) ){
				$time_cron = sanitize_text_field($main_settings['iben_elta_main_settings_auto_createv_cron_time']);
			}else{
				$time_cron = 'iben-elta-2-minutes';
			}

			$time_cron = apply_filters('iben_elta_filter_cron_auto_createv', $time_cron);
			
			$scheduled = wp_get_scheduled_event('iben_elta_cron_create_auto_vouchers');
			if ($scheduled){
				$schedule =  $scheduled->schedule;
			}else{
				$schedule =  '';
			}
			

			if ($schedule != $time_cron){
				
				wp_unschedule_hook('iben_elta_cron_create_auto_vouchers');
				//wp_clear_scheduled_hook('iben_elta_cron_create_auto_vouchers');

			}
			
			
			if (! wp_next_scheduled ( 'iben_elta_cron_create_auto_vouchers' )) {
				wp_schedule_event(time(), $time_cron, 'iben_elta_cron_create_auto_vouchers');
			}
		

			$this->loader->add_action( 'iben_elta_cron_create_auto_vouchers', $plugin_admin, 'iben_elta_cron_create_auto_vouchers_hook' );		

		}else{

			if (wp_next_scheduled ( 'iben_elta_cron_create_auto_vouchers' )) {
				wp_clear_scheduled_hook('iben_elta_cron_create_auto_vouchers');
			}

		}
		
		
	

		if( isset( $main_settings['iben_elta_main_settings_cron_change_order_status'] ) && $main_settings['iben_elta_main_settings_cron_change_order_status'] != -1 ) {

			function iben_elta_cron_delivered_hook( $order_id, $update_id ) {

				$main_settings = get_option('iben_elta_main_settings_fields'); 
				$selected = $main_settings['iben_elta_main_settings_cron_change_order_status'];

				$order = wc_get_order( $order_id );

				if (is_a( $order, 'WC_Order' )){

					global $wpdb;
					$table_name = $wpdb->prefix . 'iben_elta_vouchers';
			
                                       $resulutes = $wpdb->get_results(
                                               $wpdb->prepare(
                                                       "SELECT id_order FROM $table_name WHERE id_order = %d AND delivered != 1 AND deleted = 0",
                                                       $order_id
                                               )
                                       );
                                       $rowcount = $wpdb->num_rows;


					$available_status = wc_get_order_statuses();
					
					if (array_key_exists($selected, $available_status) && $rowcount == 0) {
						
						$status = str_replace( 'wc-', '', $selected );
						$order->update_status( $status );
						$order->save();

					}

				}

			}


			add_action( 'iben_elta_check_delivery_hook_after_delivered', 'iben_elta_cron_delivered_hook', 10, 2 );
		}

		$this->loader->add_shortcode( 'iben_elta_tracing_shortcode', $plugin_admin, 'iben_elta_tracing_shortcode_handler' );
		$this->loader->add_shortcode( 'iben_elta_tracking_number_shortcode', $plugin_admin, 'iben_elta_tracking_number_shortcode_handler' );
		
		$this->loader->add_shortcode( 'iben_elta_courier_name_shortcode', $plugin_admin, 'iben_elta_courier_name_shortcode_handler' );

		
	}

	
	// Update plugin database, Check if version is different, then do DB updates
	function iben_elta_update_db_check(){

		if (get_option('iben_elta_version') != IBEN_WOO_ELTA_COURIER_VERSION ) {

			require_once IBEN_WOO_ELTA_ROOT_DIR . 'includes/class-iben-woo-elta-courier-activator.php';

			$activator = new Iben_Woo_Elta_Courier_Activator();
			$activator->update();
		}

	}





} 