<?php
if ( ! defined( 'WPINC' ) ) {
	wp_die();
}


/**
 * Fired during plugin deactivation
 *
 * @link       https://iben.pro
 * @since      1.0.0
 *
 * @package    Iben_Woo_Elta_Courier
 * @subpackage Iben_Woo_Elta_Courier/includes
 */

/**
 * Fired during plugin deactivation.
 *
 * This class defines all code necessary to run during the plugin's deactivation.
 *
 * @since      1.0.0
 * @package    Iben_Woo_Elta_Courier
 * @subpackage Iben_Woo_Elta_Courier/includes
 * @author     iBen <info@ibenetos.com>
 */
class Iben_Woo_Elta_Courier_Deactivator {

	/**
	 * Short Description. (use period)
	 *
	 * Long Description.
	 *
	 * @since    1.0.0
	 */
	public static function deactivate() {
		
		set_transient( 'iben_elta_activated', 0 );

		// REMOVE CRON EVENTS

		wp_clear_scheduled_hook('iben_elta_cron_check_delivery');
		//since 1.4.0
		wp_clear_scheduled_hook('iben_elta_cron_delete_pdfs');

		//since 1.6.0.1
		wp_clear_scheduled_hook('iben_elta_cron_create_auto_vouchers');
		

	}

}
