<?php
if ( ! defined( 'WPINC' ) ) {
	wp_die();
}

/**
 * Fired during plugin activation
 *
 * @link       https://iben.pro
 * @since      1.0.0
 *
 * @package    Iben_Woo_Elta_Courier
 * @subpackage Iben_Woo_Elta_Courier/includes
 */

/**
 * Fired during plugin activation.
 *
 * This class defines all code necessary to run during the plugin's activation.
 *
 * @since      1.0.0
 * @package    Iben_Woo_Elta_Courier
 * @subpackage Iben_Woo_Elta_Courier/includes
 * @author     iBen <info@ibenetos.com>
 */
class Iben_Woo_Elta_Courier_Activator {

	protected $version;
		
	public function __construct() {
		
		if ( defined( 'IBEN_WOO_ELTA_COURIER_VERSION' ) ) {
			$this->version = IBEN_WOO_ELTA_COURIER_VERSION;
		} else {
			$this->version = '1.0.0';
		}


	}	

	/**
	 *
	 * @since    1.0.0
	 */
	public function activate() {
		
		$this->iben_elta_createDB();
		$this->iben_createVouchersDirectory();		
		$this->iben_createVouchersDirectoryIndexFile();
		
		set_transient( 'iben_elta_activated', 1 );
		add_option('iben_elta_version', $this->version);

		//PUT BACK CRON IF IS ENABLED AND JUST ACTIVATED 
		$main_settings = get_option('iben_elta_main_settings_fields'); 
		if( isset( $main_settings['iben_elta_main_settings_enable_cron_check_delivery'] ) ) {
			
			if (! wp_next_scheduled ( 'iben_elta_cron_check_delivery' )) {
				wp_schedule_event(time(), 'hourly', 'iben_elta_cron_check_delivery');
			}
		}

		//since 1.4.0
		if( isset( $main_settings['iben_elta_main_settings_delete_pdf_cron_enable'] ) ) {
			
			if (! wp_next_scheduled ( 'iben_elta_cron_delete_pdfs' )) {
				wp_schedule_event(time(), 'daily', 'iben_elta_cron_delete_pdfs');
			}
		}	

	}

	
	public function update() {

		$this->iben_elta_createDB();

		//since 1.6.0
		$this->iben_createVouchersDirectory();
		$this->iben_createVouchersDirectoryIndexFile();

		$installed_ver = get_option('iben_elta_version');

		if ($installed_ver != $this->version) {
			//notice that we are updating option, rather than adding it
			update_option('iben_elta_version', $this->version);
		}

	}


	protected function iben_createVouchersDirectory(){

		$upload = wp_upload_dir();
		$upload_dir = $upload['basedir'];
		$upload_dir = $upload_dir . '/iben_elta_vouchers';

		if (! is_dir($upload_dir)) {
		   $created = wp_mkdir_p( $upload_dir );
		   if (!$created) {
		       error_log('iBen ELTA Courier: Failed to create vouchers directory: ' . $upload_dir);
		       return false;
		   }
		}
		
		return true;
	}


	//since 1.6.0
	protected function iben_createVouchersDirectoryIndexFile(){

		$upload_folder = IBEN_WOO_ELTA_UPLOAD_FOLDER;

		// Create index.php file to prevent directory listing
		$index_file = $upload_folder . 'index.php';								
		if (!is_file($index_file)) {
			file_put_contents($index_file, '<?php // Silence is golden');
		}

				// Verify the upload folder exists and is properly configured
		if (!is_dir($upload_folder)) {
			error_log('iBen ACS: Upload folder does not exist: ' . $upload_folder);
			return false;
		}

		// Set secure permissions for the index file
		if (is_file($index_file)) {
			chmod($index_file, 0644);
		}


		return true;
	}



	protected function iben_elta_createDB(){

		global $wpdb;
		$charset_collate = '';

		if (!empty($wpdb->charset)) {
			$charset_collate = "DEFAULT CHARACTER SET {$wpdb->charset}";
		}
		if (!empty($wpdb->collate)) {
			$charset_collate .= " COLLATE {$wpdb->collate}";
		}

		$table_name = $wpdb->prefix . 'iben_elta_vouchers';
		$table_name2 = $wpdb->prefix . 'iben_elta_bulk_vouchers';
		$table_name3 = $wpdb->prefix . 'iben_elta_contacts';
		$table_name4 = $wpdb->prefix . 'iben_elta_voucher_schedule';
		
	
		// 1. each field MUST be in separate line
		// 2. There must be two spaces between PRIMARY KEY and its name
		//    Like this: PRIMARY KEY[space][space](id)
		$sql = "CREATE TABLE " . $table_name . " (
			id int(11) NOT NULL AUTO_INCREMENT,
			logged_user tinytext NOT NULL,
			id_user int(5) NOT NULL,
			id_order_parent int(5) NULL DEFAULT '0',
			id_order int(5) NOT NULL,
			id_elta_account int(2) NULL DEFAULT '1',
			duplicated_record int(2) NOT NULL DEFAULT '0',
			deleted int(2) NOT NULL DEFAULT '0',
			id_elta_reason int(5) NOT NULL,
			elta_voucher_info longtext NULL,
			elta_returned_vouchers text NULL,
			elta_delivery_vouchers text NULL,			
			elta_returned_compined_vouchers varchar(250) NULL,
			elta_delivery_compined_vouchers varchar(250) NULL,
			elta_pdf_type int(3) NOT NULL DEFAULT '1',
			delivered int(2) NOT NULL DEFAULT '0',
			delivered_date varchar(15) NULL,
			delivered_time varchar(15) NULL,
			delivered_name varchar(150) NULL,
			last_check_delivered_time int(11) NOT NULL DEFAULT '0',
			email_sent int(2) NOT NULL DEFAULT '0',
			sms_sent int(2) NOT NULL DEFAULT '0',
			pdf_deleted int(2) NULL DEFAULT '0',
			time int(11) NOT NULL,
			plugin_version varchar(50) NULL,
			PRIMARY KEY  (id)
		){$charset_collate};";

		$sql2 = "CREATE TABLE " . $table_name2 . " (
			id int(11) NOT NULL AUTO_INCREMENT,
			logged_user tinytext NOT NULL,
			id_user int(5) NOT NULL,
			id_arrays text NULL,
			voucher_arrays text NULL,
			compined_pdf varchar(250) NULL,
			time int(11) NOT NULL,
			PRIMARY KEY  (id)
		){$charset_collate};";		
	

		$sql3 = "CREATE TABLE " . $table_name3 . " (
			id int(11) NOT NULL AUTO_INCREMENT,
			id_reference varchar(100) NOT NULL,
			id_user int(5) NOT NULL,
			contact_name varchar(100) NOT NULL,
			contact_address varchar(100) NOT NULL,
			contact_region varchar(100) NOT NULL,
			contact_postal varchar(50) NOT NULL,
			contact_tel1 varchar(50) NOT NULL,
			contact_tel2 varchar(50) NOT NULL,
			contact_comment varchar(100) NULL DEFAULT NULL,
			time_updated int(11) NOT NULL,
			time_created int(11) NOT NULL,
			PRIMARY KEY  (id)
		){$charset_collate};";	
		
		
		$sql4 = "CREATE TABLE " . $table_name4 . " (
			id int(11) NOT NULL AUTO_INCREMENT,
			id_order_parent int(5) NULL DEFAULT '0',
			id_order int(5) NOT NULL,
			status varchar(250) NULL,
			time int(11) NOT NULL,
			PRIMARY KEY  (id)
		){$charset_collate};";



		// we do not execute sql directly
		// we are calling dbDelta which cant migrate database
		require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
		dbDelta($sql);
		dbDelta($sql2);
		dbDelta($sql3);
		dbDelta($sql4);

		// save current database version for later use (on upgrade)
		$installed_ver = get_option('iben_elta_version');
		if ($installed_ver != $this->version) {
			//notice that we are updating option, rather than adding it
			update_option('iben_elta_version', $this->version);
		}
		
		
	}

}
